/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.proxy;

import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.http.requests.IHttpRequestTask;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.http.requests.RequestEngineException;
import com.subgraph.vega.http.requests.custom.VegaHttpEntityEnclosingUriRequest;
import com.subgraph.vega.http.requests.custom.VegaHttpUriRequest;
import com.subgraph.vega.internal.http.proxy.HttpProxyListener;
import com.subgraph.vega.internal.http.proxy.ProxyTransaction;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;

public class ProxyRequestHandler
implements HttpRequestHandler {
    private static final String[] HOP_BY_HOP_HEADERS = new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade", "Proxy-Connection"};
    private final Logger logger;
    private final HttpProxyListener httpProxy;
    private final IHttpRequestEngine requestEngine;

    ProxyRequestHandler(HttpProxyListener httpProxyListener, Logger logger, IHttpRequestEngine iHttpRequestEngine) {
        this.httpProxy = httpProxyListener;
        this.logger = logger;
        this.requestEngine = iHttpRequestEngine;
    }

    public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        ProxyTransaction proxyTransaction = new ProxyTransaction(this.requestEngine, httpContext);
        httpContext.setAttribute("proxy.transaction", (Object)proxyTransaction);
        try {
            if (!this.handleRequest(proxyTransaction, httpRequest)) {
                httpResponse.setStatusCode(503);
                proxyTransaction.signalComplete(false);
                return;
            }
            HttpUriRequest httpUriRequest = proxyTransaction.getRequest();
            IHttpRequestTask iHttpRequestTask = this.requestEngine.sendRequest(httpUriRequest);
            proxyTransaction.setRequestTask(iHttpRequestTask);
            proxyTransaction.signalForward();
            IHttpResponse iHttpResponse = null;
            try {
                iHttpResponse = iHttpRequestTask.get(false);
            }
            finally {
                proxyTransaction.setRequestTask(null);
            }
            if (iHttpResponse == null) {
                httpResponse.setStatusCode(503);
                proxyTransaction.signalComplete(false);
                return;
            }
            if (!this.handleResponse(proxyTransaction, iHttpResponse)) {
                httpResponse.setStatusCode(503);
                proxyTransaction.signalComplete(true);
                return;
            }
            try {
                HttpResponse httpResponse2 = this.copyResponse(iHttpResponse.getRawResponse());
                this.removeHeaders((HttpMessage)httpResponse2);
                httpResponse.setStatusLine(httpResponse2.getStatusLine());
                httpResponse.setHeaders(httpResponse2.getAllHeaders());
                httpResponse.setEntity(httpResponse2.getEntity());
                proxyTransaction.signalForward();
            }
            catch (InterruptedException interruptedException) {
                this.logger.log(Level.WARNING, "Error processing request: " + interruptedException.getMessage(), interruptedException);
                httpResponse.setStatusCode(503);
            }
            catch (RequestEngineException requestEngineException) {
                this.logger.log(Level.WARNING, "Error processing request: " + requestEngineException.getMessage());
                httpResponse.setStatusCode(502);
            }
            catch (ProtocolException protocolException) {
                this.logger.log(Level.WARNING, "Error processing request: " + protocolException.getMessage(), protocolException);
                httpResponse.setStatusCode(400);
            }
            catch (Exception exception) {
                this.logger.log(Level.WARNING, "Error processing request: " + exception.getMessage(), exception);
                httpResponse.setStatusCode(500);
            }
        }
        finally {
            proxyTransaction.signalComplete(false);
        }
    }

    private HttpEntity copyEntity(HttpEntity httpEntity) {
        block3: {
            try {
                if (httpEntity != null) break block3;
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        ByteArrayEntity byteArrayEntity = new ByteArrayEntity(EntityUtils.toByteArray((HttpEntity)httpEntity));
        byteArrayEntity.setContentEncoding(httpEntity.getContentEncoding());
        byteArrayEntity.setContentType(httpEntity.getContentType());
        return byteArrayEntity;
    }

    private HttpUriRequest copyToUriRequest(HttpRequest httpRequest) throws ProtocolException {
        URI uRI;
        String string = this.removePath(httpRequest.getRequestLine().getUri());
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException("Invalid URI: " + string, (Throwable)uRISyntaxException);
        }
        if (uRI.getScheme() == null) {
            throw new ProtocolException("No scheme in proxy request URI");
        }
        if (uRI.getHost() == null) {
            throw new ProtocolException("No host in proxy request URI");
        }
        HttpHost httpHost = URIUtils.extractHost((URI)uRI);
        HttpUriRequest httpUriRequest = this.createRequestCopy(httpHost, httpRequest);
        httpUriRequest.setParams(httpRequest.getParams());
        httpUriRequest.setHeaders(httpRequest.getAllHeaders());
        return httpUriRequest;
    }

    private String removeSchemeAndHost(String string) {
        int n = this.findPathStart(string);
        if (n == -1) {
            return "";
        }
        return string.substring(n);
    }

    private String removePath(String string) {
        int n = this.findPathStart(string);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private int findPathStart(String string) {
        int n = string.indexOf("://");
        if (n == -1 || n + 3 >= string.length()) {
            return 0;
        }
        n += 3;
        while (string.charAt(n) == '/') {
            ++n;
        }
        return string.indexOf(47, n);
    }

    private HttpUriRequest createRequestCopy(HttpHost httpHost, HttpRequest httpRequest) {
        String string = httpRequest.getRequestLine().getMethod();
        String string2 = this.removeSchemeAndHost(httpRequest.getRequestLine().getUri());
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            VegaHttpEntityEnclosingUriRequest vegaHttpEntityEnclosingUriRequest = new VegaHttpEntityEnclosingUriRequest(httpHost, string, string2);
            vegaHttpEntityEnclosingUriRequest.setEntity(this.copyEntity(((HttpEntityEnclosingRequest)httpRequest).getEntity()));
            return vegaHttpEntityEnclosingUriRequest;
        }
        return new VegaHttpUriRequest(httpHost, string, string2);
    }

    private HttpResponse copyResponse(HttpResponse httpResponse) {
        BasicHttpResponse basicHttpResponse = new BasicHttpResponse(httpResponse.getStatusLine());
        basicHttpResponse.setHeaders(httpResponse.getAllHeaders());
        basicHttpResponse.setEntity(httpResponse.getEntity());
        return basicHttpResponse;
    }

    private void removeHeaders(HttpMessage httpMessage) {
        String[] stringArray = HOP_BY_HOP_HEADERS;
        int n = HOP_BY_HOP_HEADERS.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            httpMessage.removeHeaders(string);
            ++n2;
        }
    }

    private boolean handleRequest(ProxyTransaction proxyTransaction, HttpRequest httpRequest) throws InterruptedException, ProtocolException {
        this.removeHeaders((HttpMessage)httpRequest);
        proxyTransaction.setRequest(this.copyToUriRequest(httpRequest));
        if (this.httpProxy.handleTransaction(proxyTransaction)) {
            return proxyTransaction.getForward();
        }
        return true;
    }

    private boolean handleResponse(ProxyTransaction proxyTransaction, IHttpResponse iHttpResponse) throws InterruptedException {
        proxyTransaction.setResponse(iHttpResponse);
        if (this.httpProxy.handleTransaction(proxyTransaction)) {
            return proxyTransaction.getForward();
        }
        return true;
    }
}

