/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.proxy;

import com.subgraph.vega.api.analysis.IContentAnalyzer;
import com.subgraph.vega.api.analysis.IContentAnalyzerFactory;
import com.subgraph.vega.api.http.proxy.IHttpInterceptProxyEventHandler;
import com.subgraph.vega.api.http.proxy.IHttpInterceptor;
import com.subgraph.vega.api.http.proxy.IHttpProxyListener;
import com.subgraph.vega.api.http.proxy.IHttpProxyListenerConfig;
import com.subgraph.vega.api.http.proxy.IHttpProxyService;
import com.subgraph.vega.api.http.proxy.IHttpProxyServiceEventHandler;
import com.subgraph.vega.api.http.proxy.IHttpProxyTransactionManipulator;
import com.subgraph.vega.api.http.proxy.IProxyTransaction;
import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.http.requests.IHttpRequestEngineConfig;
import com.subgraph.vega.api.http.requests.IHttpRequestEngineFactory;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.requests.IRequestOrigin;
import com.subgraph.vega.api.model.requests.IRequestOriginProxy;
import com.subgraph.vega.api.paths.IPathFinder;
import com.subgraph.vega.api.scanner.IScanner;
import com.subgraph.vega.api.scanner.IScannerConfig;
import com.subgraph.vega.api.scanner.modules.IBasicModuleScript;
import com.subgraph.vega.api.scanner.modules.IResponseProcessingModule;
import com.subgraph.vega.api.scanner.modules.IScannerModuleRegistry;
import com.subgraph.vega.internal.http.proxy.HttpInterceptor;
import com.subgraph.vega.internal.http.proxy.HttpProxyListener;
import com.subgraph.vega.internal.http.proxy.HttpProxyListenerConfig;
import com.subgraph.vega.internal.http.proxy.ProxyScanner;
import com.subgraph.vega.internal.http.proxy.ProxyTransactionManipulator;
import com.subgraph.vega.internal.http.proxy.ssl.ProxySSLInitializationException;
import com.subgraph.vega.internal.http.proxy.ssl.SSLContextRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.CookieStore;
import org.apache.http.impl.client.BasicCookieStore;

public class HttpProxyService
implements IHttpProxyService {
    private final Logger logger = Logger.getLogger(HttpProxyService.class.getName());
    private final List<IHttpProxyServiceEventHandler> eventHandlers;
    private boolean isRunning = false;
    private boolean isPassthrough = false;
    private IModel model;
    private IHttpRequestEngineFactory requestEngineFactory;
    private IHttpRequestEngineConfig requestEngineConfig;
    private IContentAnalyzerFactory contentAnalyzerFactory;
    private IScannerModuleRegistry moduleRepository;
    private IScanner scanner;
    private CookieStore cookieStore;
    private IPathFinder pathFinder;
    private IContentAnalyzer contentAnalyzer;
    private List<IResponseProcessingModule> responseProcessingModules;
    private IWorkspace currentWorkspace;
    private Map<String, IHttpProxyListenerConfig> listenerConfigMap = new HashMap<String, IHttpProxyListenerConfig>();
    private Map<String, HttpProxyListener> listenerMap = new ConcurrentHashMap<String, HttpProxyListener>();
    private final IHttpInterceptProxyEventHandler listenerEventHandler;
    private final ProxyTransactionManipulator transactionManipulator;
    private ProxyScanner proxyScanner;
    private HttpInterceptor interceptor;
    private SSLContextRepository sslContextRepository;

    public HttpProxyService() {
        this.eventHandlers = new ArrayList<IHttpProxyServiceEventHandler>();
        this.listenerEventHandler = new IHttpInterceptProxyEventHandler(){

            public void handleRequest(IProxyTransaction iProxyTransaction) {
                HttpProxyService.this.processTransaction(iProxyTransaction);
            }
        };
        this.transactionManipulator = new ProxyTransactionManipulator();
    }

    public void activate() {
        this.interceptor = new HttpInterceptor(this.model);
        this.cookieStore = new BasicCookieStore();
        this.proxyScanner = new ProxyScanner(this.scanner, this.cookieStore, this.model);
        try {
            this.sslContextRepository = SSLContextRepository.createInstance(this.pathFinder.getVegaDirectory());
        }
        catch (ProxySSLInitializationException proxySSLInitializationException) {
            this.sslContextRepository = null;
            this.logger.warning("Failed to initialize SSL support in proxy.  SSL interception will be disabled. (" + proxySSLInitializationException.getMessage() + ")");
        }
    }

    public void registerEventHandler(IHttpProxyServiceEventHandler iHttpProxyServiceEventHandler) {
        this.eventHandlers.add(iHttpProxyServiceEventHandler);
    }

    public void unregisterEventHandler(IHttpProxyServiceEventHandler iHttpProxyServiceEventHandler) {
        this.eventHandlers.remove(iHttpProxyServiceEventHandler);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPassthrough() {
        HttpProxyService httpProxyService = this;
        synchronized (httpProxyService) {
            return this.isPassthrough;
        }
    }

    public IHttpProxyListenerConfig createListenerConfig() {
        return new HttpProxyListenerConfig();
    }

    public void setListenerConfigs(IHttpProxyListenerConfig[] iHttpProxyListenerConfigArray) {
        String string;
        Object object;
        Iterator<Map.Entry<String, IHttpProxyListenerConfig>> iterator = this.listenerConfigMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            string = object.getKey();
            int n = 0;
            while (n < iHttpProxyListenerConfigArray.length) {
                if (string.compareTo(iHttpProxyListenerConfigArray[n].toString()) == 0) break;
                ++n;
            }
            if (n != iHttpProxyListenerConfigArray.length) continue;
            if (this.isRunning) {
                HttpProxyListener httpProxyListener = this.listenerMap.remove(string);
                this.stopListener(httpProxyListener);
            }
            iterator.remove();
        }
        int n = 0;
        while (n < iHttpProxyListenerConfigArray.length) {
            object = iHttpProxyListenerConfigArray[n];
            string = object.toString();
            if (this.listenerConfigMap.get(string) == null) {
                this.listenerConfigMap.put(string, (IHttpProxyListenerConfig)object);
                if (this.isRunning) {
                    this.startListener((IHttpProxyListenerConfig)object);
                }
            }
            ++n;
        }
        for (IHttpProxyServiceEventHandler iHttpProxyServiceEventHandler : this.eventHandlers) {
            iHttpProxyServiceEventHandler.notifyConfigChange(this.listenerMap.size());
        }
    }

    public IHttpProxyListenerConfig[] getListenerConfigs() {
        return this.listenerMap.keySet().toArray(new IHttpProxyListenerConfig[0]);
    }

    public IHttpProxyListener[] getListeners() {
        return this.listenerMap.values().toArray(new IHttpProxyListener[0]);
    }

    public int getListenerConfigsCount() {
        return this.listenerMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassthrough(boolean bl) {
        HttpProxyService httpProxyService = this;
        synchronized (httpProxyService) {
            this.isPassthrough = bl;
            this.interceptor.setEnabled(!bl);
        }
    }

    public void start() {
        this.currentWorkspace = this.model.getCurrentWorkspace();
        if (this.currentWorkspace == null) {
            throw new IllegalStateException("Cannot start proxy because no workspace is currently open");
        }
        this.currentWorkspace.lock();
        this.isRunning = true;
        this.responseProcessingModules = this.loadModules();
        this.contentAnalyzer = this.contentAnalyzerFactory.createContentAnalyzer(this.currentWorkspace.getScanAlertRepository().getProxyScanInstance());
        this.contentAnalyzer.setResponseProcessingModules(this.responseProcessingModules);
        this.contentAnalyzer.setDefaultAddToRequestLog(true);
        this.contentAnalyzer.setAddLinksToModel(true);
        this.proxyScanner.reloadModules();
        for (IHttpProxyListenerConfig iHttpProxyListenerConfig : this.listenerConfigMap.values()) {
            this.startListener(iHttpProxyListenerConfig);
        }
        for (IHttpProxyServiceEventHandler iHttpProxyServiceEventHandler : this.eventHandlers) {
            iHttpProxyServiceEventHandler.notifyStart(this.listenerMap.size());
        }
    }

    private void startListener(IHttpProxyListenerConfig iHttpProxyListenerConfig) {
        IRequestOriginProxy iRequestOriginProxy = this.currentWorkspace.getRequestLog().getRequestOriginProxy(iHttpProxyListenerConfig.getInetAddress(), iHttpProxyListenerConfig.getPort());
        IHttpRequestEngine iHttpRequestEngine = this.requestEngineFactory.createRequestEngine(IHttpRequestEngine.EngineConfigType.CONFIG_PROXY, this.requestEngineConfig, (IRequestOrigin)iRequestOriginProxy);
        iHttpRequestEngine.setCookieStore(this.cookieStore);
        HttpProxyListener httpProxyListener = new HttpProxyListener(iHttpProxyListenerConfig, this.transactionManipulator, this.interceptor, iHttpRequestEngine, this.sslContextRepository);
        httpProxyListener.registerEventHandler(this.listenerEventHandler);
        this.listenerMap.put(iHttpProxyListenerConfig.toString(), httpProxyListener);
        httpProxyListener.start();
        for (IHttpProxyServiceEventHandler iHttpProxyServiceEventHandler : this.eventHandlers) {
            iHttpProxyServiceEventHandler.notifyStartListener((IHttpProxyListener)httpProxyListener);
        }
    }

    private void stopListener(IHttpProxyListener iHttpProxyListener) {
        iHttpProxyListener.unregisterEventHandler(this.listenerEventHandler);
        iHttpProxyListener.stop();
        for (IHttpProxyServiceEventHandler iHttpProxyServiceEventHandler : this.eventHandlers) {
            iHttpProxyServiceEventHandler.notifyStopListener(iHttpProxyListener);
        }
    }

    private List<IResponseProcessingModule> loadModules() {
        if (this.responseProcessingModules == null) {
            return this.moduleRepository.getResponseProcessingModules();
        }
        return this.moduleRepository.updateResponseProcessingModules(this.responseProcessingModules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTransaction(IProxyTransaction iProxyTransaction) {
        HttpProxyService httpProxyService = this;
        synchronized (httpProxyService) {
            if (iProxyTransaction.getResponse() == null || this.contentAnalyzer == null || this.isPassthrough) {
                return;
            }
        }
        try {
            if (this.proxyScanner.isEnabled()) {
                this.proxyScanner.processRequest(iProxyTransaction.getRequest());
            }
            this.contentAnalyzer.processResponse(iProxyTransaction.getResponse());
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(Level.WARNING, "Exception processing transaction response: " + runtimeException.getMessage(), runtimeException);
        }
    }

    public void stop() {
        if (this.currentWorkspace == null) {
            throw new IllegalStateException("No workspace is open");
        }
        this.isRunning = false;
        this.proxyScanner.setEnabled(false);
        IHttpProxyServiceEventHandler iHttpProxyServiceEventHandler2 = this.listenerMap.entrySet().iterator();
        while (iHttpProxyServiceEventHandler2.hasNext()) {
            Map.Entry<String, HttpProxyListener> entry = iHttpProxyServiceEventHandler2.next();
            this.stopListener(entry.getValue());
            iHttpProxyServiceEventHandler2.remove();
        }
        this.listenerMap.clear();
        this.contentAnalyzer = null;
        this.currentWorkspace.unlock();
        for (IHttpProxyServiceEventHandler iHttpProxyServiceEventHandler2 : this.eventHandlers) {
            iHttpProxyServiceEventHandler2.notifyStop();
        }
    }

    public IHttpProxyTransactionManipulator getTransactionManipulator() {
        return this.transactionManipulator;
    }

    public IHttpInterceptor getInterceptor() {
        return this.interceptor;
    }

    protected void setModel(IModel iModel) {
        this.model = iModel;
    }

    protected void unsetModel(IModel iModel) {
        this.model = null;
    }

    protected void setContentAnalyzerFactory(IContentAnalyzerFactory iContentAnalyzerFactory) {
        this.contentAnalyzerFactory = iContentAnalyzerFactory;
    }

    protected void unsetContentAnalyzerFactory(IContentAnalyzerFactory iContentAnalyzerFactory) {
        this.contentAnalyzerFactory = null;
    }

    protected void setRequestEngineFactory(IHttpRequestEngineFactory iHttpRequestEngineFactory) {
        this.requestEngineFactory = iHttpRequestEngineFactory;
        this.requestEngineConfig = this.requestEngineFactory.createConfig();
    }

    protected void unsetRequestEngineFactory(IHttpRequestEngineFactory iHttpRequestEngineFactory) {
        this.requestEngineFactory = null;
        this.requestEngineConfig = null;
    }

    protected void setModuleRepository(IScannerModuleRegistry iScannerModuleRegistry) {
        this.moduleRepository = iScannerModuleRegistry;
    }

    protected void unsetModuleRepository(IScannerModuleRegistry iScannerModuleRegistry) {
        this.moduleRepository = null;
    }

    protected void setPathFinder(IPathFinder iPathFinder) {
        this.pathFinder = iPathFinder;
    }

    protected void unsetPathFinder(IPathFinder iPathFinder) {
        this.pathFinder = null;
    }

    protected void setScanner(IScanner iScanner) {
        this.scanner = iScanner;
    }

    protected void unsetScanner(IScanner iScanner) {
        this.scanner = null;
    }

    public List<IResponseProcessingModule> getResponseProcessingModules() {
        this.responseProcessingModules = this.loadModules();
        if (this.responseProcessingModules == null) {
            return Collections.emptyList();
        }
        return this.responseProcessingModules;
    }

    public boolean isProxyScanEnabled() {
        return this.proxyScanner.isEnabled();
    }

    public void setProxyScanEnabled(boolean bl) {
        this.proxyScanner.setEnabled(bl);
    }

    public IScannerConfig getProxyScanConfig() {
        return this.proxyScanner.getConfig();
    }

    public List<IBasicModuleScript> getProxyScanModules() {
        return this.proxyScanner.getInjectionModules();
    }
}

