/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.proxy;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.http.proxy.HttpInterceptorLevel;
import com.subgraph.vega.api.http.proxy.IHttpInterceptor;
import com.subgraph.vega.api.http.proxy.IHttpInterceptorEventHandler;
import com.subgraph.vega.api.http.proxy.IProxyTransaction;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.WorkspaceCloseEvent;
import com.subgraph.vega.api.model.WorkspaceOpenEvent;
import com.subgraph.vega.api.model.WorkspaceResetEvent;
import com.subgraph.vega.api.model.conditions.ConditionSetChanged;
import com.subgraph.vega.api.model.conditions.IHttpConditionSet;
import com.subgraph.vega.internal.http.proxy.ProxyTransaction;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

public class HttpInterceptor
implements IHttpInterceptor {
    private static final String propertyInterceptorLevelRequest = "vega.preferences.proxy.interceptor.level.request";
    private static final String propertyInterceptorLevelResponse = "vega.preferences.proxy.interceptor.level.response";
    private final Object interceptorLock = new Object();
    private final List<IHttpInterceptorEventHandler> eventHandlerList;
    private HttpInterceptorLevel interceptorLevelRequest = HttpInterceptorLevel.DISABLED;
    private HttpInterceptorLevel interceptorLevelResponse = HttpInterceptorLevel.DISABLED;
    private IHttpConditionSet breakpointSetRequest;
    private IHttpConditionSet breakpointSetResponse;
    private final ArrayList<ProxyTransaction> transactionQueue = new ArrayList();
    private IWorkspace currentWorkspace;
    private boolean isEnabled = true;

    HttpInterceptor(IModel iModel) {
        this.eventHandlerList = new ArrayList<IHttpInterceptorEventHandler>();
        this.currentWorkspace = iModel.addWorkspaceListener(new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof WorkspaceOpenEvent) {
                    HttpInterceptor.this.handleWorkspaceOpen((WorkspaceOpenEvent)iEvent);
                } else if (iEvent instanceof WorkspaceCloseEvent) {
                    HttpInterceptor.this.handleWorkspaceClose((WorkspaceCloseEvent)iEvent);
                } else if (iEvent instanceof WorkspaceResetEvent) {
                    HttpInterceptor.this.handleWorkspaceReset((WorkspaceResetEvent)iEvent);
                }
            }
        });
        this.loadInterceptorLevelRequest();
        this.loadInterceptorLevelResponse();
        this.breakpointSetRequest = this.createConditionSet(iModel, true);
        this.breakpointSetResponse = this.createConditionSet(iModel, false);
    }

    private void handleWorkspaceOpen(WorkspaceOpenEvent workspaceOpenEvent) {
        this.currentWorkspace = workspaceOpenEvent.getWorkspace();
    }

    private void handleWorkspaceClose(WorkspaceCloseEvent workspaceCloseEvent) {
        this.currentWorkspace = null;
    }

    private void handleWorkspaceReset(WorkspaceResetEvent workspaceResetEvent) {
        this.currentWorkspace = workspaceResetEvent.getWorkspace();
        this.loadInterceptorLevelRequest();
        this.loadInterceptorLevelResponse();
    }

    private void loadInterceptorLevelRequest() {
        this.interceptorLevelRequest = HttpInterceptorLevel.fromValue((Integer)this.currentWorkspace.getIntegerProperty(propertyInterceptorLevelRequest));
        if (this.interceptorLevelRequest == null) {
            this.interceptorLevelRequest = HttpInterceptorLevel.DISABLED;
        }
    }

    private void loadInterceptorLevelResponse() {
        this.interceptorLevelResponse = HttpInterceptorLevel.fromValue((Integer)this.currentWorkspace.getIntegerProperty(propertyInterceptorLevelResponse));
        if (this.interceptorLevelResponse == null) {
            this.interceptorLevelResponse = HttpInterceptorLevel.DISABLED;
        }
    }

    private IHttpConditionSet createConditionSet(IModel iModel, boolean bl) {
        String string = bl ? "breakpoints-request" : "breakpoints-response";
        return iModel.addConditionSetTracker(string, this.createConditionSetChangedHandler(bl));
    }

    private IEventHandler createConditionSetChangedHandler(final boolean bl) {
        return new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof ConditionSetChanged) {
                    HttpInterceptor.this.onConditionSetChanged((ConditionSetChanged)iEvent, bl);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConditionSetChanged(ConditionSetChanged conditionSetChanged, boolean bl) {
        Object object = this.interceptorLock;
        synchronized (object) {
            IProxyTransaction.TransactionDirection transactionDirection;
            if (bl) {
                this.breakpointSetRequest = conditionSetChanged.getConditionSet();
                transactionDirection = IProxyTransaction.TransactionDirection.DIRECTION_REQUEST;
            } else {
                this.breakpointSetResponse = conditionSetChanged.getConditionSet();
                transactionDirection = IProxyTransaction.TransactionDirection.DIRECTION_RESPONSE;
            }
            this.releaseOnChange(transactionDirection);
        }
    }

    private boolean intercept(ProxyTransaction proxyTransaction) {
        if (!proxyTransaction.hasResponse()) {
            return this.interceptByLevelAndBreakpointSet(proxyTransaction, this.interceptorLevelRequest, this.breakpointSetRequest);
        }
        return this.interceptByLevelAndBreakpointSet(proxyTransaction, this.interceptorLevelResponse, this.breakpointSetResponse);
    }

    private boolean interceptByLevelAndBreakpointSet(ProxyTransaction proxyTransaction, HttpInterceptorLevel httpInterceptorLevel, IHttpConditionSet iHttpConditionSet) {
        switch (httpInterceptorLevel) {
            case ENABLED_ALL: {
                return true;
            }
            case DISABLED: {
                return false;
            }
            case ENABLED_BREAKPOINTS: {
                return this.interceptOnBreakpointSet(iHttpConditionSet, proxyTransaction);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean interceptOnBreakpointSet(IHttpConditionSet iHttpConditionSet, ProxyTransaction proxyTransaction) {
        HttpResponse httpResponse = proxyTransaction.hasResponse() ? proxyTransaction.getResponse().getRawResponse() : null;
        Object object = this.interceptorLock;
        synchronized (object) {
            return iHttpConditionSet == null ? false : iHttpConditionSet.matchesAny((HttpRequest)proxyTransaction.getRequest(), httpResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleTransaction(ProxyTransaction proxyTransaction) {
        Object object = this.interceptorLock;
        synchronized (object) {
            block5: {
                if (!this.isEnabled || this.eventHandlerList.size() == 0 || !this.intercept(proxyTransaction)) break block5;
                proxyTransaction.setPending(this);
                this.transactionQueue.add(proxyTransaction);
                int n = this.transactionQueue.size() - 1;
                for (IHttpInterceptorEventHandler iHttpInterceptorEventHandler : this.eventHandlerList) {
                    iHttpInterceptorEventHandler.notifyQueue((IProxyTransaction)proxyTransaction, n);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean bl) {
        Object object = this.interceptorLock;
        synchronized (object) {
            if (this.isEnabled != bl) {
                this.isEnabled = bl;
                if (!this.isEnabled) {
                    this.forwardAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Object object = this.interceptorLock;
        synchronized (object) {
            return this.isEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventHandler(IHttpInterceptorEventHandler iHttpInterceptorEventHandler) {
        Object object = this.interceptorLock;
        synchronized (object) {
            this.eventHandlerList.add(iHttpInterceptorEventHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventHandler(IHttpInterceptorEventHandler iHttpInterceptorEventHandler) {
        Object object = this.interceptorLock;
        synchronized (object) {
            this.eventHandlerList.remove(iHttpInterceptorEventHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterceptLevel(IProxyTransaction.TransactionDirection transactionDirection, HttpInterceptorLevel httpInterceptorLevel) {
        Object object = this.interceptorLock;
        synchronized (object) {
            if (transactionDirection == IProxyTransaction.TransactionDirection.DIRECTION_REQUEST) {
                this.interceptorLevelRequest = httpInterceptorLevel;
                this.currentWorkspace.setIntegerProperty(propertyInterceptorLevelRequest, httpInterceptorLevel.getSerializeValue().intValue());
            } else {
                this.interceptorLevelResponse = httpInterceptorLevel;
                this.currentWorkspace.setIntegerProperty(propertyInterceptorLevelResponse, httpInterceptorLevel.getSerializeValue().intValue());
            }
            this.releaseOnChange(transactionDirection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpInterceptorLevel getInterceptLevel(IProxyTransaction.TransactionDirection transactionDirection) {
        Object object = this.interceptorLock;
        synchronized (object) {
            if (transactionDirection == IProxyTransaction.TransactionDirection.DIRECTION_REQUEST) {
                return this.interceptorLevelRequest;
            }
            return this.interceptorLevelResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int transactionQueueSize() {
        Object object = this.interceptorLock;
        synchronized (object) {
            return this.transactionQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProxyTransaction[] getTransactions() {
        Object object = this.interceptorLock;
        synchronized (object) {
            return this.transactionQueue.toArray(new IProxyTransaction[this.transactionQueue.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProxyTransaction transactionQueueGet(int n) {
        Object object = this.interceptorLock;
        synchronized (object) {
            block4: {
                if (this.transactionQueue.size() > n) break block4;
                return null;
            }
            return this.transactionQueue.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyHandled(ProxyTransaction proxyTransaction) {
        Object object = this.interceptorLock;
        synchronized (object) {
            int n = this.transactionQueue.indexOf(proxyTransaction);
            this.transactionQueue.remove(n);
            if (this.transactionQueue.size() == 0) {
                for (IHttpInterceptorEventHandler iHttpInterceptorEventHandler : this.eventHandlerList) {
                    iHttpInterceptorEventHandler.notifyEmpty();
                }
            } else {
                for (IHttpInterceptorEventHandler iHttpInterceptorEventHandler : this.eventHandlerList) {
                    iHttpInterceptorEventHandler.notifyRemove(n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHttpConditionSet getBreakpointSet(IProxyTransaction.TransactionDirection transactionDirection) {
        Object object = this.interceptorLock;
        synchronized (object) {
            if (transactionDirection == IProxyTransaction.TransactionDirection.DIRECTION_REQUEST) {
                return this.breakpointSetRequest;
            }
            return this.breakpointSetResponse;
        }
    }

    private void releaseOnChange(IProxyTransaction.TransactionDirection transactionDirection) {
        block6: {
            HttpInterceptorLevel httpInterceptorLevel = this.getInterceptLevel(transactionDirection);
            if (httpInterceptorLevel == HttpInterceptorLevel.ENABLED_ALL) break block6;
            if (httpInterceptorLevel != HttpInterceptorLevel.DISABLED) {
                IHttpConditionSet iHttpConditionSet = this.getBreakpointSet(transactionDirection);
                int n = 0;
                while (n < this.transactionQueue.size()) {
                    ProxyTransaction proxyTransaction = this.transactionQueue.get(n);
                    if (proxyTransaction.hasResponse() == (transactionDirection == IProxyTransaction.TransactionDirection.DIRECTION_RESPONSE) && !this.interceptOnBreakpointSet(iHttpConditionSet, proxyTransaction)) {
                        proxyTransaction.doForward();
                    }
                    ++n;
                }
            } else {
                int n = 0;
                while (n < this.transactionQueue.size()) {
                    ProxyTransaction proxyTransaction = this.transactionQueue.get(n);
                    if (proxyTransaction.hasResponse() == (transactionDirection == IProxyTransaction.TransactionDirection.DIRECTION_RESPONSE)) {
                        proxyTransaction.doForward();
                    }
                    ++n;
                }
            }
        }
    }

    private void forwardAll() {
        int n = 0;
        while (n < this.transactionQueue.size()) {
            ProxyTransaction proxyTransaction = this.transactionQueue.get(n);
            proxyTransaction.doDrop();
            ++n;
        }
    }
}

