/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.crawler;

import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.http.requests.RequestEngineException;
import com.subgraph.vega.internal.crawler.CrawlerPauseLock;
import com.subgraph.vega.internal.crawler.CrawlerTask;
import java.io.InterruptedIOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.methods.HttpUriRequest;

public class RequestConsumer
implements Runnable {
    private final Logger logger = Logger.getLogger("crawler");
    private final IHttpRequestEngine requestEngine;
    private final BlockingQueue<CrawlerTask> crawlerRequestQueue;
    private final BlockingQueue<CrawlerTask> crawlerResponseQueue;
    private final CountDownLatch latch;
    private final CrawlerPauseLock pauseLock;
    private volatile boolean stop;
    private final Object requestLock = new Object();
    private volatile HttpUriRequest activeRequest = null;

    RequestConsumer(IHttpRequestEngine iHttpRequestEngine, BlockingQueue<CrawlerTask> blockingQueue, BlockingQueue<CrawlerTask> blockingQueue2, CountDownLatch countDownLatch, CrawlerPauseLock crawlerPauseLock) {
        this.requestEngine = iHttpRequestEngine;
        this.crawlerRequestQueue = blockingQueue;
        this.crawlerResponseQueue = blockingQueue2;
        this.latch = countDownLatch;
        this.pauseLock = crawlerPauseLock;
    }

    @Override
    public void run() {
        try {
            try {
                this.runLoop();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                this.latch.countDown();
            }
        }
        finally {
            this.latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        this.stop = true;
        Object object = this.requestLock;
        synchronized (object) {
            if (this.activeRequest != null) {
                this.activeRequest.abort();
            }
        }
    }

    private void runLoop() throws InterruptedException {
        while (!this.stop) {
            this.pauseLock.checkIfPaused();
            CrawlerTask crawlerTask = this.crawlerRequestQueue.take();
            if (crawlerTask.isExitTask()) {
                this.crawlerRequestQueue.add(crawlerTask);
                return;
            }
            this.logger.info("Retrieving: " + crawlerTask.getRequest().getRequestLine().getUri());
            if (!(this.sendRequest(crawlerTask) || this.stop || crawlerTask.causedException())) {
                this.logger.log(Level.WARNING, "No response was receiven for request to " + crawlerTask.getRequest().getURI());
            }
            this.crawlerResponseQueue.put(crawlerTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sendRequest(CrawlerTask crawlerTask) {
        Object object;
        boolean bl;
        try {
            this.activeRequest = crawlerTask.getRequest();
            IHttpResponse iHttpResponse = this.requestEngine.sendRequest(crawlerTask.getRequest()).get(true);
            crawlerTask.setResponse(iHttpResponse);
            bl = iHttpResponse != null;
            object = this.requestLock;
        }
        catch (RequestEngineException requestEngineException) {
            block15: {
                block14: {
                    try {
                        if (!(requestEngineException.getCause() instanceof InterruptedIOException)) break block14;
                        this.stop = true;
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object object2 = this.requestLock;
                        synchronized (object2) {
                            this.activeRequest = null;
                            throw throwable;
                        }
                    }
                }
                if (requestEngineException.getMessage().contains("abort")) break block15;
                crawlerTask.setException(requestEngineException.getCause());
                this.logger.log(Level.WARNING, requestEngineException.getMessage());
            }
            Object object3 = this.requestLock;
            synchronized (object3) {
                this.activeRequest = null;
                return false;
            }
        }
        synchronized (object) {
            this.activeRequest = null;
            return bl;
        }
    }
}

