/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.crawler;

import com.subgraph.vega.api.crawler.IWebCrawler;
import com.subgraph.vega.internal.crawler.CrawlerPauseLock;
import com.subgraph.vega.internal.crawler.CrawlerTask;
import com.subgraph.vega.internal.crawler.TaskCounter;
import com.subgraph.vega.internal.crawler.WebCrawler;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class HttpResponseProcessor
implements Runnable {
    private final Logger logger = Logger.getLogger("crawler");
    private final WebCrawler crawler;
    private final BlockingQueue<CrawlerTask> crawlerRequestQueue;
    private final BlockingQueue<CrawlerTask> crawlerResponseQueue;
    private final CountDownLatch latch;
    private final TaskCounter counter;
    private final AtomicInteger outstandingTasks;
    private final boolean stopOnEmptyQueue;
    private final CrawlerPauseLock pauseLock;
    private volatile boolean stop;
    private final Object requestLock = new Object();
    private volatile HttpUriRequest activeRequest = null;

    HttpResponseProcessor(WebCrawler webCrawler, BlockingQueue<CrawlerTask> blockingQueue, BlockingQueue<CrawlerTask> blockingQueue2, CountDownLatch countDownLatch, TaskCounter taskCounter, AtomicInteger atomicInteger, boolean bl, CrawlerPauseLock crawlerPauseLock) {
        this.crawler = webCrawler;
        this.crawlerRequestQueue = blockingQueue;
        this.crawlerResponseQueue = blockingQueue2;
        this.latch = countDownLatch;
        this.counter = taskCounter;
        this.outstandingTasks = atomicInteger;
        this.stopOnEmptyQueue = bl;
        this.pauseLock = crawlerPauseLock;
    }

    @Override
    public void run() {
        try {
            try {
                this.runLoop();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                this.latch.countDown();
            }
        }
        finally {
            this.latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        this.stop = true;
        if (!this.crawlerResponseQueue.offer(CrawlerTask.createExitTask())) {
            this.logger.warning("Failed to add STOP sentinel to crawler response queue");
        }
        Object object = this.requestLock;
        synchronized (object) {
            if (this.activeRequest != null) {
                this.activeRequest.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLoop() throws InterruptedException {
        while (!this.stop) {
            CrawlerTask crawlerTask;
            block32: {
                Object object;
                HttpUriRequest httpUriRequest;
                this.pauseLock.checkIfPaused();
                crawlerTask = this.crawlerResponseQueue.take();
                if (crawlerTask.isExitTask()) {
                    this.crawlerRequestQueue.add(CrawlerTask.createExitTask());
                    this.crawlerResponseQueue.add(crawlerTask);
                    return;
                }
                this.activeRequest = httpUriRequest = crawlerTask.getRequest();
                try {
                    try {
                        if (crawlerTask.getResponse() != null) {
                            crawlerTask.getResponseProcessor().processResponse((IWebCrawler)this.crawler, httpUriRequest, crawlerTask.getResponse(), crawlerTask.getArgument());
                        }
                    }
                    catch (Exception exception) {
                        this.logger.log(Level.WARNING, "Unexpected exception processing crawler request: " + httpUriRequest.getURI(), exception);
                        object = this.requestLock;
                        synchronized (object) {
                            this.activeRequest = null;
                        }
                        Object object2 = object = crawlerTask.getResponse() == null ? null : crawlerTask.getResponse().getRawResponse().getEntity();
                        if (object != null) {
                            try {
                                EntityUtils.consume((HttpEntity)object);
                            }
                            catch (IOException iOException) {
                                this.logger.log(Level.WARNING, "I/O exception consuming request entity content for " + httpUriRequest.getURI() + " : " + iOException.getMessage());
                            }
                        }
                        break block32;
                    }
                }
                catch (Throwable throwable) {
                    object = this.requestLock;
                    synchronized (object) {
                        this.activeRequest = null;
                    }
                    Object object3 = object = crawlerTask.getResponse() == null ? null : crawlerTask.getResponse().getRawResponse().getEntity();
                    if (object != null) {
                        try {
                            EntityUtils.consume((HttpEntity)object);
                        }
                        catch (IOException iOException) {
                            this.logger.log(Level.WARNING, "I/O exception consuming request entity content for " + httpUriRequest.getURI() + " : " + iOException.getMessage());
                        }
                    }
                    throw throwable;
                }
                object = this.requestLock;
                synchronized (object) {
                    this.activeRequest = null;
                }
                Object object4 = object = crawlerTask.getResponse() == null ? null : crawlerTask.getResponse().getRawResponse().getEntity();
                if (object != null) {
                    try {
                        EntityUtils.consume((HttpEntity)object);
                    }
                    catch (IOException iOException) {
                        this.logger.log(Level.WARNING, "I/O exception consuming request entity content for " + httpUriRequest.getURI() + " : " + iOException.getMessage());
                    }
                }
            }
            Object object = this.counter;
            synchronized (object) {
                this.counter.addCompletedTask();
            }
            if (crawlerTask.getResponse() == null) {
                if (crawlerTask.causedException()) {
                    crawlerTask.getResponseProcessor().processException(crawlerTask.getRequest(), crawlerTask.getException(), crawlerTask.getArgument());
                } else {
                    object = new IllegalStateException("Completed queue task has no response and no exception");
                    crawlerTask.getResponseProcessor().processException(crawlerTask.getRequest(), (Throwable)object, crawlerTask.getArgument());
                }
            }
            if (this.outstandingTasks.decrementAndGet() > 0 || !this.stopOnEmptyQueue) continue;
            this.crawlerRequestQueue.add(CrawlerTask.createExitTask());
            this.crawlerResponseQueue.add(CrawlerTask.createExitTask());
            return;
        }
    }
}

