/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.util.modules;

import com.subgraph.vega.api.scanner.modules.IEnableableModule;
import com.subgraph.vega.api.scanner.modules.IScannerModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModuleTreeData {
    private final Map<String, List<IScannerModule>> categoryToModules = new HashMap<String, List<IScannerModule>>();

    ModuleTreeData(List<IScannerModule> list) {
        this.populateModuleMap(list);
    }

    private void populateModuleMap(List<IScannerModule> list) {
        for (IScannerModule iScannerModule : list) {
            this.getModuleListForCategory(iScannerModule.getModuleCategoryName()).add(iScannerModule);
        }
    }

    public List<IScannerModule> getModuleListForCategory(String string) {
        if (!this.categoryToModules.containsKey(string)) {
            this.categoryToModules.put(string, new ArrayList());
        }
        return this.categoryToModules.get(string);
    }

    void setEnableStateForCategory(String string, boolean bl) {
        for (IScannerModule iScannerModule : this.getModuleListForCategory(string)) {
            if (!(iScannerModule instanceof IEnableableModule)) continue;
            ((IEnableableModule)iScannerModule).setEnabled(bl);
        }
    }

    boolean someEnabledInCategory(String string) {
        for (IScannerModule iScannerModule : this.getModuleListForCategory(string)) {
            if (!(iScannerModule instanceof IEnableableModule) || !((IEnableableModule)iScannerModule).isEnabled()) continue;
            return true;
        }
        return false;
    }

    boolean allEnabledInCategory(String string) {
        for (IScannerModule iScannerModule : this.getModuleListForCategory(string)) {
            if (!(iScannerModule instanceof IEnableableModule) || ((IEnableableModule)iScannerModule).isEnabled()) continue;
            return false;
        }
        return true;
    }

    List<String> getAllCategories() {
        return new ArrayList<String>(this.categoryToModules.keySet());
    }
}

