/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.util.modules;

import com.subgraph.vega.api.scanner.modules.IEnableableModule;
import com.subgraph.vega.ui.util.modules.ModuleTreeData;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;

public class ModuleRegistryCheckStateProvider
implements ICheckStateProvider,
ICheckStateListener {
    private final CheckboxTreeViewer viewer;
    private ModuleTreeData treeData;

    public ModuleRegistryCheckStateProvider(CheckboxTreeViewer checkboxTreeViewer) {
        this.viewer = checkboxTreeViewer;
    }

    public boolean isChecked(Object object) {
        if (object instanceof IEnableableModule) {
            IEnableableModule iEnableableModule = (IEnableableModule)object;
            return iEnableableModule.isEnabled();
        }
        if (object instanceof String && this.treeData != null) {
            String string = (String)object;
            return this.treeData.someEnabledInCategory(string);
        }
        return false;
    }

    public boolean isGrayed(Object object) {
        if (!(object instanceof String)) {
            return false;
        }
        if (this.treeData == null) {
            return false;
        }
        String string = (String)object;
        return this.treeData.someEnabledInCategory(string) && !this.treeData.allEnabledInCategory(string);
    }

    private void setEnableStateForCategory(String string, boolean bl) {
        if (this.treeData == null) {
            return;
        }
        this.treeData.setEnableStateForCategory(string, bl);
    }

    void setTreeData(ModuleTreeData moduleTreeData) {
        this.treeData = moduleTreeData;
    }

    public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
        if (checkStateChangedEvent.getElement() instanceof IEnableableModule) {
            IEnableableModule iEnableableModule = (IEnableableModule)checkStateChangedEvent.getElement();
            iEnableableModule.setEnabled(checkStateChangedEvent.getChecked());
            this.viewer.refresh();
        } else if (checkStateChangedEvent.getElement() instanceof String) {
            String string = (String)checkStateChangedEvent.getElement();
            this.setEnableStateForCategory(string, checkStateChangedEvent.getChecked());
            this.viewer.setSubtreeChecked(checkStateChangedEvent.getElement(), checkStateChangedEvent.getChecked());
            this.viewer.refresh();
        }
    }
}

