#!/usr/bin/python
'''
//=============================================================================
//
//    File : ufo_prggui.py
//    Creation date : Wed Dec 05 14:30:48 CEST 2012
//    Working on this file:    asterix (Cristian Steri)
//                            Grifisx (Antonino G. Imbesi)
//     This file is part of the Ufo Wardriving distribution
//
//    Websites: http://ufo-wardriving.com
//
//     This program is FREE software. You can redistribute it and/or
//     modify it under the terms of the GNU General Public License
//     as published by the Free Software Foundation; either version 2
//     of the License, or (at your opinion) any later version.
//
//    This program is distributed in the HOPE that it will be USEFUL,
//     but WITHOUT ANY WARRANTY; without even the implied warranty of
//     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//     See the GNU General Public License for more details.
//
//     You should have received a copy of the GNU General Public License
//     along with this program. If not, write to the Free Software Foundation,
//     Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================
'''
import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
import sys
import os.path
from core.ufo_picsfinder import get_icon

from core import ufo_prgdecode

class UFOPrgWidget(QWidget):           
    def __init__(self, parent = None):
        super(UFOPrgWidget, self).__init__(parent)

        hBoxprg = QHBoxLayout()
        hBoxprg.setSpacing(5)

        vBoxprg = QVBoxLayout()
        vBoxprg.setSpacing(5)

        labelprg = QLabel("MAC:",self)
        self.lineEditprg= QLineEdit(self)
        self.lineEditprg.setToolTip("BSSID "+_("Compatible")+" : \nPBS-")
        self.lineEditprg.setInputMask("HH:HH:HH:HH:HH:HH;_")

        self.outputTextEdit = QTextEdit(self)
        self.outputTextEdit.setReadOnly(True)

        self.buttonCalc = QPushButton(_("Find"),self)
        self.buttonCalc.setIcon(get_icon("key.png"))
        self.buttonCalc.setEnabled(0)

        hBoxprg.addWidget(labelprg)
        hBoxprg.addWidget(self.lineEditprg)
        hBoxprg.addWidget(self.buttonCalc)
        vBoxprg.addLayout(hBoxprg)
        vBoxprg.addWidget(self.outputTextEdit)

        self.setLayout(vBoxprg)

        self.lineEditprg.textChanged.connect(self.enable_button)
        self.buttonCalc.clicked.connect(self.find_key)

    def enable_button(self):
        if self.lineEditprg.text().length()==17:
            self.buttonCalc.setEnabled(1)
        else:
            self.buttonCalc.setEnabled(0)

    def find_key(self):
        mac_prg = str(self.lineEditprg.text())
        mac_prg = mac_prg.replace(" ","")
        try:
            stdouterr_prg = "\n".join(ufo_prgdecode.calc(mac_prg))
        except TypeError:
            self.outputTextEdit.setText(_("No key found."))
            return
        self.outputTextEdit.setText(stdouterr_prg)
