#!/usr/bin/python
'''
//=============================================================================
//
//    File : ufo_discusgui.py
//    Creation date : Wed Dec 05 14:30:48 CEST 2012
//    Working on this file:    asterix (Cristian Steri)
//                            Grifisx (Antonino G. Imbesi)
//     This file is part of the Ufo Wardriving distribution
//
//    Websites: http://ufo-wardriving.com
//
//     This program is FREE software. You can redistribute it and/or
//     modify it under the terms of the GNU General Public License
//     as published by the Free Software Foundation; either version 2
//     of the License, or (at your opinion) any later version.
//
//    This program is distributed in the HOPE that it will be USEFUL,
//     but WITHOUT ANY WARRANTY; without even the implied warranty of
//     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//     See the GNU General Public License for more details.
//
//     You should have received a copy of the GNU General Public License
//     along with this program. If not, write to the Free Software Foundation,
//     Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================
'''

import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
import sys, os.path

from core.ufo_picsfinder import get_icon

from core import ufo_discusdecode

class UFODiscusWidget(QWidget):
    def __init__(self, parent = None):
        super(UFODiscusWidget, self).__init__(parent)

        hBoxLayout = QHBoxLayout()
        hBoxLayout.setSpacing(5)

        vBoxLayout = QVBoxLayout()
        vBoxLayout.setSpacing(5)

        ssidLabel = QLabel("SSID:",self)
        self.ssidLineEdit= QLineEdit(self)
        self.ssidLineEdit.setToolTip("SSID "+_("Compatible")+" : \nDiscus- \nDiscus--")
        self.ssidLineEdit.setInputMask("HHHHHH;-")
        self.ssidLineEdit.setMaxLength(6)

        self.outputTextEdit = QTextEdit(self)
        self.outputTextEdit.setReadOnly(True)

        self.calcPushButton = QPushButton(_("Find"),self)
        self.calcPushButton.setIcon(get_icon("key.png"))
        self.calcPushButton.setEnabled(0)

        hBoxLayout.addWidget(ssidLabel)
        hBoxLayout.addWidget(self.ssidLineEdit)
        hBoxLayout.addWidget(self.calcPushButton)
        vBoxLayout.addLayout(hBoxLayout)
        vBoxLayout.addWidget(self.outputTextEdit)

        self.setLayout(vBoxLayout)

        self.ssidLineEdit.textChanged.connect(self.enable_button)
        self.calcPushButton.clicked.connect(self.find_key)

    def enable_button(self):
        if self.ssidLineEdit.text().length() == 6:
            self.calcPushButton.setEnabled(1)
        else:
            self.calcPushButton.setEnabled(0)

    def find_key(self):
        self.outputTextEdit.setText("")
        ssid_discus = str(self.ssidLineEdit.text())
        ssid_discus = ssid_discus.replace("-","")
        stdouterr_discus = ufo_discusdecode.calc(ssid_discus)
        if stdouterr_discus:
            for passwords in stdouterr_discus:
                self.outputTextEdit.append(passwords)
        else:
            self.outputTextEdit.setText(_("No key found."))
