#!/usr/bin/python
'''
//=============================================================================
//
//    File : ufo_aboutgui.py
//    Creation date : Wed Dec 05 14:30:48 CEST 2012
//    Working on this file:    asterix (Cristian Steri)
//                            Grifisx (Antonino G. Imbesi)
//     This file is part of the Ufo Wardriving distribution
//
//    Websites: http://ufo-wardriving.com
//
//     This program is FREE software. You can redistribute it and/or
//     modify it under the terms of the GNU General Public License
//     as published by the Free Software Foundation; either version 2
//     of the License, or (at your opinion) any later version.
//
//    This program is distributed in the HOPE that it will be USEFUL,
//     but WITHOUT ANY WARRANTY; without even the implied warranty of
//     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//     See the GNU General Public License for more details.
//
//     You should have received a copy of the GNU General Public License
//     along with this program. If not, write to the Free Software Foundation,
//     Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================
'''

import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtWebKit import *

import sys, os.path
import subprocess
import re
import platform

from core.ufo_picsfinder import get_icon
from core.ufo_finddir import find_dir
from ui import ufo_scanelement



class UFOAboutWidget(QWidget):
    def __init__(self, parent=None):
        super(UFOAboutWidget, self).__init__(parent)
        self.setMaximumHeight(300)
        self.setMaximumWidth(300)
        self.setWindowTitle("About")
        self.setWindowIcon(get_icon("about.png"))
        hBoxLayout = QHBoxLayout()
        hBoxLayout.setSpacing(5)
        
        vBoxLayout = QVBoxLayout()
        vBoxLayout.setSpacing(5)


        aboutLabel = QLabel(_("<b>UFO Wardriving V4 'Invasion'<\b> <br> Forged by <b>UFO Wd Development Team</b>"))
        
        closePushButton = QPushButton(_("Close"),self)
        closePushButton.setIcon(get_icon("close.png"))
        closePushButton.setToolTip(_("Close"))


        splashWidget = QWidget()
        pix =QPixmap(find_dir("/pics/splashabout.png"))
        l = QLabel(splashWidget)
        b = QVBoxLayout(splashWidget)
        l.setAlignment(Qt.AlignCenter)
        l.setPixmap(pix)
        b.addWidget(l)
        
        infoView = QWebView()
        infoView.setHtml(open(find_dir("/doc/developers.html")).read())
        
        licenseView = QWebView()
        licenseView.setHtml(open(find_dir("/doc/copying/ufo_license.html")).read())
        
        infoVBox = QVBoxLayout()
        splashVBox = QVBoxLayout()
        licenseVBox = QVBoxLayout()
        
        infoVBox.addWidget(infoView)
        splashVBox.addWidget(splashWidget)
        licenseVBox.addWidget(licenseView)
        
        self.tabWidget = QTabWidget()

        self.splashTab    = QWidget(self.tabWidget)
        self.infoTab    = QWidget(self.tabWidget)
        self.licenseTab    = QWidget(self.tabWidget)

        self.tabWidget.addTab(self.splashTab,get_icon("ufo.png"),_("About"))
        self.tabWidget.addTab(self.infoTab,get_icon("developer.png"),_("Working on it..."))
        self.tabWidget.addTab(self.licenseTab,get_icon("license.png"),_("License"))
        
        self.splashTab.setLayout(splashVBox)
        self.infoTab.setLayout(infoVBox)
        self.licenseTab.setLayout(licenseVBox)
        
        hBoxLayout.addWidget(aboutLabel)
        hBoxLayout.addWidget(closePushButton)
        vBoxLayout.addWidget(self.tabWidget)
        vBoxLayout.addLayout(hBoxLayout)
        
        self.setLayout(vBoxLayout)
            
        closePushButton.clicked.connect(self.close)
