#!/usr/bin/env python
# -*- coding: utf-8 -*-

import gettext
import locale
import platform
import os.path
import sys

def translate():
    if platform.system() == "Windows":
        import gettext_windows
        gettext_windows.setup_env()

    locale.setlocale(locale.LC_ALL, '') 
    language, encoding = locale.getdefaultlocale()
    language_file = "%s.mo" % (language)
    dir_loc = repr(os.path.dirname(os.path.realpath(sys.argv[0]))).replace("\\\\","/").replace("\'","")+"/locale/"
    filename = "%s%s" % (dir_loc, language_file)
    try:
        trans = gettext.GNUTranslations(open( filename, "rb" ))
    except IOError:
        trans = gettext.NullTranslations()
    trans.install()

translate()
