#!/usr/bin/python
'''
//=============================================================================
//
//  File : ufonm.py
//  Creation date : Mon Gen 21 14:30:48 CEST 2013
//  Working on this file:   asterix (Cristian Steri)
//            Grifisx (Antonino G. Imbesi)
//   This file is part of the Ufo Wardriving distribution
//
//  Websites: http://ufo-wardriving.com
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//  This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================
'''
from PyQt4.QtCore import *

import sys
import subprocess
import time
from core.ufo_define import *

def start_def_network_manager():
    if DEFINE_DISTRO_FEDORA == False:
        subprocess.call(["start","network-manager"])
    else:
        subprocess.call(["/etc/init.d/NetworkManager","start"])
            
def stop_def_network_manager():
    if DEFINE_DISTRO_FEDORA == False:
        subprocess.call(["stop","network-manager"])
    else:
        subprocess.call(["/etc/init.d/NetworkManager","stop"])
            
def init_def_network_manager():
    if DEFINE_DISTRO_FEDORA == False:
        subprocess.call(["stop","network-manager"])
        subprocess.call(["start","network-manager"])
        subprocess.call(["stop","network-manager"])
    else:
        subprocess.call(["/etc/init.d/NetworkManager","stop"])
        subprocess.call(["/etc/init.d/NetworkManager","start"])
        subprocess.call(["/etc/init.d/NetworkManager","stop"])
            
def wake_up_ifaces():
    #p = subprocess.Popen(['/sbin/wpa_cli','interface'], stdout = subprocess.PIPE)
    subprocess.call(["wpa_cli","terminate"])
    p = subprocess.Popen(['iwconfig'],stdout = subprocess.PIPE)
    p.wait()
    (stdout,stderr) = p.communicate(None)
    l = stdout.split('\n')
    for i in l:
        s = i.split(' ')[0]
        if s !="" and len(s) < 6:
            subprocess.call(["ifconfig",s,"down"])
            time.sleep(2)
            subprocess.call(["ifconfig",s,"up"])
            time.sleep(2)
            subprocess.call(["iwlist", s, "scanning"])

