/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.graphics.PDLineDashPattern;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;

public class SetLineDashPattern
extends OperatorProcessor {
    private static final Log LOG = LogFactory.getLog(SetLineDashPattern.class);

    @Override
    public void process(PDFOperator operator, List<COSBase> arguments) throws IOException {
        COSArray dashArray = (COSArray)arguments.get(0);
        int dashPhase = ((COSNumber)arguments.get(1)).intValue();
        if (dashPhase < 0) {
            LOG.warn("dash phaseStart has negative value " + dashPhase + ", set to 0");
            dashPhase = 0;
        }
        PDLineDashPattern lineDash = new PDLineDashPattern(dashArray, dashPhase);
        this.context.getGraphicsState().setLineDashPattern(lineDash);
    }
}

