/*
 * Decompiled with CFR 0.152.
 */
package Utility_Code.Static_Methods;

import Utility_Code.Third_Party_Content.DialogFX;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;

public class ErrorHandlers {
    public static void ioExportError(String fileType) {
        DialogFX ioWar = new DialogFX(DialogFX.Type.ERROR);
        ioWar.setTitle("Error!");
        ioWar.setMessage("The " + fileType + " was not saved to the location chosen, please check file and folder permissions or try a different location.");
        ioWar.showDialog();
    }

    public static void saveFileError() {
        DialogFX sfWar = new DialogFX(DialogFX.Type.ERROR);
        sfWar.setTitle("Error!");
        sfWar.setMessage("A problem was encountered while setting up the Local Data Cache for DISA STIG Viewer. \nAll changes made and imports will be temporary and not maintained across sessions.");
        sfWar.showDialog();
    }

    public static void XCCDFImportErrorNamespace() {
        DialogFX imWar = new DialogFX(DialogFX.Type.ERROR);
        imWar.setTitle("Import Error!");
        imWar.setMessage("The specified documents do not contain a valid XCCDF XML Namespace and are not valid XCCDF files.");
        imWar.showDialog();
    }

    public static void XCCDFImportErrorFormat() {
        DialogFX imWar = new DialogFX(DialogFX.Type.ERROR);
        imWar.setTitle("Import Error!");
        imWar.setMessage("The specified XCCDF documents contain an error and cannot be processed.");
        imWar.showDialog();
    }

    public static void multiChecklistError() {
        DialogFX ChkExistsAlert = new DialogFX(DialogFX.Type.ERROR);
        ChkExistsAlert.setTitleText("Checklist Exists!");
        ChkExistsAlert.setMessage("You cannot import a checklist while one currently exists. In order to import a new checklist please save and close the one currently open.");
        ChkExistsAlert.showDialog();
    }

    public static void noStigSelected() {
        DialogFX NoCurrentSTIG = new DialogFX(DialogFX.Type.ERROR);
        NoCurrentSTIG.setTitleText("No STIGs Loaded!");
        NoCurrentSTIG.setMessage("There is no current STIG loaded. A checklist can not be created.");
        NoCurrentSTIG.showDialog();
    }

    public static void XCCDFImportError() {
        DialogFX imWar = new DialogFX(DialogFX.Type.ERROR);
        imWar.setTitle("Import Error!");
        imWar.setMessage("The specified document cannot be imported as a STIG.");
        imWar.showDialog();
    }

    public static boolean vulnCmpOnly() {
        DialogFX noMatchingSTIG = new DialogFX(DialogFX.Type.QUESTION);
        noMatchingSTIG.setTitleText("No matching STIG Found!");
        noMatchingSTIG.setMessage("There is at least one non-matching STIG in the selected Checklist. Import data on a matching vulnerability only basis?");
        boolean okNotOk = false;
        ArrayList<String> buttons = new ArrayList<String>();
        buttons.add("OK");
        buttons.add("Cancel");
        noMatchingSTIG.addButtons(buttons);
        if (noMatchingSTIG.showDialog() == 0) {
            okNotOk = true;
        }
        return okNotOk;
    }

    public static int STIGOverwrite(String STIGName) {
        DialogFX noMatchingSTIG = new DialogFX(DialogFX.Type.QUESTION);
        noMatchingSTIG.setTitleText("STIG Overwrite Warning!");
        noMatchingSTIG.setMessage("There is a matching STIG file already included in STIG Viewer. Overwrite " + STIGName + "?");
        ArrayList<String> buttons = new ArrayList<String>();
        buttons.add("OK to All");
        buttons.add("OK");
        buttons.add("Cancel");
        noMatchingSTIG.addButtons(buttons);
        int choice = noMatchingSTIG.showDialog();
        return choice;
    }

    public static void importError(Window w, List<String> noIn) {
        Stage resultWarning = new Stage();
        resultWarning.initModality(Modality.WINDOW_MODAL);
        resultWarning.initOwner(w);
        String SVids = "";
        for (String s : noIn) {
            SVids = SVids + s + "\n";
        }
        TextArea message = new TextArea("Files not imported, no populated or well formed DISA STIGs found in XML file:\n\n" + SVids);
        message.setEditable(false);
        ScrollPane scPane = new ScrollPane();
        scPane.setContent((Node)message);
        scPane.setFitToHeight(true);
        scPane.setFitToWidth(true);
        Scene getJustScene = new Scene((Parent)scPane, 400.0, 300.0);
        resultWarning.setScene(getJustScene);
        resultWarning.setTitle("Warning! Listed Files Were Not Imported!");
        resultWarning.show();
    }

    public static void checklistImportError(String message) {
        DialogFX imWar = new DialogFX(DialogFX.Type.ERROR);
        imWar.setTitle("Checklist import error");
        imWar.setMessage(message);
        imWar.showDialog();
    }
}

