/*
 * Decompiled with CFR 0.152.
 */
package Shared_Constructs.STIGList;

import File_Operations.File_Objects.STIG;
import Program_Tabs.interfaces.STIGDisplayTab;
import Shared_Constructs.STIGList.STIGTableItem;
import Shared_Constructs.STIGList.StigList_Abstract;
import Utility_Code.GlobalSettings.Preferences_Window.PrefSet;
import java.util.ArrayList;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;

public class StigList_Explorer
extends StigList_Abstract {
    public StigList_Explorer(STIGDisplayTab Parent2, ArrayList<StigList_Abstract.STIGDispColumn> ColumnSet) {
        super(Parent2, ColumnSet);
    }

    @Override
    public TableView createTable() {
        this.myTable = new TableView();
        this.myTable.setRowFactory(this.getSLRowFactory());
        this.myTable.setStyle(PrefSet.getPS().getJfxBackground());
        this.columns = FXCollections.observableArrayList();
        for (StigList_Abstract.STIGDispColumn dc : this.myDispSet) {
            switch (dc) {
                case STIGName: {
                    this.createSTIGNameColumn();
                    this.STIGNameColumn.setVisible(true);
                    this.columns.add((Object)this.STIGNameColumn);
                    break;
                }
                case STIGFileName: {
                    this.createSTIGFileNameColumn();
                    this.STIGFileNameColumn.setVisible(false);
                    this.columns.add((Object)this.STIGFileNameColumn);
                    break;
                }
                case CustomName: {
                    this.createCustomNameColumn();
                    this.CustomNameColumn.setVisible(false);
                    this.columns.add((Object)this.CustomNameColumn);
                    break;
                }
                case STIGVersion: {
                    this.createSTIGVersionColumn();
                    this.STIGVersionColumn.setVisible(false);
                    this.columns.add((Object)this.STIGVersionColumn);
                    break;
                }
                case Check: {
                    this.createSTIGCheckColumn();
                    this.STIGCheckColumn.setVisible(true);
                    this.columns.add((Object)this.STIGCheckColumn);
                    break;
                }
                case ReleaseID: {
                    this.createSTIGReleaseIDColumn();
                    this.STIGReleaseIDColumn.setVisible(false);
                    this.columns.add((Object)this.STIGReleaseIDColumn);
                    break;
                }
            }
        }
        this.myTable.getColumns().addAll((Collection)this.columns);
        this.myTable.setEditable(true);
        this.myTable.setTableMenuButtonVisible(true);
        this.myTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        STIGTableContextMenu stcm = new STIGTableContextMenu(this);
        this.myTable.setContextMenu(stcm.getMenu());
        this.myTable.setPrefHeight(3000.0);
        return this.myTable;
    }

    @Override
    public void handleCheckChange() {
        ArrayList<STIG> STIGList = new ArrayList<STIG>();
        for (Object o : this.myTable.getItems()) {
            STIGTableItem sti = (STIGTableItem)o;
            if (!sti.bGetIsChecked()) continue;
            STIGList.add(sti.getSTIG());
        }
    }

    public void RemoveSTIGs() {
        ArrayList<STIG> alSTIGs = new ArrayList<STIG>();
        for (Object o : this.myTable.getSelectionModel().getSelectedItems()) {
            STIGTableItem sti = (STIGTableItem)o;
            alSTIGs.add(sti.getSTIG());
        }
        this.myTable.getItems().removeAll((Collection)this.myTable.getSelectionModel().getSelectedItems());
        this.myParent.RemoveSTIGs(alSTIGs);
        this.myParent.updateSTIGTabGUI();
    }

    private void setChecks(boolean onOff) {
        for (STIGTableItem row : this.myTable.getItems()) {
            row.setIsChecked(onOff);
        }
        this.signalStigListUpdate();
    }

    @Override
    public void changeSTIGList(ArrayList<STIG> STIGList) {
        if (!STIGList.isEmpty()) {
            int CurrentSTIGIndex;
            this.data = FXCollections.observableArrayList();
            if (this.myTable.getItems() != null) {
                for (CurrentSTIGIndex = 0; CurrentSTIGIndex < STIGList.size(); ++CurrentSTIGIndex) {
                    boolean trig = true;
                    STIG CurrentSTIG = STIGList.get(CurrentSTIGIndex);
                    for (int dispSTIGindex = 0; dispSTIGindex < this.myTable.getItems().size(); ++dispSTIGindex) {
                        STIGTableItem dispSTIGT = (STIGTableItem)this.myTable.getItems().get(dispSTIGindex);
                        STIG dispSTIG = dispSTIGT.getSTIG();
                        if (!CurrentSTIG.getSTIG_UUID().equals(dispSTIG.getSTIG_UUID())) continue;
                        this.data.add((Object)((STIGTableItem)this.myTable.getItems().get(dispSTIGindex)));
                        trig = false;
                    }
                    if (!trig) continue;
                    this.data.add((Object)new STIGTableItem(CurrentSTIG, this));
                }
            } else {
                for (CurrentSTIGIndex = 0; CurrentSTIGIndex < STIGList.size(); ++CurrentSTIGIndex) {
                    STIG CurrentSTIG = STIGList.get(CurrentSTIGIndex);
                    this.data.add((Object)new STIGTableItem(CurrentSTIG, this));
                }
            }
            if (this.STIGNameColumn != null) {
                this.STIGNameColumn.setCellValueFactory((Callback)new PropertyValueFactory("STIGName"));
            }
            if (this.STIGFileNameColumn != null) {
                this.STIGFileNameColumn.setCellValueFactory((Callback)new PropertyValueFactory("STIGFileName"));
            }
            if (this.CustomNameColumn != null) {
                this.CustomNameColumn.setCellValueFactory((Callback)new PropertyValueFactory("CustomName"));
            }
            if (this.STIGVersionColumn != null) {
                this.STIGVersionColumn.setCellValueFactory((Callback)new PropertyValueFactory("STIGVersion"));
            }
            if (this.STIGCheckColumn != null) {
                this.STIGCheckColumn.setCellValueFactory((Callback)new PropertyValueFactory("STIGCheck"));
            }
            if (this.STIGReleaseIDColumn != null) {
                this.STIGReleaseIDColumn.setCellValueFactory((Callback)new PropertyValueFactory("ReleaseID"));
            }
            this.myTable.setItems(this.data);
            ArrayList<STIG> ret = new ArrayList<STIG>();
            for (int dispSTIGindex = 0; dispSTIGindex < this.myTable.getItems().size(); ++dispSTIGindex) {
                STIGTableItem dispSTIGT = (STIGTableItem)this.myTable.getItems().get(dispSTIGindex);
                STIG dispSTIG = dispSTIGT.getSTIG();
                if (!dispSTIGT.bGetIsChecked()) continue;
                ret.add(dispSTIG);
            }
            this.myParent.changeCurrentSTIG(ret);
        } else {
            this.myTable.setItems(null);
            this.myParent.changeCurrentSTIG(null);
        }
    }

    private final class STIGTableContextMenu {
        private final ContextMenu TableCellContextMenu = new ContextMenu();

        public STIGTableContextMenu(StigList_Explorer parent) {
            MenuItem SelectAll = new MenuItem("Check All");
            SelectAll.setOnAction(new EventHandler(){

                public void handle(Event t) {
                    StigList_Explorer.this.setChecks(true);
                }
            });
            MenuItem DeselectAll = new MenuItem("Uncheck All");
            DeselectAll.setOnAction(new EventHandler(){

                public void handle(Event t) {
                    StigList_Explorer.this.setChecks(false);
                }
            });
            MenuItem RemoveSTIGs = new MenuItem("Remove Highlighted STIG(s)");
            RemoveSTIGs.setOnAction(new EventHandler(){

                public void handle(Event t) {
                    StigList_Explorer.this.RemoveSTIGs();
                }
            });
            this.TableCellContextMenu.getItems().add((Object)SelectAll);
            this.TableCellContextMenu.getItems().add((Object)DeselectAll);
            this.TableCellContextMenu.getItems().add((Object)new SeparatorMenuItem());
            this.TableCellContextMenu.getItems().add((Object)RemoveSTIGs);
        }

        public ContextMenu getMenu() {
            return this.TableCellContextMenu;
        }
    }
}

