/*
 * Decompiled with CFR 0.152.
 */
package Shared_Constructs.Rule_Display;

import File_Operations.File_Objects.Vuln;
import File_Operations.Legacy.File_Interfaces.CCIReader;
import Program_Tabs.Tab_STIG.STIGDriver;
import Program_Tabs.Tab_STIG.STIGViewTab;
import Program_Tabs.Tab_STIG.STIGs_Ctrl;
import Shared_Constructs.Rule_Display.STIGs_Rule_Display;
import Utility_Code.Static_Methods.TextReplace;
import java.util.LinkedHashMap;

public class STIGs_Rule_Display_Controller
extends STIGs_Ctrl {
    private STIGs_Rule_Display RDisplay;

    public STIGs_Rule_Display_Controller(STIGViewTab svt, STIGDriver sdrive, STIGs_Rule_Display rdisplay) {
        super(svt, sdrive);
        this.RDisplay = rdisplay;
    }

    @Override
    public void Signal_Update(String code) {
        this.titleChange();
        this.bodyChange();
    }

    private void titleChange() {
        Vuln v = this.DisplayDriver.getCurrentSelectedVuln();
        LinkedHashMap<String, String> meta = new LinkedHashMap<String, String>();
        meta.put("Vul ID", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Vuln_Num), this.DisplayTab.getFilterPane().getFilterText("VulnID")));
        meta.put("Rule ID", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Rule_ID), this.DisplayTab.getFilterPane().getFilterText("RuleID")));
        meta.put("STIG ID", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Rule_Ver), this.DisplayTab.getFilterPane().getFilterText("STIGID")));
        meta.put("Severity", TextReplace.HTMLForm(TextReplace.getCatFromSev(v.getAttr(Vuln.VulnAttr.Severity)), this.DisplayTab.getFilterPane().getFilterText("Severity")));
        if (!v.getAttr(Vuln.VulnAttr.Check_Content_Ref).equals("M")) {
            meta.put("Check Reference", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Check_Content_Ref), this.DisplayTab.getFilterPane().getFilterText("General")));
        }
        meta.put("Classification", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Class), this.DisplayTab.getFilterPane().getFilterText("General")));
        this.RDisplay.changeTitleText(v.getAttr(Vuln.VulnAttr.STIGRef), meta);
    }

    private void bodyChange() {
        Vuln v = this.DisplayDriver.getCurrentSelectedVuln();
        LinkedHashMap<Object, String> rd = new LinkedHashMap<Object, String>();
        rd.put("Group Title", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Group_Title), this.DisplayTab.getFilterPane().getFilterText("General")));
        rd.put("Rule Title", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Rule_Title), this.DisplayTab.getFilterPane().getFilterText("RuleTitle")));
        rd.put("Discussion", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Vuln_Discuss), this.DisplayTab.getFilterPane().getFilterText("Discussion")));
        rd.put("Check Text", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Check_Content), this.DisplayTab.getFilterPane().getFilterText("CheckContent")));
        rd.put("Fix Text", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Fix_Text), this.DisplayTab.getFilterPane().getFilterText("FixText")));
        LinkedHashMap<String, String> ref = new LinkedHashMap<String, String>();
        String ccis = new String();
        for (CCIReader.CCI_Store c : v.GetCCIs()) {
            ccis = ccis + "\n" + c.sID + ": " + c.sDefinition + "\n";
            for (int i = 0; i < c.sRefs.size(); ++i) {
                ccis = ccis + c.sRefs.get(i).getFirst() + " :: " + c.sRefs.get(i).getSecond() + "\n";
            }
        }
        ref.put("CCI", TextReplace.HTMLForm(ccis, this.DisplayTab.getFilterPane().getFilterText("CCIText")));
        LinkedHashMap<String, String> misc = new LinkedHashMap<String, String>();
        misc.put("Severity Override Guidance", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Security_Override_Guidance), this.DisplayTab.getFilterPane().getFilterText("General")));
        misc.put("IA Controls", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.IA_Controls), this.DisplayTab.getFilterPane().getFilterText("MiscText")));
        misc.put("False Positives", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.False_Positives), this.DisplayTab.getFilterPane().getFilterText("General")));
        misc.put("False Positives", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.False_Negatives), this.DisplayTab.getFilterPane().getFilterText("General")));
        misc.put("Mitigations", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Mitigations), this.DisplayTab.getFilterPane().getFilterText("General")));
        misc.put("Potential Impact", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Potential_Impact), this.DisplayTab.getFilterPane().getFilterText("General")));
        misc.put("Third Party Tools", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Third_Party_Tools), this.DisplayTab.getFilterPane().getFilterText("General")));
        misc.put("Mitigation Control", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Mitigation_Control), this.DisplayTab.getFilterPane().getFilterText("General")));
        this.RDisplay.changeBodyText(rd, ref, misc);
    }
}

