/*
 * Decompiled with CFR 0.152.
 */
package Program_Tabs.Tab_STIG;

import Shared_Constructs.FilteredEventDispatcher;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebView;
import javafx.stage.Stage;

public class STIGViewerGUIReadMe {
    final Stage stage = new Stage();
    final String content_markup = "<div id='read-me-content-container' style='font-family:segoe ui;'><h2 style='text-align:center'>STIG Viewer README File</h2><table style='width:90%;margin:0 auto;'><tbody><tr><th style='border-bottom:1px solid #bbb'>End User License Agreement</th></tr><tr><td>The \"DISA STIG Viewer\" Tool is a free program provided <b>\"AS IS\"</b>. This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. By using the DISA STIG Viewer, you agree to the terms listed above.</td></tr><tr style='height:15px'></tr><tr><th style='border-bottom:1px solid #bbb'>Important Notes</th></tr><tr><td>STIG Compatibility: The STIG Viewer is currently compatible only with DISA STIGs that have been converted into XCCDF 1.1 and 1.2 XML formats.  STIG documents not in this format will likely not work well with the STIG Viewer.<br/><br/>STIG Viewer is currently compiled with Java 8.<br/><br/>The STIGs List under the \"Checklist\" tab computes its scores considering a static weight of \"10\" for all rules. Many STIGs provided by DISA currently have each rule's weight set to a static value of \"10\". In the future, the score will consider the individual weight value of each rule.<br/><br/></td></tr><tr><th style='border-bottom:1px solid #bbb'>Known Bugs</th></tr><tr><td>The STIG Viewer currently has limited compatibility with UNIX/Linux systems. In order to run STIG Viewer on a Linux system, the user must install Oracle's JRE or JDK. Depending on the Linux distribution, some features may work better than others.<br/> - On Red Hat Enterprise Linux, the Checklist \"Get Target Data\" button does not function.<br/> - STIG Viewer is currently not supported on Solaris.</td></tr><tr style='height:20px'></tr><tr><th style='text-align:left;border-bottom:1px solid #bbb'>Table of Contents</th></tr><tr><td><b>1000 - STIG Explorer Tab Program Functions</b><br/>1010 - Local Data Cache<br/>1020 - Importing a STIG<br/>1025 - Exporting a STIG<br/>1030 - STIGs Panel<br/>1040 - Filter Panel<br/>1050 - Vul Table<br/><br/><b>1500 \u2013 Preferences Menu Functions</b><br/>1510 \u2013 Preferences General Tab<br/>1520 \u2013 Preferences Checklist Tab<br/><br/><b>2000 - Checklist Tab Functions</b><br/>2010 - Opening a Checklist<br/>2015 - Checklist Menu Options<br/>2020 - Totals Panel<br/>2030 - Target Data Panel<br/>2035 \u2013 STIGs Panel<br/>2040 - Technology Area Panel<br/>2041 - Filter Panel<br/>2045 - Vul Table<br/>2050 - Vul Display<br/>2051 - Classic 2.x Display Vul Information Panel<br/>2052 - Finding Details and Comments Panels/Areas<br/></td></tr><tr style='height:15px'></tr><tr><th style='border-bottom:1px solid #bbb'>1000: STIG Explorer Program Functions </th></tr><tr><td><b>1010: Local Data Cache</b><br/><br/>STIG Viewer creates and maintains a Local Data Cache responsible for storing imported STIGs and program configurations. The Local Data Cache is created upon initialization of the program and may be deleted at any time. Upon deletion, the Local Data Cache is recreated, saving further changes, before next close.<br/><br/> If the Local Data Cache cannot be created, a warning message will be presented to the user detailing that STIG Viewer is unable to save state between opening and closing.<br/><br/> In order to fully delete the Local Data Cache, go to:<br/>Options >> Delete Local Data Cache<br/><br/><br/><b>1020: Importing a STIG</b><br/><br/>File menu:<br/>File >> Import STIG<br/><br/>STIGs may be imported as a STIG XML File (.xml) file or as a STIG ZIP File (.zip) bundle. STIG Viewer fully supports importing DISA STIGs that use SCAP 1.1 or SCAP 1.2. Other STIGs may be imported with varying success.<br/><br/><br/><b>1025: Exporting a STIG</b><br/><br/>STIG Viewer is able to export the selected STIG(s) in three different formats: webpage (.html), rich text document (.rtf), or comma separated values file (.csv).<br/><br/>File menu:<br/>Export >> Webpage(.html)<br/><br/>File menu:<br/>Export >> Document(.rtf)<br/><br/>File menu:<br/>Export >> Spreadsheet(.csv)<br/><br/>Export to CSV allows selection of which STIG fields to include in the export. At least one field must be selected. The order of columns in the CSV file is based on the default for a full export and cannot be modified.<br/><br/>STIG Spreadsheet (.csv) exports truncate element contents at 32,700 characters; just shy of the maximum characters per cell value defined by Microsoft Excel.<br/><br/><br/><b>1030: STIGs Panel</b><br/><br/>The STIGs panel is responsible for selecting STIGs to be viewed by the STIG Viewer, as well as maintaining the STIGs held in the Local Data Cache. The visible columns of the STIGs list may be altered by selecting the plus sign in the upper right corner of the table and then selecting and deselecting the options shown.<br/><br/>There are two main forms of selection associated with the STIGs panel: highlighting and check marking. A highlighted selection is used for deletion purposes. A check-marked STIG is automatically sent to be displayed along with the other checked STIGs. Additionally, check-marked STIGs are used when a checklist is created or an export option is chosen.<br/><br/>- Left-clicking without holding down the \"ctrl\" or \"shift\" keys both checks (or unchecks) and highlights the given selection.<br/><br/>- Left-clicking while the \"ctrl\" or \"shift\" key is pressed highlights (or de-highlights) STIGs only.<br/><br/>- Right-clicking the STIGs list will highlight the given selection and open up a menu with the options to \"Check All\", \"Uncheck All\", and \"Remove Highlighted STIG(s)\".<br/><br/>- The \"Remove Highlighted STIG(s)\" option will delete any STIGs that are highlighted, regardless of their \"check-mark\" status.<br/><br/>Below the STIG list lies the profile selection drop-down menu. Selecting a profile will alter what vulnerabilities are sent to the Vul table by the checked STIGs based on the profile selected. The displayed profiles in the profile list correspond to the profiles listed in the selected STIGs.<br/><br/><br/><b>1040: Filter Panel</b><br/><br/>STIGs in STIG Viewer are searchable by way of a filtered search list. This list is maintained on the left side of the screen, beneath the STIGs panel.<br/><br/>The Filters applied in STIG Viewer will affect the current visible vulnerabilities that are displayed in the center Vul table. Successive additions to the table (check marking another STIG) will also be filtered based on the current list of filters. Chosen filter words will be highlighted in the display panels corresponding to the filter type.<br/><br/>The various filters currently do not affect what selections are sent to the Export functions, or checklist creation.<br/><br/>- Adding a filter:<br/>Select a filter from the drop down menu, input a keyword if necessary, select whether the filter will include or  exclude the selection, and press the \"Add\" button.<br/><br/>- Removing a filter:<br/>Highlight the desired filter in the list of current applied filters. Multiple filters in this list can be highlighted by \"Shift\" and/or \"Ctrl\" clicking entries. Press the \"Remove Filter(s)\" button to remove those filters selected or press the \"Remove All Filters\" button to remove all current filters.<br/><br/>- Combining filters:<br/>By default, all filter selections are applied simultaneously. Clicking \"Any\" changes the filter so that a Vulnerability matching any single filter will be included in the results.<br/><br/>Following are the various types of filters and their corresponding elements searched:<br/><br/>Keyword<br/>- Searches most text fields in all Vuls currently displayed, does not check the \"Severity\" attribute<br/><br/>Rule Title<br/>- Searches the \"Rule Title\" text of all Vuls currently displayed<br/><br/>STIG ID<br/>- Searches the STIG ID of all Vuls currently displayed<br/><br/>Vulnerability ID<br/>- Searches the Vul ID of all Vuls currently displayed<br/><br/>Rule ID<br/>- Searches the Rule ID of all Vuls currently displayed<br/><br/>IA Control<br/>- Searches the IA Control value(s) of all Vuls currently displayed<br/><br/>CAT I<br/>- Shows or hides currently displayed Vuls that are considered CAT Is<br/><br/>CAT II<br/>- Shows or hides currently displayed Vuls that are considered CAT IIs<br/><br/>CAT III<br/>- Shows or hides currently displayed Vuls that are considered CAT IIIs<br/><br/>CCI<br/>- Searches CCI number, description, and reference of currently displayed Vuls<br/><br/><br/><b>1050: Vul Table</b><br/><br/>To view a particular entry in the Vul table, select an entry in the center table.<br/><br/>The selected vulnerability will populate the right side of the screen, which consists of two resizable areas that hold the STIG Title/ID information and the rest of the STIG information, respectively. If one of the \"Classic 2.x\" themes is selected, the right panel will hold the \"General Information\", \"Discussion\", \"Fix Text\", \"Check Content\", \"CCI\", and \"Miscellaneous\" panels instead of the resizable areas. If a STIG does not have information for a particular entry in any display theme, the entry will not be displayed.<br/><br/>Like the \"STIGs\" panel, the Vul Table's visible columns can be altered by selecting the various options brought up by clicking the plus sign in the top right corner of the table.<br/><br/>The available selections in the Vul table are affected by what is checked in the \"STIGs\" panel, and by what filters are applied by the \"Filter\" panel.<br/><br/><br/></td></tr><tr style='height:15px'></tr><tr><th style='border-bottom:1px solid #bbb'>1500: Preferences Menu Functions</th></tr><td><b>1510: Preferences General Tab </b><br/><br/>Font Size<br/>- To change the font size of STIG Viewer's display windows, input a number and press \"Enter\". In the case of non-number input, the selection defaults to \"14\".<br/><br/>Font<br/>- To change the style of STIG Viewer's display windows, choose a font from the drop-down menu.<br/><br/>Visual Style<br/>- To change the overall appearance of STIG Viewer, select one of the options from the drop-down menu.<br/><br/>Output Logging to File<br/>- When the \"Output Logging to File\" box is checked, STIG Viewer will output a file in the same directory as the .jar file called the \"ActionLog\". This file holds a list of actions taken by the user to aid in a debugging scenario. When this option is not checked, STIG Viewer does not log its events, nor does it create the \"ActionLog\" file.<br/><br/><br/><b>1520: Checklist General Tab </b><br/><br/>Color Selectors<br/>- The \"Checklist\" tab in the \"Preferences\" menu has five color selection menus that correspond to each possible status of a vulnerability. Changing the colors in the given selectors will change the color that is displayed by the center table when a status is given to a specific vulnerability. The chosen colors are also reflected in the pie chart. The pie chart \"Open\" color reflects the color chosen for \"CAT I\" statuses.<br/><br/>File Settings<br/>- The \"Validate Checklist\" box determines whether a \"CKL\" file will be validated against a Checklist schema upon import. If the \"CKL\" file is invalid, an error will be displayed. STIG Viewer does not provide assistance in debugging user-modified \"CKL\" files.<br/><br/><br/></td></tr><tr style='height:15px'></tr><tr><th style='border-bottom:1px solid #bbb'>2000: Checklist tab </th></tr><tr><td><b>2010: Opening a Checklist</b><br/><br/>There are a few options for opening a new checklist. All are listed under the \"Checklist\" menu option given in the STIG Explorer. All options, when selected, will open up and switch windows to the \"Checklist\" tab.<br/><br/>Checklist >> Open Checklist from File<br/>- This option will open a checklist from file. Checklists from STIG Viewer 2.x and 1.x versions should be able to be opened by STIG Viewer 2.5 and on, however, checklists from version 2.5 and on will not be able to be opened by previous versions of STIG Viewer.<br/><br/>Checklist >> Create Checklist - Check Marked STIG(s)<br/>- A new checklist will be created that consists of vulnerabilities from the STIGs that are currently checked in the \"STIGs\" panel.<br/><br/><br/><b>2012: Checklist Keyboard Shortcuts</b><br/><br/>There are four main keyboard shortcuts supported by a Checklist tab other than those used to change vulnerability status (listed under section 2050: \"Vul Display\"). Select the Checklist window once a checklist has been created in order to use the shortcuts. To select the window, either tap the \"Tab\" key, or click anywhere on the checklist. All four keyboard shortcuts are control key based, in other words, press the  \"Ctrl\" key followed by the key after the plus sign.<br/><br/>Ctrl + 1<br/>Switch to the center table, use arrow keys to switch between entries and use shortcuts listed under section 2050: \"Vul Display\" to change their statuses.<br/><br/>Ctrl + 2<br/>Select the \"Status\" dropdown menu in the Rule Display. If a \"Classic\" theme is selected, instead switch to the \"Vul Information\" window. Use arrow keys to change tabs.<br/><br/>Ctrl + 3<br/>Switch to the \"Finding Details\" text area.<br/><br/>Ctrl + 4<br/>Switch to the \"Comments\" text area.<br/><br/><br/><b>2015: Checklist Menu Options</b><br/><br/>The \"Checklist\" tab has four main menu items: \"File\", \"Import\", \"Export\", and \"Options\". The options under \"File\" deal with saving the current checklist. The \"Import\" item deals with importing \"XCCDF\" results and saved \"checklist\" files to the current checklist. \"Export\" provides options for exporting a checklist to a different format. \"Options\" provides access to the STIG Viewer \"Preferences\" menu.<br/><br/>File >> Save Checklist<br/>- If the checklist already represents a checklist file saved to the system, this option will save the current checklist to that file. Otherwise, the option will open a \"Save as\" menu that allows the user to save the checklist to a checklist file on the system.<br/><br/>File >> Save Checklist As<br/>- \"Save Checklist As\" allows the user to save the current checklist to a file of his or her choosing on the system that is running STIG viewer. The checklist file may be opened at a later time or on a different instance of STIG Viewer using the \"Open Checklist from File\" option on the \"STIG Explorer\" tab.<br/><br/>Import >> XCCDF Results File<br/>- Import and apply an XCCDF Results file to the STIGs that were used to create the checklist. XCCDF Results will be mapped to their corresponding STIG rules. If any XCCDF Results are imported that do not have a matching rule in the Checklist, a window will pop-up and display the offending rule ID's from the Results file. Supported XCCDF Result formats: HBSS ePO/PAA, OVALdi (ACAS), and SPAWAR SCC.<br/><br/>Import >> Checklist Data<br/>- Import data from a saved checklist file into the current checklist. Generally this feature will be used to import data from a checklist that uses an older version of a STIG into a checklist that was created with the new version of the STIG.<br/><br/>Export >> Gen. CMRS Import File<br/>- Takes the information that has been inputted into the checklist and creates a \"CMRS import\" file.<br/><br/>Export >> Data Export (.csv)<br/>- Takes the information that has been inputted into the checklist and creates a comma-separated-values (CSV) file to hold the data.<br/><br/>Export to CSV allows selection of which Checklist fields to include in the export. At least one field must be selected. The order of columns in the CSV file is based on the default for a full export and cannot be modified.<br/><br/>Checklist .csv exports truncate element contents at 32,700 characters; just shy of the maximum characters per cell value defined by Microsoft Excel.<br/><br/>Option >> Preferences<br/>- Opens the STIG Viewer \"Preferences\" menu.<br/><br/><br/><b>2020: Totals Panel</b><br/><br/>The \"Totals\" panel provides an easy way to visualize the current status of a system in regards to its compliance to a STIG. There are four tabs in the Totals panel that allow the user to receive quick summaries on system compliance based on rule severity. For each severity category, the status totals of each applicable result are listed. The center Vul list is updated based on the tab selected.<br/><br/>The Statuses are:<br/><br/>Open<br/>- The rule has been observed as non-compliant on the target system.<br/><br/>Not Reviewed<br/>- The rule has not been tested.<br/><br/>Not a Finding<br/>- The rule has been observed as compliant on the target system.<br/><br/>Not Applicable<br/>- The rule was determined to not apply due to the nature of the requirement with consideration to the target system.<br/><br/>Each status has its own color that is used by the pie chart and the center Vul table. The color will update based on any change made to the checklist entries' statuses. The counts for each tab will update in response to overriding rule severities within the checklist.<br/><br/><br/><b>2030: Target Data Panel</b><br/><br/>The \"Target Data\" panel holds information that is used by a \"CMRS Import\" file, namely the \"Computing/Non-Computing\" selection, \"Host Name\", \"IP Address\", \"MAC Address\" and \"Fully Qualified Domain Name\" text fields. These may be automatically filled in when an XCCDF Results file is imported, but may also be changed manually or by pressing the \"Get Host Data\" button.<br/><br/>To note the role of the system, choose one of the selection bubbles: Workstation, Member Server, or Domain Controller.<br/><br/>The \"Web or Database STIG\" check box will spawn the two text fields for Site and Instance input when the \"Web or Database STIG\" check box is checked.<br/><br/><br/><b>2035: STIGs Panel</b><br/><br/>This panel holds a list of the current STIGs displayed in the checklist. The \"Checklist STIGs\" panel is almost exactly like the STIGs panel under the \"STIG Explorer\" tab. The \"Checklist STIGs\" panel, however, does not have the profile dropdown, and has an additional column, the \"Score\" column.<br/><br/>The \"Score\" column updates after each change in vulnerability check status to indicate the current \"correctness\" of a given STIG. The score is calculated as follows:<br/><br/>Open<br/>- Counts as a Failure toward the total number of vulnerabilities<br/><br/> Not a Finding:<br/>- Counts as a Pass toward the total number of vulnerabilities<br/><br/> Not Reviewed:<br/>- Counts as a Failure toward the total number of vulnerabilities<br/><br/> Not Applicable:<br/>- Does not count toward the total number of vulnerabilities<br/><br/>The score is equal to the number of \"Passing\" vulnerabilities divided by the total number of vulnerabilities that are not marked as \"Not Applicable\".<br/><br/><br/><b>2040: Technology Area Panel</b><br/><br/>The purpose of the \"Technology Area\" panel is simple. It includes a drop-down menu that allows the user to select the applicable \"Technology Area\" for the checklist.<br/><br/><br/><b>2041: Filter Panel</b><br/><br/>The Checklist tab \"Filter\" panel works just like the \"STIG Explorer\" Filter panel, discussed in section 1030: STIGs Panel.<br/><br/><br/><b>2045: Vul Table</b><br/><br/>The center Vul table fulfills the same purpose as the center Vul table in the STIG Explorer, but has two additional features. In addition to populating the panels in the right most quadrant, it has an additional status column that states the current status of the rule. The text will also change to a color corresponding to the Status and Severity of the rule.<br/><br/><br/><b>2050: Vul Display</b><br/><br/>Much like other components of the \"Checklist\" tab, the \"Vul\" display is very similar to its STIG Explorer counterpart, but with additional features. The most notable of these features is the ability to change the status and severity of individual or multiple rule(s) at the rule level.<br/><br/>To change the status of a rule the user needs only to select the \"Status\" drop-down menu and option corresponding to the status that is desired for the rule(s) selected.<br/><br/> In the \"General Information\" panel for a \"Classic 2.x\" display, the user must select the button corresponding to the desired status to change a Vul's status.<br/><br/>In addition to changing the status of highlighted vulnerabilities using a menu or button, users may also change the status with keyboard shortcuts:<br/><br/>\"r\" for \"Not Reviewed\"<br/><br/>\"o\" for \"Open\"<br/><br/>\"n\" for \"Not a Finding\"<br/><br/>\"x\" for \"Not Applicable\"<br/><br/>To change the Severity, the user must select the \"Severity Override\" choice box and choose the desired severity. This action will bring up a \"justification\" text input field that must be filled out in order to successfully override the severity of the given rule. Severity may only be changed one rule at a time.<br/><br/><br/><b>2051: Classic 2.x Display Vul Information Panel</b><br/><br/>The \"Vul Information\" panel holds a sub-window that has a number of tabs based on the fields obtained from the STIGs selected for the checklist. If a particular field is not present in a STIG, the tab will not show up.<br/><br/><br/><b>2052: Finding Details and Comments Text Areas</b><br/><br/>The \"Finding Details\" and \"Comments\" text areas provide an area for user-entered data per vulnerability.<br/><br/>Finding Details and Comments may be pasted simultaneously into multiple selected vulnerabilities. Right-click on the selected vulnerabilities, then select \"Paste Text\" and \"Paste as finding details\" or \"Paste as comments\", as appropriate.<br/><br/></td></tr><tr style='height:15px'></tr></tbody></table></div>";

    STIGViewerGUIReadMe() throws URISyntaxException, FileNotFoundException, IOException {
        this.stage.setTitle("DISA STIG Viewer : Readme");
        Group root = new Group();
        Button okBtn = new Button();
        okBtn.setText("Close");
        okBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                STIGViewerGUIReadMe.this.closeReadMe();
            }
        });
        WebView WebTextArea = new WebView();
        WebTextArea.setStyle("-fx-font-family: Segoe UI; -fx-font-size: 14; -fx-font-weight: normal");
        FilteredEventDispatcher.register((Node)WebTextArea);
        WebTextArea.getEngine().loadContent("<div id='read-me-content-container' style='font-family:segoe ui;'><h2 style='text-align:center'>STIG Viewer README File</h2><table style='width:90%;margin:0 auto;'><tbody><tr><th style='border-bottom:1px solid #bbb'>End User License Agreement</th></tr><tr><td>The \"DISA STIG Viewer\" Tool is a free program provided <b>\"AS IS\"</b>. This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. By using the DISA STIG Viewer, you agree to the terms listed above.</td></tr><tr style='height:15px'></tr><tr><th style='border-bottom:1px solid #bbb'>Important Notes</th></tr><tr><td>STIG Compatibility: The STIG Viewer is currently compatible only with DISA STIGs that have been converted into XCCDF 1.1 and 1.2 XML formats.  STIG documents not in this format will likely not work well with the STIG Viewer.<br/><br/>STIG Viewer is currently compiled with Java 8.<br/><br/>The STIGs List under the \"Checklist\" tab computes its scores considering a static weight of \"10\" for all rules. Many STIGs provided by DISA currently have each rule's weight set to a static value of \"10\". In the future, the score will consider the individual weight value of each rule.<br/><br/></td></tr><tr><th style='border-bottom:1px solid #bbb'>Known Bugs</th></tr><tr><td>The STIG Viewer currently has limited compatibility with UNIX/Linux systems. In order to run STIG Viewer on a Linux system, the user must install Oracle's JRE or JDK. Depending on the Linux distribution, some features may work better than others.<br/> - On Red Hat Enterprise Linux, the Checklist \"Get Target Data\" button does not function.<br/> - STIG Viewer is currently not supported on Solaris.</td></tr><tr style='height:20px'></tr><tr><th style='text-align:left;border-bottom:1px solid #bbb'>Table of Contents</th></tr><tr><td><b>1000 - STIG Explorer Tab Program Functions</b><br/>1010 - Local Data Cache<br/>1020 - Importing a STIG<br/>1025 - Exporting a STIG<br/>1030 - STIGs Panel<br/>1040 - Filter Panel<br/>1050 - Vul Table<br/><br/><b>1500 \u2013 Preferences Menu Functions</b><br/>1510 \u2013 Preferences General Tab<br/>1520 \u2013 Preferences Checklist Tab<br/><br/><b>2000 - Checklist Tab Functions</b><br/>2010 - Opening a Checklist<br/>2015 - Checklist Menu Options<br/>2020 - Totals Panel<br/>2030 - Target Data Panel<br/>2035 \u2013 STIGs Panel<br/>2040 - Technology Area Panel<br/>2041 - Filter Panel<br/>2045 - Vul Table<br/>2050 - Vul Display<br/>2051 - Classic 2.x Display Vul Information Panel<br/>2052 - Finding Details and Comments Panels/Areas<br/></td></tr><tr style='height:15px'></tr><tr><th style='border-bottom:1px solid #bbb'>1000: STIG Explorer Program Functions </th></tr><tr><td><b>1010: Local Data Cache</b><br/><br/>STIG Viewer creates and maintains a Local Data Cache responsible for storing imported STIGs and program configurations. The Local Data Cache is created upon initialization of the program and may be deleted at any time. Upon deletion, the Local Data Cache is recreated, saving further changes, before next close.<br/><br/> If the Local Data Cache cannot be created, a warning message will be presented to the user detailing that STIG Viewer is unable to save state between opening and closing.<br/><br/> In order to fully delete the Local Data Cache, go to:<br/>Options >> Delete Local Data Cache<br/><br/><br/><b>1020: Importing a STIG</b><br/><br/>File menu:<br/>File >> Import STIG<br/><br/>STIGs may be imported as a STIG XML File (.xml) file or as a STIG ZIP File (.zip) bundle. STIG Viewer fully supports importing DISA STIGs that use SCAP 1.1 or SCAP 1.2. Other STIGs may be imported with varying success.<br/><br/><br/><b>1025: Exporting a STIG</b><br/><br/>STIG Viewer is able to export the selected STIG(s) in three different formats: webpage (.html), rich text document (.rtf), or comma separated values file (.csv).<br/><br/>File menu:<br/>Export >> Webpage(.html)<br/><br/>File menu:<br/>Export >> Document(.rtf)<br/><br/>File menu:<br/>Export >> Spreadsheet(.csv)<br/><br/>Export to CSV allows selection of which STIG fields to include in the export. At least one field must be selected. The order of columns in the CSV file is based on the default for a full export and cannot be modified.<br/><br/>STIG Spreadsheet (.csv) exports truncate element contents at 32,700 characters; just shy of the maximum characters per cell value defined by Microsoft Excel.<br/><br/><br/><b>1030: STIGs Panel</b><br/><br/>The STIGs panel is responsible for selecting STIGs to be viewed by the STIG Viewer, as well as maintaining the STIGs held in the Local Data Cache. The visible columns of the STIGs list may be altered by selecting the plus sign in the upper right corner of the table and then selecting and deselecting the options shown.<br/><br/>There are two main forms of selection associated with the STIGs panel: highlighting and check marking. A highlighted selection is used for deletion purposes. A check-marked STIG is automatically sent to be displayed along with the other checked STIGs. Additionally, check-marked STIGs are used when a checklist is created or an export option is chosen.<br/><br/>- Left-clicking without holding down the \"ctrl\" or \"shift\" keys both checks (or unchecks) and highlights the given selection.<br/><br/>- Left-clicking while the \"ctrl\" or \"shift\" key is pressed highlights (or de-highlights) STIGs only.<br/><br/>- Right-clicking the STIGs list will highlight the given selection and open up a menu with the options to \"Check All\", \"Uncheck All\", and \"Remove Highlighted STIG(s)\".<br/><br/>- The \"Remove Highlighted STIG(s)\" option will delete any STIGs that are highlighted, regardless of their \"check-mark\" status.<br/><br/>Below the STIG list lies the profile selection drop-down menu. Selecting a profile will alter what vulnerabilities are sent to the Vul table by the checked STIGs based on the profile selected. The displayed profiles in the profile list correspond to the profiles listed in the selected STIGs.<br/><br/><br/><b>1040: Filter Panel</b><br/><br/>STIGs in STIG Viewer are searchable by way of a filtered search list. This list is maintained on the left side of the screen, beneath the STIGs panel.<br/><br/>The Filters applied in STIG Viewer will affect the current visible vulnerabilities that are displayed in the center Vul table. Successive additions to the table (check marking another STIG) will also be filtered based on the current list of filters. Chosen filter words will be highlighted in the display panels corresponding to the filter type.<br/><br/>The various filters currently do not affect what selections are sent to the Export functions, or checklist creation.<br/><br/>- Adding a filter:<br/>Select a filter from the drop down menu, input a keyword if necessary, select whether the filter will include or  exclude the selection, and press the \"Add\" button.<br/><br/>- Removing a filter:<br/>Highlight the desired filter in the list of current applied filters. Multiple filters in this list can be highlighted by \"Shift\" and/or \"Ctrl\" clicking entries. Press the \"Remove Filter(s)\" button to remove those filters selected or press the \"Remove All Filters\" button to remove all current filters.<br/><br/>- Combining filters:<br/>By default, all filter selections are applied simultaneously. Clicking \"Any\" changes the filter so that a Vulnerability matching any single filter will be included in the results.<br/><br/>Following are the various types of filters and their corresponding elements searched:<br/><br/>Keyword<br/>- Searches most text fields in all Vuls currently displayed, does not check the \"Severity\" attribute<br/><br/>Rule Title<br/>- Searches the \"Rule Title\" text of all Vuls currently displayed<br/><br/>STIG ID<br/>- Searches the STIG ID of all Vuls currently displayed<br/><br/>Vulnerability ID<br/>- Searches the Vul ID of all Vuls currently displayed<br/><br/>Rule ID<br/>- Searches the Rule ID of all Vuls currently displayed<br/><br/>IA Control<br/>- Searches the IA Control value(s) of all Vuls currently displayed<br/><br/>CAT I<br/>- Shows or hides currently displayed Vuls that are considered CAT Is<br/><br/>CAT II<br/>- Shows or hides currently displayed Vuls that are considered CAT IIs<br/><br/>CAT III<br/>- Shows or hides currently displayed Vuls that are considered CAT IIIs<br/><br/>CCI<br/>- Searches CCI number, description, and reference of currently displayed Vuls<br/><br/><br/><b>1050: Vul Table</b><br/><br/>To view a particular entry in the Vul table, select an entry in the center table.<br/><br/>The selected vulnerability will populate the right side of the screen, which consists of two resizable areas that hold the STIG Title/ID information and the rest of the STIG information, respectively. If one of the \"Classic 2.x\" themes is selected, the right panel will hold the \"General Information\", \"Discussion\", \"Fix Text\", \"Check Content\", \"CCI\", and \"Miscellaneous\" panels instead of the resizable areas. If a STIG does not have information for a particular entry in any display theme, the entry will not be displayed.<br/><br/>Like the \"STIGs\" panel, the Vul Table's visible columns can be altered by selecting the various options brought up by clicking the plus sign in the top right corner of the table.<br/><br/>The available selections in the Vul table are affected by what is checked in the \"STIGs\" panel, and by what filters are applied by the \"Filter\" panel.<br/><br/><br/></td></tr><tr style='height:15px'></tr><tr><th style='border-bottom:1px solid #bbb'>1500: Preferences Menu Functions</th></tr><td><b>1510: Preferences General Tab </b><br/><br/>Font Size<br/>- To change the font size of STIG Viewer's display windows, input a number and press \"Enter\". In the case of non-number input, the selection defaults to \"14\".<br/><br/>Font<br/>- To change the style of STIG Viewer's display windows, choose a font from the drop-down menu.<br/><br/>Visual Style<br/>- To change the overall appearance of STIG Viewer, select one of the options from the drop-down menu.<br/><br/>Output Logging to File<br/>- When the \"Output Logging to File\" box is checked, STIG Viewer will output a file in the same directory as the .jar file called the \"ActionLog\". This file holds a list of actions taken by the user to aid in a debugging scenario. When this option is not checked, STIG Viewer does not log its events, nor does it create the \"ActionLog\" file.<br/><br/><br/><b>1520: Checklist General Tab </b><br/><br/>Color Selectors<br/>- The \"Checklist\" tab in the \"Preferences\" menu has five color selection menus that correspond to each possible status of a vulnerability. Changing the colors in the given selectors will change the color that is displayed by the center table when a status is given to a specific vulnerability. The chosen colors are also reflected in the pie chart. The pie chart \"Open\" color reflects the color chosen for \"CAT I\" statuses.<br/><br/>File Settings<br/>- The \"Validate Checklist\" box determines whether a \"CKL\" file will be validated against a Checklist schema upon import. If the \"CKL\" file is invalid, an error will be displayed. STIG Viewer does not provide assistance in debugging user-modified \"CKL\" files.<br/><br/><br/></td></tr><tr style='height:15px'></tr><tr><th style='border-bottom:1px solid #bbb'>2000: Checklist tab </th></tr><tr><td><b>2010: Opening a Checklist</b><br/><br/>There are a few options for opening a new checklist. All are listed under the \"Checklist\" menu option given in the STIG Explorer. All options, when selected, will open up and switch windows to the \"Checklist\" tab.<br/><br/>Checklist >> Open Checklist from File<br/>- This option will open a checklist from file. Checklists from STIG Viewer 2.x and 1.x versions should be able to be opened by STIG Viewer 2.5 and on, however, checklists from version 2.5 and on will not be able to be opened by previous versions of STIG Viewer.<br/><br/>Checklist >> Create Checklist - Check Marked STIG(s)<br/>- A new checklist will be created that consists of vulnerabilities from the STIGs that are currently checked in the \"STIGs\" panel.<br/><br/><br/><b>2012: Checklist Keyboard Shortcuts</b><br/><br/>There are four main keyboard shortcuts supported by a Checklist tab other than those used to change vulnerability status (listed under section 2050: \"Vul Display\"). Select the Checklist window once a checklist has been created in order to use the shortcuts. To select the window, either tap the \"Tab\" key, or click anywhere on the checklist. All four keyboard shortcuts are control key based, in other words, press the  \"Ctrl\" key followed by the key after the plus sign.<br/><br/>Ctrl + 1<br/>Switch to the center table, use arrow keys to switch between entries and use shortcuts listed under section 2050: \"Vul Display\" to change their statuses.<br/><br/>Ctrl + 2<br/>Select the \"Status\" dropdown menu in the Rule Display. If a \"Classic\" theme is selected, instead switch to the \"Vul Information\" window. Use arrow keys to change tabs.<br/><br/>Ctrl + 3<br/>Switch to the \"Finding Details\" text area.<br/><br/>Ctrl + 4<br/>Switch to the \"Comments\" text area.<br/><br/><br/><b>2015: Checklist Menu Options</b><br/><br/>The \"Checklist\" tab has four main menu items: \"File\", \"Import\", \"Export\", and \"Options\". The options under \"File\" deal with saving the current checklist. The \"Import\" item deals with importing \"XCCDF\" results and saved \"checklist\" files to the current checklist. \"Export\" provides options for exporting a checklist to a different format. \"Options\" provides access to the STIG Viewer \"Preferences\" menu.<br/><br/>File >> Save Checklist<br/>- If the checklist already represents a checklist file saved to the system, this option will save the current checklist to that file. Otherwise, the option will open a \"Save as\" menu that allows the user to save the checklist to a checklist file on the system.<br/><br/>File >> Save Checklist As<br/>- \"Save Checklist As\" allows the user to save the current checklist to a file of his or her choosing on the system that is running STIG viewer. The checklist file may be opened at a later time or on a different instance of STIG Viewer using the \"Open Checklist from File\" option on the \"STIG Explorer\" tab.<br/><br/>Import >> XCCDF Results File<br/>- Import and apply an XCCDF Results file to the STIGs that were used to create the checklist. XCCDF Results will be mapped to their corresponding STIG rules. If any XCCDF Results are imported that do not have a matching rule in the Checklist, a window will pop-up and display the offending rule ID's from the Results file. Supported XCCDF Result formats: HBSS ePO/PAA, OVALdi (ACAS), and SPAWAR SCC.<br/><br/>Import >> Checklist Data<br/>- Import data from a saved checklist file into the current checklist. Generally this feature will be used to import data from a checklist that uses an older version of a STIG into a checklist that was created with the new version of the STIG.<br/><br/>Export >> Gen. CMRS Import File<br/>- Takes the information that has been inputted into the checklist and creates a \"CMRS import\" file.<br/><br/>Export >> Data Export (.csv)<br/>- Takes the information that has been inputted into the checklist and creates a comma-separated-values (CSV) file to hold the data.<br/><br/>Export to CSV allows selection of which Checklist fields to include in the export. At least one field must be selected. The order of columns in the CSV file is based on the default for a full export and cannot be modified.<br/><br/>Checklist .csv exports truncate element contents at 32,700 characters; just shy of the maximum characters per cell value defined by Microsoft Excel.<br/><br/>Option >> Preferences<br/>- Opens the STIG Viewer \"Preferences\" menu.<br/><br/><br/><b>2020: Totals Panel</b><br/><br/>The \"Totals\" panel provides an easy way to visualize the current status of a system in regards to its compliance to a STIG. There are four tabs in the Totals panel that allow the user to receive quick summaries on system compliance based on rule severity. For each severity category, the status totals of each applicable result are listed. The center Vul list is updated based on the tab selected.<br/><br/>The Statuses are:<br/><br/>Open<br/>- The rule has been observed as non-compliant on the target system.<br/><br/>Not Reviewed<br/>- The rule has not been tested.<br/><br/>Not a Finding<br/>- The rule has been observed as compliant on the target system.<br/><br/>Not Applicable<br/>- The rule was determined to not apply due to the nature of the requirement with consideration to the target system.<br/><br/>Each status has its own color that is used by the pie chart and the center Vul table. The color will update based on any change made to the checklist entries' statuses. The counts for each tab will update in response to overriding rule severities within the checklist.<br/><br/><br/><b>2030: Target Data Panel</b><br/><br/>The \"Target Data\" panel holds information that is used by a \"CMRS Import\" file, namely the \"Computing/Non-Computing\" selection, \"Host Name\", \"IP Address\", \"MAC Address\" and \"Fully Qualified Domain Name\" text fields. These may be automatically filled in when an XCCDF Results file is imported, but may also be changed manually or by pressing the \"Get Host Data\" button.<br/><br/>To note the role of the system, choose one of the selection bubbles: Workstation, Member Server, or Domain Controller.<br/><br/>The \"Web or Database STIG\" check box will spawn the two text fields for Site and Instance input when the \"Web or Database STIG\" check box is checked.<br/><br/><br/><b>2035: STIGs Panel</b><br/><br/>This panel holds a list of the current STIGs displayed in the checklist. The \"Checklist STIGs\" panel is almost exactly like the STIGs panel under the \"STIG Explorer\" tab. The \"Checklist STIGs\" panel, however, does not have the profile dropdown, and has an additional column, the \"Score\" column.<br/><br/>The \"Score\" column updates after each change in vulnerability check status to indicate the current \"correctness\" of a given STIG. The score is calculated as follows:<br/><br/>Open<br/>- Counts as a Failure toward the total number of vulnerabilities<br/><br/> Not a Finding:<br/>- Counts as a Pass toward the total number of vulnerabilities<br/><br/> Not Reviewed:<br/>- Counts as a Failure toward the total number of vulnerabilities<br/><br/> Not Applicable:<br/>- Does not count toward the total number of vulnerabilities<br/><br/>The score is equal to the number of \"Passing\" vulnerabilities divided by the total number of vulnerabilities that are not marked as \"Not Applicable\".<br/><br/><br/><b>2040: Technology Area Panel</b><br/><br/>The purpose of the \"Technology Area\" panel is simple. It includes a drop-down menu that allows the user to select the applicable \"Technology Area\" for the checklist.<br/><br/><br/><b>2041: Filter Panel</b><br/><br/>The Checklist tab \"Filter\" panel works just like the \"STIG Explorer\" Filter panel, discussed in section 1030: STIGs Panel.<br/><br/><br/><b>2045: Vul Table</b><br/><br/>The center Vul table fulfills the same purpose as the center Vul table in the STIG Explorer, but has two additional features. In addition to populating the panels in the right most quadrant, it has an additional status column that states the current status of the rule. The text will also change to a color corresponding to the Status and Severity of the rule.<br/><br/><br/><b>2050: Vul Display</b><br/><br/>Much like other components of the \"Checklist\" tab, the \"Vul\" display is very similar to its STIG Explorer counterpart, but with additional features. The most notable of these features is the ability to change the status and severity of individual or multiple rule(s) at the rule level.<br/><br/>To change the status of a rule the user needs only to select the \"Status\" drop-down menu and option corresponding to the status that is desired for the rule(s) selected.<br/><br/> In the \"General Information\" panel for a \"Classic 2.x\" display, the user must select the button corresponding to the desired status to change a Vul's status.<br/><br/>In addition to changing the status of highlighted vulnerabilities using a menu or button, users may also change the status with keyboard shortcuts:<br/><br/>\"r\" for \"Not Reviewed\"<br/><br/>\"o\" for \"Open\"<br/><br/>\"n\" for \"Not a Finding\"<br/><br/>\"x\" for \"Not Applicable\"<br/><br/>To change the Severity, the user must select the \"Severity Override\" choice box and choose the desired severity. This action will bring up a \"justification\" text input field that must be filled out in order to successfully override the severity of the given rule. Severity may only be changed one rule at a time.<br/><br/><br/><b>2051: Classic 2.x Display Vul Information Panel</b><br/><br/>The \"Vul Information\" panel holds a sub-window that has a number of tabs based on the fields obtained from the STIGs selected for the checklist. If a particular field is not present in a STIG, the tab will not show up.<br/><br/><br/><b>2052: Finding Details and Comments Text Areas</b><br/><br/>The \"Finding Details\" and \"Comments\" text areas provide an area for user-entered data per vulnerability.<br/><br/>Finding Details and Comments may be pasted simultaneously into multiple selected vulnerabilities. Right-click on the selected vulnerabilities, then select \"Paste Text\" and \"Paste as finding details\" or \"Paste as comments\", as appropriate.<br/><br/></td></tr><tr style='height:15px'></tr></tbody></table></div>");
        VBox vbox = new VBox(15.0);
        vbox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        vbox.getChildren().addAll((Object[])new Node[]{WebTextArea});
        root.getChildren().add((Object)WebTextArea);
        this.stage.setScene(new Scene((Parent)root));
        this.stage.sizeToScene();
        this.stage.show();
    }

    private void closeReadMe() {
        this.stage.close();
    }
}

