/*
 * Decompiled with CFR 0.152.
 */
package Program_Tabs.Tab_STIG;

import File_Operations.File_Objects.STIG;
import File_Operations.File_Objects.Vuln;
import File_Operations.File_Readers.XCCDF_Read;
import Program_Tabs.Tab_STIG.STIGMenuBar;
import Program_Tabs.Tab_STIG.STIGViewTab;
import Program_Tabs.interfaces.GuiDriver;
import Shared_Constructs.Filter.Concrete.ProfileFilter;
import Shared_Constructs.Filter.Controllers.FilterSetup;
import Shared_Constructs.Filter.Parents.FilterEvent;
import Utility_Code.CustomExceptions.NotSTIGException;
import Utility_Code.GlobalSettings.Util;
import Utility_Code.Static_Methods.ErrorHandlers;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javafx.scene.control.MenuBar;
import javafx.scene.control.Tab;
import javafx.scene.layout.Pane;
import stigviewer.STIGViewer;
import stigviewer.SavePoint;
import stigviewer.TabDriver;

public final class STIGDriver
extends TabDriver
implements GuiDriver {
    private static STIGMenuBar MenuController;
    private static STIGViewTab STIGTabView;
    private static STIGViewer STIGViewer;
    private Pane myPane;
    private ArrayList<STIG> mySTIGs;
    private ArrayList<STIG> SelectedSTIGs;
    private ArrayList<Vuln> CurrentVisibleVulnsList;
    private ArrayList<Vuln> CurrentMasterVulnsList;
    private ArrayList<String> notImportedFiles;
    private static SavePoint mySP;
    XCCDF_Read XCCDF_Reader = XCCDF_Read.getXCCDFReader();
    List<FilterEvent> Filters;
    ArrayList<ArrayList<String>> FilterOrder;
    GuiDriver.FilterMode filterMode;

    public STIGDriver(STIGViewer sv) throws FileNotFoundException {
        this.mySTIGs = new ArrayList();
        this.CurrentVisibleVulnsList = new ArrayList();
        this.CurrentMasterVulnsList = new ArrayList();
        this.CurrentSelectedVuln = new Vuln();
        FilterSetup setFils = new FilterSetup();
        this.Filters = setFils.getFilters();
        this.filterMode = GuiDriver.FilterMode.ALL;
        STIGViewer = sv;
        MenuController = new STIGMenuBar(STIGViewer, this);
        this.myPane = null;
        Logger.getLogger(STIGDriver.class.getName()).log(Level.INFO, "INFO: SB: STIG Explorer Tab backend setup");
    }

    public void loadSTIGsFromCache() {
        File[] STIGsToImport;
        mySP = STIGViewer.getSavePoint();
        File fSTIGFolder = mySP.GetSTIGFolder();
        if (fSTIGFolder.exists() && fSTIGFolder.isDirectory() && (STIGsToImport = fSTIGFolder.listFiles()).length > 0) {
            this.notImportedFiles = new ArrayList();
            for (File STIGsToImport1 : STIGsToImport) {
                try {
                    this.LoadSTIGFromXML(STIGsToImport1);
                }
                catch (NotSTIGException e) {
                    Logger.getLogger(STIGDriver.class.getName()).log(Level.WARNING, "WARNING: SB: Exception occured while handling XCCDF XML import");
                }
            }
            if (!this.notImportedFiles.isEmpty()) {
                ErrorHandlers.importError(STIGViewer.getPrimaryStage().getScene().getWindow(), this.notImportedFiles);
            }
        }
    }

    @Override
    public MenuBar getMenuBar() {
        return MenuController.getMenuBar();
    }

    public STIGMenuBar getMenuController() {
        return MenuController;
    }

    @Override
    public Tab getTab() {
        return STIGTabView.getTab();
    }

    @Override
    public void setMainPane(Pane pane) {
        this.myPane = pane;
    }

    @Override
    public Pane getMainPane() {
        return this.myPane;
    }

    public void LoadSTIGFromXML(File XMLSTIGFile) throws NotSTIGException {
        STIG s = new STIG();
        this.XCCDF_Reader.openBenchmarkFile(XMLSTIGFile);
        s = this.XCCDF_Reader.getImportStig();
        if (s.getSTIG_Title().equals("") || s.getVulnList().size() < 1) {
            Logger.getLogger(STIGDriver.class.getName()).log(Level.INFO, "INFO: SB: Selected .xml file not applicable");
            this.notImportedFiles.add(XMLSTIGFile.getName());
            throw new NotSTIGException("No Title Information or Vulnerabilites Found in the Selected File");
        }
        try {
            FileInputStream FIS = new FileInputStream(XMLSTIGFile);
            if (STIGViewer.getSavePoint().HasConfigFolder()) {
                STIGViewer.getSavePoint().WriteSTIGToSave(FIS, XMLSTIGFile.getName());
            }
            FIS.close();
        }
        catch (Exception e) {
            Logger.getLogger(STIGDriver.class.getName()).log(Level.WARNING, "WARNING: SB: Exception occured while handling XCCDF XML import");
        }
        try {
            String sClass = XMLSTIGFile.getName().contains("FOUO") ? "FOUO" : (XMLSTIGFile.getName().indexOf("U_") == 0 ? "Unclass" : "FOUO");
            s.setClass(sClass);
            this.mySTIGs.add(s);
            STIGTabView.updateSTIGTabGUI();
        }
        catch (Exception e) {
            Logger.getLogger(STIGDriver.class.getName()).log(Level.WARNING, "WARNING: SB: Exception occured during STIG Import procedure, STIG not added to list");
        }
    }

    public void LoadSTIGs(List<File> FilesList) {
        this.notImportedFiles = new ArrayList();
        ArrayList<File> xmlFiles = new ArrayList<File>();
        boolean overwriteAll = false;
        for (File cf : FilesList) {
            if (cf.getPath().endsWith(".xml")) {
                xmlFiles.add(cf);
                continue;
            }
            if (!cf.getPath().endsWith(".zip")) continue;
            for (File xf : this.extractXML(cf)) {
                xmlFiles.add(xf);
            }
        }
        for (File cf : xmlFiles) {
            for (STIG s : (ArrayList)this.mySTIGs.clone()) {
                if (!s.getSTIG_FileName().equals(cf.getName())) continue;
                int overwrite = 2;
                if (!overwriteAll && (overwrite = ErrorHandlers.STIGOverwrite(cf.getName())) == 0) {
                    overwriteAll = true;
                }
                if (overwrite != 1 && !overwriteAll) break;
                ArrayList<STIG> remS = new ArrayList<STIG>();
                remS.add(s);
                this.RemoveSTIGs(remS);
            }
            try {
                this.LoadSTIGFromXML(cf);
            }
            catch (NotSTIGException e) {
                Logger.getLogger(STIGDriver.class.getName()).log(Level.WARNING, "WARNING: SB: Exception occured during STIG Import procedure, STIG not added to list");
            }
        }
        if (!this.notImportedFiles.isEmpty()) {
            ErrorHandlers.importError(STIGTabView.getPrimaryStage().getScene().getWindow(), this.notImportedFiles);
        }
        Util.RecursiveDelete(STIGViewer.getSavePoint().getTempFolder());
    }

    private List<File> extractXML(File zFile) {
        ArrayList<File> extXML = new ArrayList<File>();
        ZipFile zf = null;
        try {
            zf = new ZipFile(zFile);
        }
        catch (IOException ex) {
            Logger.getLogger(STIGDriver.class.getName()).log(Level.SEVERE, "SEVERE: SB: IO Exception occured during ZIP unpack");
        }
        Enumeration<? extends ZipEntry> zeE = zf.entries();
        while (zeE.hasMoreElements()) {
            File zeF;
            ZipEntry ze = zeE.nextElement();
            if (ze.getName().endsWith(".zip")) {
                zeF = this.extract(zf, ze);
                zeF.deleteOnExit();
                extXML.addAll(this.extractXML(zeF));
                continue;
            }
            if (!ze.getName().endsWith(".xml")) continue;
            zeF = this.extract(zf, ze);
            extXML.add(zeF);
            zeF.deleteOnExit();
        }
        return extXML;
    }

    private File extract(ZipFile zf, ZipEntry ze) {
        File zeF = null;
        try {
            String[] sp = ze.getName().split("[\\\\\\/]");
            String tPath = STIGViewer.getSavePoint().getTempFolder() + Util.GetSlash() + sp[sp.length - 1];
            if (!STIGViewer.getSavePoint().getTempFolder().exists()) {
                STIGViewer.getSavePoint().getTempFolder().mkdir();
            }
            zeF = new File(tPath);
            Files.copy(zf.getInputStream(ze), zeF.toPath(), new CopyOption[0]);
        }
        catch (IOException ex) {
            Logger.getLogger(STIGDriver.class.getName()).log(Level.SEVERE, "SEVERE: SB: IO Exception occured during ZIP unpack");
        }
        return zeF;
    }

    public void RemoveSTIGs(ArrayList<STIG> STIGs) {
        try {
            block4: for (STIG rs : STIGs) {
                for (STIG s : this.mySTIGs) {
                    if (!s.getSTIG_UUID().equals(rs.getSTIG_UUID())) continue;
                    this.mySTIGs.remove(s);
                    File stigFolder = STIGViewer.getSavePoint().GetSTIGFolder();
                    if (!stigFolder.exists()) continue block4;
                    for (File entry : stigFolder.listFiles()) {
                        try {
                            if (!entry.getName().equals(s.getSTIG_FileName())) continue;
                            entry.delete();
                        }
                        catch (Exception e) {
                            Logger.getLogger(STIGDriver.class.getName()).log(Level.WARNING, "WARNING: SB: Failed to remove files in data cache");
                        }
                    }
                    continue block4;
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(STIGViewer.class.getName()).log(Level.SEVERE, "SEVERE: SB: Failed to remove selected STIGs");
        }
    }

    public void UpdateCurrentSTIGList(ArrayList<STIG> STIGList) {
        ArrayList<Vuln> TempVList = new ArrayList<Vuln>();
        ArrayList<Vuln> TempList = new ArrayList<Vuln>();
        for (STIG s : STIGList) {
            TempVList.addAll(s.getVulnList());
        }
        for (STIG s : STIGList) {
            TempList.addAll(s.getVulnList());
        }
        this.SelectedSTIGs = (ArrayList)STIGList.clone();
        this.CurrentVisibleVulnsList = TempVList;
        this.CurrentMasterVulnsList = TempList;
        this.filterRun();
    }

    public ArrayList<STIG> getSTIGs() {
        return this.mySTIGs;
    }

    @Override
    public ArrayList<Vuln> getMasterVulnList() {
        return this.CurrentMasterVulnsList;
    }

    public String getMasterClassification() {
        String classification = "Unclass";
        for (Vuln v : this.getMasterVulnList()) {
            if (!v.getAttr(Vuln.VulnAttr.Class).equals("FOUO")) continue;
            classification = "FOUO";
        }
        if (classification.equals("FOUO")) {
            return "UNCLASSIFIED//FOR OFFICIAL USE ONLY";
        }
        return "UNCLASSIFIED";
    }

    @Override
    public ArrayList<Vuln> getVisibleVulnList() {
        return this.CurrentVisibleVulnsList;
    }

    @Override
    public void setVisibleVulnList(ArrayList<Vuln> newList) {
        if (newList != null) {
            this.CurrentVisibleVulnsList = (ArrayList)newList.clone();
        }
    }

    @Override
    public List<FilterEvent> getFilters() {
        return this.Filters;
    }

    @Override
    public void filterRun() {
        if (this.filterMode == GuiDriver.FilterMode.ALL) {
            this.Filters.get(0).updateFilter(this.getMasterVulnList());
            this.setVisibleVulnList(this.Filters.get(0).reFilter());
            for (int i = 1; i < this.Filters.size(); ++i) {
                this.Filters.get(i).updateFilter(this.getVisibleVulnList());
                this.setVisibleVulnList(this.Filters.get(i).reFilter());
            }
        } else if (this.filterMode == GuiDriver.FilterMode.ANY) {
            HashSet<Vuln> filteredSet = new HashSet<Vuln>();
            boolean anyActive = false;
            FilterEvent profileFilter = null;
            for (int i = 0; i < this.Filters.size(); ++i) {
                FilterEvent filter = this.Filters.get(i);
                if (!filter.isActive()) continue;
                if (filter instanceof ProfileFilter) {
                    profileFilter = filter;
                    continue;
                }
                anyActive = true;
                filter.updateFilter((ArrayList)this.getMasterVulnList().clone());
                ArrayList<Vuln> filterResult = filter.reFilter();
                filteredSet.addAll(filterResult);
            }
            ArrayList<Vuln> filteredList = new ArrayList<Vuln>(filteredSet);
            if (!anyActive) {
                filteredList = (ArrayList<Vuln>)this.getMasterVulnList().clone();
            }
            if (profileFilter != null) {
                profileFilter.updateFilter(filteredList);
                filteredList = profileFilter.reFilter();
            }
            this.setVisibleVulnList(filteredList);
        }
    }

    public Vuln getVulnbyRuleID(String rule_ID, String stig_Ref) {
        int i;
        Vuln returnVuln = null;
        ArrayList<Vuln> tempList = new ArrayList<Vuln>();
        for (i = 0; i < this.mySTIGs.size(); ++i) {
            tempList.addAll(this.mySTIGs.get(i).getVulnList());
        }
        for (i = 0; i < tempList.size(); ++i) {
            if (!((Vuln)tempList.get(i)).getAttr(Vuln.VulnAttr.Rule_ID).equals(rule_ID) || !((Vuln)tempList.get(i)).getAttr(Vuln.VulnAttr.STIGRef).equals(stig_Ref)) continue;
            returnVuln = (Vuln)tempList.get(i);
            break;
        }
        return returnVuln;
    }

    public ArrayList<STIG> getCurrentSTIGs() {
        return this.SelectedSTIGs;
    }

    @Override
    public void updateGUIOnTabSwitch() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateGraphics() {
        STIGViewTab j = STIGTabView;
        j.graphicsUpdateRecursive();
    }

    public void setSTIGViewTab(STIGViewTab svt) {
        STIGTabView = svt;
    }

    @Override
    public void setFilterMode(GuiDriver.FilterMode mode) {
        this.filterMode = mode;
        for (FilterEvent filter : this.Filters) {
            filter.setFilterMode(mode);
        }
    }

    @Override
    public GuiDriver.FilterMode getFilterMode() {
        return this.filterMode;
    }

    @Override
    public String getName() {
        return "STIG Explorer";
    }

    @Override
    public boolean isChanged() {
        return false;
    }
}

