/*
 * Decompiled with CFR 0.152.
 */
package Program_Tabs.Tab_Checklist;

import File_Operations.File_Objects.Checklist;
import File_Operations.File_Objects.SCAPRes.SCAPResults;
import File_Operations.File_Objects.STIG;
import File_Operations.File_Objects.Vuln;
import File_Operations.File_Readers.DetermineDocType_Ckl;
import File_Operations.File_Readers.SCAPResults_Read;
import File_Operations.File_Writers.Checklist_Writer_2x;
import Program_Tabs.Tab_Checklist.ChecklistMenuBar;
import Program_Tabs.Tab_Checklist.ChecklistViewTab;
import Program_Tabs.Tab_Checklist.TargetPane;
import Program_Tabs.Tab_Checklist.XccdfResHandler;
import Program_Tabs.interfaces.GuiDriver;
import Shared_Constructs.Filter.Concrete.ProfileFilter;
import Shared_Constructs.Filter.Controllers.FilterSetup;
import Shared_Constructs.Filter.Parents.FilterEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.control.MenuBar;
import javafx.scene.control.Tab;
import javafx.scene.layout.Pane;
import stigviewer.STIGViewer;
import stigviewer.TabDriver;

public class ChecklistDriver
extends TabDriver
implements GuiDriver {
    private final ChecklistMenuBar MenuBarDriver;
    private ChecklistViewTab CklViewTab;
    private ArrayList<Vuln> ChecklistItems;
    private ArrayList<STIG> SelectedSTIGs;
    private Vuln CurrentVuln;
    private ArrayList<Vuln> CurrentVulns;
    private File CurrentFilePath;
    private String CklName;
    private Checklist Checklist;
    private ArrayList<Vuln> CurrentVisibleVulnsList;
    private ArrayList<Vuln> CurrentMasterVulnsList;
    private ArrayList<Vuln> CurrentMasterMasterVulnsList;
    private ArrayList<Vuln> CurrentCombinedVulnList;
    private TargetPane tPane;
    private List<FilterEvent> Filters;
    private GuiDriver.FilterMode filterMode;
    private XccdfResHandler XccdfResH;

    public ChecklistDriver(STIGViewer sv, ArrayList<STIG> cs) {
        this.ChecklistDriverInit();
        this.CklName = "New Checklist";
        this.vulnListsSetup(cs);
        this.CurrentVulns = null;
        this.Checklist.setChecklistSTIGList(cs);
        if (cs.size() > 0 && cs.get(0).getVulnList().size() > 0) {
            this.Checklist.setTargetKey(cs.get(0).getVulnList().get(0).getAttr(Vuln.VulnAttr.TargetKey));
        }
        this.SelectedSTIGs = (ArrayList)cs.clone();
        this.ChecklistItems = new ArrayList();
        this.CurrentSelectedVuln = new Vuln();
        this.MenuBarDriver = new ChecklistMenuBar(this);
    }

    public ChecklistDriver(STIGViewer sv, File CurrentFile) throws Exception {
        this.ChecklistDriverInit();
        String[] nameTok = CurrentFile.getName().split("\\.ckl$");
        this.CklName = nameTok[0];
        this.LoadFromCklFile(CurrentFile);
        this.ChecklistItems = new ArrayList();
        this.ChecklistItems = this.getVisibleVulnList();
        this.MenuBarDriver = new ChecklistMenuBar(this, CurrentFile);
    }

    private void ChecklistDriverInit() {
        this.XccdfResH = new XccdfResHandler(this);
        FilterSetup cfilSetup = new FilterSetup();
        this.Filters = cfilSetup.getFilters();
        this.filterMode = GuiDriver.FilterMode.ALL;
        this.Checklist = new Checklist();
        this.CurrentVuln = null;
    }

    private void LoadFromCklFile(File CurrentFile) throws Exception {
        FilterSetup cfilSetup = new FilterSetup();
        this.Filters = cfilSetup.getFilters();
        try {
            this.Checklist = DetermineDocType_Ckl.getDetermineDoctype_Ckl().getChecklist(CurrentFile);
        }
        catch (Exception ex) {
            Logger.getLogger(ChecklistDriver.class.getName()).log(Level.SEVERE, "Error occured while importing checklist from file");
            throw ex;
        }
        this.SelectedSTIGs = (ArrayList)this.Checklist.getChecklistSTIGList().clone();
        this.vulnListsSetup(this.Checklist.getChecklistSTIGList());
    }

    public void SaveToCklFile(File CurrentFile) throws IOException {
        String sPath = CurrentFile.getPath();
        if (!sPath.endsWith(".ckl")) {
            sPath = sPath + ".ckl";
        }
        File f = new File(sPath);
        String[] nameTok = CurrentFile.getName().split("\\.ckl$");
        this.CklName = nameTok[0];
        this.setCklName(this.CklName);
        Checklist_Writer_2x.getChecklist_Writer_2x().writeChecklist(f, this.Checklist);
        this.Checklist.setChanged(false);
    }

    public void ImportXCCDFResults(File f) {
        SCAPResults sr = SCAPResults_Read.getSCAPResults_Read().readSCAPResults(f);
        this.Checklist.setHostName(sr.getHostName());
        this.Checklist.setIPAddress(sr.getIPAddress());
        this.Checklist.setMACAddress(sr.getMACAddress());
        this.Checklist.setFullyQualifiedDN(sr.getFQDN());
        this.tPane.setHostName(this.Checklist.getHostName());
        this.tPane.setIPAddress(this.Checklist.getIPAddress());
        this.tPane.setMAC(this.Checklist.getMACAddress());
        this.tPane.setFQDN(this.Checklist.getFullyQualifiedDN());
        ArrayList<String> resNotFound = this.XccdfResH.ImportXCCDF12Results(sr.getResults());
        if (!resNotFound.isEmpty()) {
            this.CklViewTab.nonMatchingResultWindow(resNotFound);
        }
        this.CklViewTab.refreshTotals();
        this.CklViewTab.updateDisplay();
    }

    public final ArrayList<Vuln> combineVulnLists(ArrayList<STIG> stigs) {
        ArrayList<Vuln> combinedVuls = new ArrayList<Vuln>();
        for (STIG stig : stigs) {
            combinedVuls.addAll((ArrayList)stig.getVulnList().clone());
        }
        return combinedVuls;
    }

    public void updateVulnItem(Vuln upVuln) {
        for (Vuln v : this.CurrentMasterMasterVulnsList) {
            if (!v.getVulnRuleID().equals(upVuln.getVulnRuleID())) continue;
            v.setCheckState(upVuln.getCheckState());
        }
        for (Vuln v : this.CurrentVisibleVulnsList) {
            if (!v.getVulnRuleID().equals(upVuln.getVulnRuleID())) continue;
            v.setCheckState(upVuln.getCheckState());
        }
        for (Vuln v : this.CurrentMasterVulnsList) {
            if (!v.getVulnRuleID().equals(upVuln.getVulnRuleID())) continue;
            v.setCheckState(upVuln.getCheckState());
        }
    }

    public ArrayList<Vuln> UpdateVisibleListBySeverity(int change) {
        ArrayList filteredList = (ArrayList)this.CurrentMasterMasterVulnsList.clone();
        for (Vuln currVuln : this.CurrentMasterMasterVulnsList) {
            if (currVuln.getCheckSevOverride().equals("")) {
                if (change == 1 && !currVuln.getAttr(Vuln.VulnAttr.Severity).equals("high")) {
                    filteredList.remove(currVuln);
                    continue;
                }
                if (change == 2 && !currVuln.getAttr(Vuln.VulnAttr.Severity).equals("medium")) {
                    filteredList.remove(currVuln);
                    continue;
                }
                if (change != 3 || currVuln.getAttr(Vuln.VulnAttr.Severity).equals("low")) continue;
                filteredList.remove(currVuln);
                continue;
            }
            if (change == 1 && !currVuln.getCheckSevOverride().equals("high")) {
                filteredList.remove(currVuln);
                continue;
            }
            if (change == 2 && !currVuln.getCheckSevOverride().equals("medium")) {
                filteredList.remove(currVuln);
                continue;
            }
            if (change != 3 || currVuln.getCheckSevOverride().equals("low")) continue;
            filteredList.remove(currVuln);
        }
        this.CurrentMasterVulnsList = (ArrayList)filteredList.clone();
        this.CurrentVisibleVulnsList = (ArrayList)filteredList.clone();
        for (FilterEvent F : this.Filters) {
            F.updateFilter(this.getVisibleVulnList());
            this.setVisibleVulnList(F.reFilter());
        }
        return (ArrayList)this.getVisibleVulnList().clone();
    }

    public void UpdateCurrentSTIGList(ArrayList<STIG> STIGList) {
        ArrayList<Vuln> TempList = new ArrayList<Vuln>();
        for (STIG s : STIGList) {
            TempList.addAll(s.getVulnList());
        }
        this.SelectedSTIGs = STIGList;
        this.CurrentMasterMasterVulnsList = (ArrayList)TempList.clone();
        this.CurrentMasterVulnsList = (ArrayList)TempList.clone();
        this.CurrentVisibleVulnsList = (ArrayList)TempList.clone();
        for (FilterEvent F : this.Filters) {
            F.updateFilter(this.getVisibleVulnList());
            this.setVisibleVulnList(F.reFilter());
        }
    }

    Vuln getChecklistItembyRuleID(String rule_ID) {
        Vuln returnVuln = null;
        for (int i = 0; i < this.ChecklistItems.size(); ++i) {
            if (!this.ChecklistItems.get(i).getAttr(Vuln.VulnAttr.Rule_ID).equals(rule_ID)) continue;
            returnVuln = this.ChecklistItems.get(i);
            this.CurrentVuln = null;
            break;
        }
        return returnVuln;
    }

    public ArrayList<Vuln> getListByCATLevel(String CATLevel) {
        ArrayList<Vuln> NewChecklistItemList = new ArrayList();
        if (CATLevel.equals("all")) {
            NewChecklistItemList = this.ChecklistItems;
        } else {
            for (Vuln Item : this.ChecklistItems) {
                if (!(Item.getAttr(Vuln.VulnAttr.Severity) == null ? CATLevel == null : Item.getAttr(Vuln.VulnAttr.Severity).equals(CATLevel))) continue;
                NewChecklistItemList.add(Item);
            }
        }
        return NewChecklistItemList;
    }

    public Map getTotalsCount(String severity) {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        ArrayList<Object> list = new ArrayList();
        if (this.getVisibleVulnList() != null) {
            list = this.getVisibleVulnList();
        }
        int overallOpenCnt = 0;
        int overallNACnt = 0;
        int overallNFCnt = 0;
        int overallNRCnt = 0;
        int catCount = 0;
        if (severity.equals("none")) {
            for (Vuln vuln : list) {
                String val;
                ++catCount;
                switch (val = vuln.getCheckState().toString()) {
                    case "NR": {
                        ++overallNRCnt;
                        break;
                    }
                    case "O": {
                        ++overallOpenCnt;
                        break;
                    }
                    case "NA": {
                        ++overallNACnt;
                        break;
                    }
                    case "NF": {
                        ++overallNFCnt;
                    }
                }
            }
        } else {
            for (Vuln vuln : list) {
                String val = vuln.getCheckState().toString();
                String over = vuln.getCheckSevOverride();
                if (vuln.getCheckSevOverride().equals("")) {
                    if (!vuln.getAttr(Vuln.VulnAttr.Severity).equals(severity)) continue;
                    ++catCount;
                    switch (val) {
                        case "NR": {
                            ++overallNRCnt;
                            break;
                        }
                        case "O": {
                            ++overallOpenCnt;
                            break;
                        }
                        case "NA": {
                            ++overallNACnt;
                            break;
                        }
                        case "NF": {
                            ++overallNFCnt;
                        }
                    }
                    continue;
                }
                if (!vuln.getCheckSevOverride().equals(severity)) continue;
                ++catCount;
                switch (val) {
                    case "NR": {
                        ++overallNRCnt;
                        break;
                    }
                    case "O": {
                        ++overallOpenCnt;
                        break;
                    }
                    case "NA": {
                        ++overallNACnt;
                        break;
                    }
                    case "NF": {
                        ++overallNFCnt;
                    }
                }
            }
        }
        m.put("Total", catCount);
        m.put("O", overallOpenCnt);
        m.put("NF", overallNFCnt);
        m.put("NA", overallNACnt);
        m.put("NR", overallNRCnt);
        return m;
    }

    public void signalUpdate() {
        this.CklViewTab.updateDisplay();
        this.tPane.updateValues();
    }

    private void vulnListsSetup(ArrayList<STIG> cs) {
        this.CurrentMasterVulnsList = this.combineVulnLists(cs);
        this.CurrentMasterMasterVulnsList = (ArrayList)this.CurrentMasterVulnsList.clone();
        this.CurrentVisibleVulnsList = (ArrayList)this.CurrentMasterVulnsList.clone();
        this.CurrentCombinedVulnList = (ArrayList)this.CurrentMasterVulnsList.clone();
    }

    public void fireImport() {
        this.MenuBarDriver.triggerImport();
    }

    public ArrayList<Vuln> getCurrentCombinedVulnList() {
        return this.CurrentCombinedVulnList;
    }

    public ArrayList<Vuln> getChecklistVList() {
        return this.CurrentVisibleVulnsList;
    }

    public Vuln getCurrentVuln() {
        return this.CurrentVuln;
    }

    public ArrayList<Vuln> getCurrentVulns() {
        return this.CurrentVulns;
    }

    public File getCurrentFilePath() {
        return this.CurrentFilePath;
    }

    public Checklist getChecklist() {
        return this.Checklist;
    }

    public ArrayList<STIG> getSTIGs() {
        return this.Checklist.getChecklistSTIGList();
    }

    public ArrayList<STIG> getCurrentSTIGs() {
        return this.SelectedSTIGs;
    }

    public String getCklName() {
        return this.CklName;
    }

    public void setCklName(String name) {
        this.CklName = name;
        this.CklViewTab.setTabName();
    }

    public void setTargetPane(TargetPane target) {
        this.tPane = target;
    }

    public void setCurrentFilePath(File path) {
        this.CurrentFilePath = path;
    }

    public void setCurrentVuln(Vuln v) {
        this.CurrentVuln = v;
    }

    public void setCurrentVulns(ArrayList<Vuln> Vulns) {
        this.CurrentVulns = Vulns;
    }

    public void setChecklistObject(Checklist c) {
        this.Checklist = c;
    }

    public void setChecklistViewTab(ChecklistViewTab cvt) {
        this.CklViewTab = cvt;
    }

    public void setMenuBarID() {
        this.MenuBarDriver.setCurrentMenuBarValue(this.CklViewTab.getTab().getId());
    }

    @Override
    public MenuBar getMenuBar() {
        return this.MenuBarDriver.getMenuBar();
    }

    @Override
    public Tab getTab() {
        return this.CklViewTab.getTab();
    }

    public ChecklistViewTab getChecklistViewTab() {
        return this.CklViewTab;
    }

    @Override
    public void updateGUIOnTabSwitch() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMainPane(Pane myPane) {
    }

    @Override
    public Pane getMainPane() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setVisibleVulnList(ArrayList<Vuln> newList) {
        if (newList != null) {
            this.CurrentVisibleVulnsList = (ArrayList)newList.clone();
        }
    }

    @Override
    public ArrayList<Vuln> getMasterVulnList() {
        return this.CurrentMasterVulnsList;
    }

    @Override
    public final ArrayList<Vuln> getVisibleVulnList() {
        return this.CurrentVisibleVulnsList;
    }

    @Override
    public List<FilterEvent> getFilters() {
        return this.Filters;
    }

    @Override
    public void filterRun() {
        if (this.filterMode == GuiDriver.FilterMode.ALL) {
            this.Filters.get(0).updateFilter(this.getMasterVulnList());
            this.setVisibleVulnList(this.Filters.get(0).reFilter());
            for (int i = 1; i < this.Filters.size(); ++i) {
                this.Filters.get(i).updateFilter(this.getVisibleVulnList());
                this.setVisibleVulnList(this.Filters.get(i).reFilter());
            }
        } else if (this.filterMode == GuiDriver.FilterMode.ANY) {
            HashSet<Vuln> filteredSet = new HashSet<Vuln>();
            boolean anyActive = false;
            FilterEvent profileFilter = null;
            for (int i = 0; i < this.Filters.size(); ++i) {
                FilterEvent filter = this.Filters.get(i);
                if (!filter.isActive()) continue;
                if (filter instanceof ProfileFilter) {
                    profileFilter = filter;
                    continue;
                }
                anyActive = true;
                filter.updateFilter((ArrayList)this.getMasterVulnList().clone());
                ArrayList<Vuln> filterResult = filter.reFilter();
                filteredSet.addAll(filterResult);
            }
            ArrayList<Vuln> filteredList = new ArrayList<Vuln>(filteredSet);
            if (!anyActive) {
                filteredList = (ArrayList<Vuln>)this.getMasterVulnList().clone();
            }
            if (profileFilter != null) {
                profileFilter.updateFilter(filteredList);
                filteredList = profileFilter.reFilter();
            }
            this.setVisibleVulnList(filteredList);
        }
    }

    @Override
    public void setFilterMode(GuiDriver.FilterMode mode) {
        this.filterMode = mode;
        for (FilterEvent filter : this.Filters) {
            filter.setFilterMode(mode);
        }
    }

    @Override
    public GuiDriver.FilterMode getFilterMode() {
        return this.filterMode;
    }

    @Override
    public String getName() {
        return this.getCklName();
    }

    @Override
    public boolean isChanged() {
        return this.Checklist.isChanged();
    }

    public void updateChecklistItem(Vuln current, String NewFindingDetails, String NewComments, Vuln.CheckState NewStatus) {
        try {
            current.setCheckComment(NewComments);
            current.setCHK_Notes(NewFindingDetails);
            current.setCheckState(NewStatus);
        }
        catch (Exception e) {
            Logger.getLogger(ChecklistDriver.class.getName()).log(Level.INFO, "INFO: CB: An exception occured while updating a vulnerability's information");
        }
    }

    public void updateScoreMap() {
        for (STIG s : this.Checklist.getChecklistSTIGList()) {
            String tempScore = this.computeScore(s);
            s.setSTIG_Score(tempScore);
        }
    }

    private String computeScore(STIG s) {
        int pass = 0;
        int total = 0;
        double score = 0.0;
        for (Vuln v : s.getVulnList()) {
            switch (v.getCheckState()) {
                case NotAFinding: {
                    ++total;
                    ++pass;
                    break;
                }
                case Open: {
                    ++total;
                    break;
                }
                case Not_Reviewed: {
                    ++total;
                    break;
                }
            }
        }
        if (total > 0) {
            score = 100.0 * ((double)pass / (double)total);
            score = Math.floor(score * 100.0) / 100.0;
        } else {
            score = 100.0;
        }
        return "" + score;
    }

    public ChecklistMenuBar getMD() {
        return this.MenuBarDriver;
    }

    public class ChecklistItem {
        private Vuln ChecklistVuln;
        private String FindingDetails;
        private String Comments;
        private int CheckStatus;

        public ChecklistItem(Vuln ChecklistVuln, String FindingDetails, String Comments, int CheckStatus) {
            this.ChecklistVuln = ChecklistVuln;
            this.FindingDetails = FindingDetails;
            this.Comments = Comments;
            this.CheckStatus = CheckStatus;
        }

        public Vuln getVuln() {
            return this.ChecklistVuln;
        }

        public String getFindingDetails() {
            return this.FindingDetails;
        }

        public String getComments() {
            return this.Comments;
        }

        public int getCheckStatus() {
            return this.CheckStatus;
        }

        public void setVuln(Vuln ChecklistVuln) {
            this.ChecklistVuln = ChecklistVuln;
        }

        public void setFindingDetails(String FindingDetails) {
            this.FindingDetails = FindingDetails;
        }

        public void setComments(String Comments) {
            this.Comments = Comments;
        }

        public void setCheckStatus(int CheckStatus) {
            this.CheckStatus = CheckStatus;
        }
    }
}

