/*
 * Decompiled with CFR 0.152.
 */
package Program_Tabs.Tab_Checklist;

import File_Operations.File_Objects.STIG;
import Program_Tabs.Tab_Checklist.ChecklistDriver;
import Program_Tabs.Tab_Checklist.ChecklistViewTab;
import Program_Tabs.interfaces.Controller;
import Shared_Constructs.Rule_Display.Checklist_Rule_Display_Controller;
import Utility_Code.GlobalSettings.DisplayObject;
import java.io.File;
import java.util.ArrayList;
import javafx.scene.control.Tab;
import stigviewer.STIGViewer;

public class ChecklistControllerSetup {
    private ArrayList<Controller> Controllers;
    private ChecklistDriver CklDrive;
    private ChecklistViewTab CklVTab;

    public ChecklistControllerSetup(ArrayList<STIG> slist) {
        this.CklDrive = new ChecklistDriver(STIGViewer.getSV(), slist);
        this.SharedControllerSetup();
        this.CklVTab.getCklDrive().getChecklist().setChanged(true);
    }

    public ChecklistControllerSetup(File cklFile) throws Exception {
        this.CklDrive = new ChecklistDriver(STIGViewer.getSV(), cklFile);
        this.SharedControllerSetup();
        this.CklVTab.updateDisplay();
        this.CklVTab.getCklDrive().getChecklist().setChanged(false);
    }

    private void SharedControllerSetup() {
        this.CklVTab = new ChecklistViewTab(STIGViewer.getSV(), this.CklDrive);
        STIGViewer.getSV().addDisplayObject(this.CklVTab);
        this.CklDrive.setChecklistViewTab(this.CklVTab);
        this.CklDrive.setMenuBarID();
        this.Controllers = new ArrayList();
        this.Controllers.add(new Checklist_Rule_Display_Controller(this.CklVTab, this.CklDrive, this.CklVTab.getRDisplay()));
        for (DisplayObject od : this.CklVTab.getChildDisplayObjects()) {
            od.tieControllers(this.getControllers(od.getClass().getSimpleName()));
        }
        STIGViewer.getSV().OpenNewTab(this.CklDrive);
        this.CklVTab.initSTIGList();
    }

    private ArrayList<Controller> getControllers(String code) {
        ArrayList<Controller> c = new ArrayList<Controller>();
        switch (code) {
            case "Checklist_Rule_Display": {
                c.add(this.Controllers.get(0));
                break;
            }
            case "VulnTable": {
                c.add(this.Controllers.get(0));
                break;
            }
        }
        return c;
    }

    public boolean cmpView(Tab ct) {
        boolean ret = false;
        if (this.CklVTab.getTab().equals(ct)) {
            ret = true;
        }
        return ret;
    }
}

