/*
 * Decompiled with CFR 0.152.
 */
package File_Operations.File_Writers;

import File_Operations.File_Objects.Checklist;
import File_Operations.File_Objects.STIG;
import File_Operations.File_Objects.Vuln;
import File_Operations.File_Writers.Checklist_Writer_2x;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class CMRS_Writer {
    private static CMRS_Writer Writer;
    private XMLStreamWriter XMLW = null;
    private Checklist Ckl = new Checklist();
    private int Depth = 0;
    private Map<String, List<Vuln>> targetVulnMap;
    private Map<String, STIG> targetSTIGMap;

    public void writeCMRS(File f, Checklist ckl) {
        this.Ckl = ckl;
        FileOutputStream fst = null;
        this.targetVulnMap = new HashMap<String, List<Vuln>>();
        this.targetSTIGMap = new HashMap<String, STIG>();
        for (STIG stig : ckl.getChecklistSTIGList()) {
            for (Vuln vuln : stig.getVulnList()) {
                String target = vuln.getAttr(Vuln.VulnAttr.TargetKey);
                if (!this.targetVulnMap.containsKey(target)) {
                    this.targetVulnMap.put(target, new ArrayList());
                }
                if (!this.targetSTIGMap.containsKey(target)) {
                    this.targetSTIGMap.put(target, stig);
                }
                this.targetVulnMap.get(target).add(vuln);
            }
        }
        try {
            fst = new FileOutputStream(f);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(CMRS_Writer.class.getName()).log(Level.SEVERE, "SEVERE: CR: 1.1: Exception occured while outputting a CMRS export");
        }
        XMLOutputFactory xmlFact = XMLOutputFactory.newInstance();
        try {
            this.XMLW = xmlFact.createXMLStreamWriter(new BufferedOutputStream(fst), "UTF-8");
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(Checklist_Writer_2x.class.getName()).log(Level.SEVERE, "SEVERE: CR: 1.2: Exception occured while outputting a CMRS export");
        }
        try {
            this.Depth = 0;
            this.XMLW.writeStartDocument("UTF-8", "1.0");
            this.nest();
            this.XMLW.writeStartElement("IMPORT_FILE");
            this.XMLW.writeAttribute("xmlns", "urn:FindingImport");
            this.writeAsset();
            this.writeTargets();
            this.subD();
            this.nest();
            this.XMLW.writeEndElement();
            this.subD();
            this.nest();
            this.XMLW.writeEndElement();
            this.XMLW.writeEndDocument();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(CMRS_Writer.class.getName()).log(Level.SEVERE, "SEVERE: CR: 1.3: Exception occured while outputting a CMRS export");
        }
        try {
            this.XMLW.close();
            ((OutputStream)fst).close();
        }
        catch (IOException | XMLStreamException ex) {
            Logger.getLogger(CMRS_Writer.class.getName()).log(Level.SEVERE, "SEVERE: CR: 1.4: Exception occured while outputting a CMRS export");
        }
    }

    private void writeTargets() {
        try {
            for (String target : this.targetVulnMap.keySet()) {
                this.nest();
                this.XMLW.writeStartElement("TARGET");
                this.writeElementWithData("TARGET_ID", this.targetSTIGMap.get(target).getSTIG_BID());
                this.writeElementWithData("TARGET_KEY", target);
                for (Vuln v : this.targetVulnMap.get(target)) {
                    this.writeVuln(v);
                }
                this.nest();
                this.XMLW.writeEndElement();
            }
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(CMRS_Writer.class.getName()).log(Level.SEVERE, "SEVERE: CR: 1.5: Exception occured while outputting a CMRS export");
        }
    }

    private void writeVuln(Vuln v) {
        try {
            this.addD();
            this.nest();
            this.XMLW.writeStartElement("FINDING");
            this.addD();
            this.nest();
            this.XMLW.writeStartElement("FINDING_ID");
            this.XMLW.writeAttribute("TYPE", "VK");
            this.XMLW.writeAttribute("ID", v.getAttr(Vuln.VulnAttr.Rule_ID));
            this.XMLW.writeCharacters(this.formatVZeros(v.getAttr(Vuln.VulnAttr.Vuln_Num)));
            this.XMLW.writeEndElement();
            this.subD();
            this.writeElementWithData("FINDING_STATUS", v.getCheckState().toString());
            this.addD();
            this.nest();
            this.XMLW.writeStartElement("FINDING_DETAILS");
            this.XMLW.writeAttribute("OVERRIDE", "O");
            this.XMLW.writeCharacters(v.getCHK_Notes());
            this.XMLW.writeEndElement();
            this.subD();
            if (!v.getCheckSevOverride().isEmpty()) {
                this.writeElementWithData("SEV_OVERRIDE_CODE", this.determineSevCode(v.getCheckSevOverride()));
                this.writeElementWithData("SEV_OVERRIDE_TEXT", v.getCheckSevJust());
            }
            this.writeElementWithData("SCRIPT_RESULTS", "");
            this.writeElementWithData("COMMENT", v.getCheckComment());
            this.writeElementWithData("TOOL", "DISA STIG Viewer");
            this.writeElementWithData("TOOL_VERSION", "2.8");
            this.writeElementWithData("AUTHENTICATED_FINDING", "true");
            this.nest();
            this.subD();
            this.XMLW.writeEndElement();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(CMRS_Writer.class.getName()).log(Level.SEVERE, "SEVERE: CR: 1.6: Exception occured while outputting a CMRS export");
        }
    }

    private void writeAsset() {
        try {
            this.addD();
            this.nest();
            this.XMLW.writeStartElement("ASSET");
            int assetType = 2;
            if (this.Ckl.getIsComputing().equals("Computing")) {
                this.writeElementWithData("ASSET_TS", this.getTimeStamp());
                this.writeAssetElement("ASSET NAME", this.Ckl.getHostName());
                this.writeAssetElement("MAC ADDRESS", this.Ckl.getMACAddress());
                this.writeAssetElement("IP ADDRESS", this.Ckl.getIPAddress());
                this.writeAssetElement("FQDN", this.Ckl.getFullyQualifiedDN());
                this.writeAssetElement("TechArea", this.Ckl.getTechnologyArea());
                assetType = 1;
            }
            this.addD();
            this.nest();
            this.XMLW.writeStartElement("ASSET_TYPE");
            this.writeElementWithData("ASSET_TYPE_KEY", "" + assetType);
            this.nest();
            this.XMLW.writeEndElement();
            switch (this.Ckl.getRole()) {
                case "Workstation": {
                    this.subD();
                    this.writeElementWithData("WORKSTATION", "1");
                    this.addD();
                    break;
                }
                case "Member Server": {
                    this.nest();
                    this.XMLW.writeStartElement("ELEMENT");
                    this.writeElementWithData("ELEMENT_KEY", "221");
                    this.nest();
                    this.XMLW.writeEndElement();
                    this.nest();
                    this.XMLW.writeStartElement("ELEMENT");
                    this.writeElementWithData("ELEMENT_KEY", "222");
                    this.nest();
                    this.XMLW.writeEndElement();
                    break;
                }
                case "Domain Controller": {
                    this.nest();
                    this.XMLW.writeStartElement("ELEMENT");
                    this.writeElementWithData("ELEMENT_KEY", "221");
                    this.nest();
                    this.XMLW.writeEndElement();
                    this.nest();
                    this.XMLW.writeStartElement("ELEMENT");
                    this.writeElementWithData("ELEMENT_KEY", "223");
                    this.nest();
                    this.XMLW.writeEndElement();
                    break;
                }
            }
            for (String target : this.targetVulnMap.keySet()) {
                this.nest();
                this.XMLW.writeStartElement("ELEMENT");
                this.writeElementWithData("ELEMENT_KEY", target);
                this.nest();
                this.XMLW.writeEndElement();
            }
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(CMRS_Writer.class.getName()).log(Level.SEVERE, "SEVERE: CR: 1.7: Exception occured while outputting a CMRS export");
        }
    }

    private void writeAssetElement(String attribVal, String eleVal) throws XMLStreamException {
        this.addD();
        this.nest();
        this.XMLW.writeStartElement("ASSET_ID");
        this.XMLW.writeAttribute("TYPE", attribVal);
        this.XMLW.writeCharacters(eleVal);
        this.XMLW.writeEndElement();
        this.subD();
    }

    private void writeElementWithData(String ename, String eleVal) throws XMLStreamException {
        this.addD();
        this.nest();
        this.XMLW.writeStartElement(ename);
        this.XMLW.writeCharacters(eleVal);
        this.XMLW.writeEndElement();
        this.subD();
    }

    private String formatVZeros(String s) {
        String tempS = s.substring(2);
        for (int i = s.length() - 2; i < 7; ++i) {
            tempS = "0" + tempS;
        }
        return "V" + tempS;
    }

    private String determineSevCode(String sev) {
        String ret = "";
        switch (sev) {
            case "high": {
                ret = "1";
                break;
            }
            case "medium": {
                ret = "2";
                break;
            }
            case "low": {
                ret = "3";
                break;
            }
            default: {
                ret = "";
            }
        }
        return ret;
    }

    private String getTimeStamp() {
        String timestp = "";
        try {
            GregorianCalendar GC = new GregorianCalendar();
            GC.setTime(new Date(System.currentTimeMillis()));
            XMLGregorianCalendar cal = DatatypeFactory.newInstance().newXMLGregorianCalendar(GC);
            timestp = cal.toString();
        }
        catch (DatatypeConfigurationException ex) {
            Logger.getLogger(CMRS_Writer.class.getName()).log(Level.SEVERE, "SEVERE: CR: 1.8: Exception occured while outputting a CMRS export");
        }
        return timestp;
    }

    private void nest() throws XMLStreamException {
        this.XMLW.writeCharacters("\n");
        for (int i = 0; i < this.Depth; ++i) {
            this.XMLW.writeCharacters("\t");
        }
    }

    private void addD() {
        ++this.Depth;
    }

    private void subD() {
        --this.Depth;
    }

    public static CMRS_Writer getCMRS_Writer() {
        if (Writer == null) {
            Writer = new CMRS_Writer();
        }
        return Writer;
    }
}

