/*
 * Decompiled with CFR 0.152.
 */
package File_Operations.File_Readers;

import File_Operations.File_Objects.SCAPRes.SCAPResults;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class SCAPResults_Read {
    private static SCAPResults_Read Reader;
    private SCAPResults Results = new SCAPResults();
    private XMLStreamReader XMLR = null;

    private SCAPResults_Read() {
    }

    public SCAPResults readSCAPResults(File f) {
        FileInputStream inXml = null;
        try {
            inXml = new FileInputStream(f);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SCAPResults_Read.class.getName()).log(Level.SEVERE, null, ex);
        }
        XMLInputFactory xmlFact = XMLInputFactory.newInstance();
        try {
            this.XMLR = xmlFact.createXMLStreamReader(inXml);
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(SCAPResults_Read.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.parseResults();
        try {
            ((InputStream)inXml).close();
            this.XMLR.close();
        }
        catch (IOException | XMLStreamException ex) {
            Logger.getLogger(SCAPResults_Read.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.Results;
    }

    private void parseResults() {
        this.Results = new SCAPResults();
        try {
            boolean foundRes = false;
            while (this.XMLR.hasNext()) {
                this.XMLR.next();
                if (!this.XMLR.isStartElement() || !this.XMLR.getLocalName().equals("TestResult")) continue;
                this.parseTestResults();
                foundRes = true;
            }
            if (!foundRes) {
                throw new Exception();
            }
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(SCAPResults_Read.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(SCAPResults_Read.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void parseTestResults() {
        try {
            while (this.XMLR.hasNext()) {
                this.XMLR.next();
                if (!this.XMLR.isStartElement()) continue;
                switch (this.XMLR.getLocalName()) {
                    case "rule-result": {
                        String ruleref = this.splitScapRuleId(this.parseXMLAttr("idref"));
                        String res = this.parseRuleResult();
                        this.Results.addResult(res, ruleref);
                        break;
                    }
                    case "fact": {
                        String eleName = this.parseXMLAttr("name");
                        if (eleName.contains("host_name")) {
                            this.Results.setHostName(this.XMLR.getElementText());
                            break;
                        }
                        if (eleName.contains("fqdn")) {
                            this.Results.setFQDN(this.XMLR.getElementText());
                            break;
                        }
                        if (eleName.contains("mac")) {
                            this.Results.setMACAddress(this.XMLR.getElementText());
                            break;
                        }
                        if (!eleName.equals("system_info")) break;
                        this.parseMcafeeData(this.XMLR.getElementText());
                        break;
                    }
                    case "target-address": {
                        this.Results.setIPAddress(this.XMLR.getElementText());
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(SCAPResults_Read.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void parseMcafeeData(String data) {
        String[] tokens;
        for (String s : tokens = data.split("<")) {
            if (!s.contains("primary_host_name>")) continue;
            this.Results.setHostName(s.substring(18));
            break;
        }
        for (String s : tokens) {
            if (!s.contains("mac_address>")) continue;
            this.Results.setMACAddress(s.substring(12));
            break;
        }
    }

    private String parseRuleResult() {
        String res = "";
        try {
            while (this.XMLR.hasNext()) {
                this.XMLR.next();
                if (!this.XMLR.isStartElement() || !this.XMLR.getLocalName().equals("result")) continue;
                res = this.XMLR.getElementText();
                break;
            }
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(SCAPResults_Read.class.getName()).log(Level.SEVERE, null, ex);
        }
        return res;
    }

    private String parseXMLAttr(String attr) {
        String ret = "";
        for (int i = 0; i < this.XMLR.getAttributeCount(); ++i) {
            if (!this.XMLR.getAttributeName(i).getLocalPart().equals(attr)) continue;
            ret = this.XMLR.getAttributeValue(i);
            break;
        }
        return ret;
    }

    private String splitScapRuleId(String id) {
        String spStr = "";
        String[] split = id.split("_");
        spStr = split[split.length - 1].equals("rule") ? split[split.length - 2] + "_" + split[split.length - 1] : id;
        return spStr;
    }

    public static SCAPResults_Read getSCAPResults_Read() {
        if (Reader == null) {
            Reader = new SCAPResults_Read();
        }
        return Reader;
    }
}

