/*
 * Decompiled with CFR 0.152.
 */
package File_Operations.File_Readers;

import File_Operations.File_Writers.PreferencesWriter;
import Utility_Code.GlobalSettings.Util;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import stigviewer.STIGViewer;

public class PreferencesReader {
    private final File PreferencesFile;
    private static PreferencesReader PrefRead;

    private PreferencesReader(File f) {
        this.PreferencesFile = f;
        if (!this.PreferencesFile.exists()) {
            try {
                Files.write(this.PreferencesFile.toPath(), new byte[0], StandardOpenOption.CREATE);
            }
            catch (IOException ex) {
                Logger.getLogger(PreferencesWriter.class.getName()).log(Level.SEVERE, "SEVERE: PR: Reader could not create the Preference file");
            }
        }
    }

    public Object importPref() {
        ArrayList preferences = new ArrayList();
        try {
            preferences = (ArrayList)Files.readAllLines(this.PreferencesFile.toPath(), Charset.forName("UTF-8"));
        }
        catch (IOException ex) {
            Logger.getLogger(PreferencesReader.class.getName()).log(Level.SEVERE, "SEVERE: PR: Reader could not read the Preferences file");
        }
        return preferences;
    }

    public static PreferencesReader getPreferencesReader() {
        if (PrefRead == null) {
            PrefRead = new PreferencesReader(new File(STIGViewer.getSV().getSavePoint().GetSavePointLocation() + Util.GetSlash() + "Preferences.cnf"));
        }
        return PrefRead;
    }
}

