/*
 * Decompiled with CFR 0.152.
 */
package File_Operations.File_Objects;

import File_Operations.Legacy.File_Interfaces.CCIReader;
import Shared_Constructs.ChangeObserver;
import Shared_Constructs.ChangeProvider;
import Utility_Code.GlobalSettings.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class Vuln
implements Serializable,
ChangeProvider {
    private ArrayList<String> attr;
    private VulnSTIGID VulnSTIGID = new VulnSTIGID();
    private VulnRuleID VulnRuleID = new VulnRuleID();
    private VulnIDs VulnIDs = new VulnIDs();
    private final VulnCCI VulnCCI_ID = new VulnCCI();
    private sVulnSTIGID sVulnSTIGID = new sVulnSTIGID();
    private sVulnRuleID sVulnRuleID = new sVulnRuleID();
    private sVulnIDs sVulnIDs = new sVulnIDs();
    private final sVulnCCI sVulnCCI_ID = new sVulnCCI();
    ArrayList<CCIReader.CCI_Store> myCCI;
    private ArrayList<String> CCI_Nums;
    private String sCHK_Notes;
    private CheckState CHK_State;
    private String sCHK_SEV_OVER;
    private String sCHK_SEV_Just;
    private String sCHK_Comment;
    private final ArrayList<String> STIGProfiles;
    private final List<ChangeObserver> changeListeners;

    public Vuln() {
        int x = VulnAttr.values().length;
        this.attr = new ArrayList();
        this.CCI_Nums = new ArrayList();
        this.myCCI = new ArrayList();
        this.STIGProfiles = new ArrayList();
        for (int i = 0; i < x - 1; ++i) {
            this.attr.add("");
        }
        this.sCHK_Notes = "";
        this.CHK_State = CheckState.Not_Reviewed;
        this.sCHK_SEV_OVER = "";
        this.sCHK_SEV_Just = "";
        this.sCHK_Comment = "";
        this.changeListeners = new ArrayList<ChangeObserver>();
    }

    public boolean isEmpty() {
        boolean ret = true;
        for (String s : this.attr) {
            if (s.equals("")) continue;
            ret = false;
        }
        if (!this.CCI_Nums.isEmpty()) {
            ret = false;
        }
        if (!this.myCCI.isEmpty()) {
            ret = false;
        }
        if (!this.STIGProfiles.isEmpty()) {
            ret = false;
        }
        if (!this.sCHK_Notes.equals("")) {
            ret = false;
        }
        if (!this.sCHK_SEV_OVER.equals("")) {
            ret = false;
        }
        if (!this.sCHK_SEV_Just.equals("")) {
            ret = false;
        }
        if (!this.sCHK_Comment.equals("")) {
            ret = false;
        }
        return ret;
    }

    public Vuln Clean() {
        Vuln v = new Vuln();
        v.setAttrs((ArrayList)this.attr.clone());
        v.setCCI((ArrayList)this.myCCI.clone());
        v.setCCIs((ArrayList)this.CCI_Nums.clone());
        return v;
    }

    public String getAttr(VulnAttr index) {
        String sTemp = this.attr.get(index.ordinal());
        if (sTemp != null) {
            return sTemp;
        }
        return "";
    }

    public ArrayList<String> getAttrs() {
        return this.attr;
    }

    public VulnSTIGID getVulnSTIGID() {
        return new VulnSTIGID();
    }

    public VulnRuleID getVulnRuleID() {
        return this.VulnRuleID;
    }

    public VulnIDs getVulnIDs() {
        return this.VulnIDs;
    }

    public VulnCCI getVulnCCI_ID() {
        return new VulnCCI();
    }

    public sVulnSTIGID getsVulnSTIGID() {
        return new sVulnSTIGID();
    }

    public sVulnRuleID getsVulnRuleID() {
        return this.sVulnRuleID;
    }

    public sVulnIDs getsVulnIDs() {
        return this.sVulnIDs;
    }

    public sVulnCCI getsVulnCCI_ID() {
        return new sVulnCCI();
    }

    public String getCHK_Notes() {
        return this.sCHK_Notes;
    }

    public CheckState getCheckState() {
        return this.CHK_State;
    }

    public String getCheckSevOverride() {
        return this.sCHK_SEV_OVER;
    }

    public String getCheckSevJust() {
        return this.sCHK_SEV_Just;
    }

    public String getCheckComment() {
        return this.sCHK_Comment;
    }

    public List<String> getSTIGProfiles() {
        return this.STIGProfiles;
    }

    public CCIReader.CCI_Store GetCCI(int i) {
        if (i >= 0 && i < this.myCCI.size()) {
            return this.myCCI.get(i);
        }
        return null;
    }

    public CCIReader.CCI_Store GetCCIbyName(String s) {
        try {
            for (CCIReader.CCI_Store cci : this.myCCI) {
                if (cci == null || !cci.sID.equals(s)) continue;
                return cci;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public ArrayList<CCIReader.CCI_Store> GetCCIs() {
        return this.myCCI;
    }

    public String GetCCIVal(int i) {
        if (this.CCI_Nums.size() > 0) {
            return this.CCI_Nums.get(i);
        }
        return "";
    }

    public ArrayList<String> GetCCIVals() {
        return this.CCI_Nums;
    }

    public String getAllCCIs() {
        String sRet = "";
        if (this.CCI_Nums.size() > 0) {
            for (String s : this.CCI_Nums) {
                sRet = sRet + s + ", ";
            }
            sRet = sRet.substring(0, sRet.length() - 2);
        }
        return sRet;
    }

    public String getAllCCIText() {
        String sText = "";
        try {
            ArrayList<CCIReader.CCI_Store> CCIs = this.myCCI;
            if (CCIs.size() == this.CCI_Nums.size() && this.CCI_Nums.size() > 0) {
                sText = "";
                String sNL = "\n";
                for (String sCCI : this.CCI_Nums) {
                    sText = sText + sCCI + sNL;
                    CCIReader.CCI_Store cci = this.GetCCIbyName(sCCI);
                    if (cci != null) {
                        sText = sText + cci.sDefinition + sNL;
                        for (int k = 0; k < cci.sRefs.size(); ++k) {
                            sText = sText + cci.sRefs.get(k).getFirst() + " :: " + cci.sRefs.get(k).getSecond() + sNL;
                        }
                    }
                    sText = sText + sNL;
                }
            }
            return sText;
        }
        catch (Exception e) {
            if (Util.bAllowPrintln) {
                e.printStackTrace();
            }
            return this.getAllCCIs();
        }
    }

    public void setAttr(VulnAttr index, String str) {
        this.attr.set(index.ordinal(), str);
        this.updateListeners();
    }

    public void setAttrs(ArrayList<String> attributes) {
        this.attr = attributes;
        this.updateListeners();
    }

    public void setVulnSTIGID(VulnSTIGID vulnSTIGID) {
        this.VulnSTIGID = vulnSTIGID;
        this.updateListeners();
    }

    public void setVulnRuleID(VulnRuleID vulnRuleID) {
        this.VulnRuleID = vulnRuleID;
        this.updateListeners();
    }

    public void setVulnIDs(VulnIDs vulnIDs) {
        this.VulnIDs = vulnIDs;
        this.updateListeners();
    }

    public void setsVulnSTIGID(sVulnSTIGID svulnSTIGID) {
        this.sVulnSTIGID = svulnSTIGID;
        this.updateListeners();
    }

    public void setsVulnRuleID(sVulnRuleID svulnRuleID) {
        this.sVulnRuleID = svulnRuleID;
        this.updateListeners();
    }

    public void setsVulnIDs(sVulnIDs svulnIDs) {
        this.sVulnIDs = svulnIDs;
        this.updateListeners();
    }

    public void setCHK_Notes(String sNotes) {
        if (!this.sCHK_Notes.equals(sNotes)) {
            this.sCHK_Notes = sNotes;
            this.updateListeners();
        }
    }

    public void setCheckState(CheckState State) {
        if (!this.CHK_State.equals((Object)State)) {
            this.CHK_State = State;
            this.updateListeners();
        }
    }

    public void setCheckSevOverride(String sSevOver) {
        this.sCHK_SEV_OVER = sSevOver;
        this.updateListeners();
    }

    public void setCheckSevJust(String sSevJust) {
        this.sCHK_SEV_Just = sSevJust;
        this.updateListeners();
    }

    public void setCheckComment(String sComment) {
        if (!this.sCHK_Comment.equals(sComment)) {
            this.sCHK_Comment = sComment;
            this.updateListeners();
        }
    }

    public void addCCI(CCIReader.CCI_Store cci) {
        this.myCCI.add(cci);
        this.updateListeners();
    }

    public void setCCI(ArrayList<CCIReader.CCI_Store> CCIs) {
        this.myCCI = CCIs;
        this.updateListeners();
    }

    public void clearCCIs() {
        this.myCCI.clear();
        this.updateListeners();
    }

    public void addCCIVal(String s) {
        this.CCI_Nums.add(s);
        this.updateListeners();
    }

    public void addSTIGProfile(String s) {
        this.STIGProfiles.add(s);
        this.updateListeners();
    }

    public void setCCIs(ArrayList<String> CCI_Names) {
        this.CCI_Nums = CCI_Names;
        this.updateListeners();
    }

    public void clearCCIVals() {
        this.CCI_Nums.clear();
        this.updateListeners();
    }

    public Object getmyCCI() {
        return this.VulnCCI_ID;
    }

    @Override
    public void addChangeListener(ChangeObserver listener) {
        this.changeListeners.add(listener);
    }

    @Override
    public void removeChangeListener(ChangeObserver listener) {
        this.changeListeners.remove(listener);
    }

    protected void updateListeners() {
        this.changeListeners.forEach(listener -> listener.update());
    }

    public class sVulnCCI
    implements Comparator<String>,
    Serializable {
        @Override
        public int compare(String o1, String o2) {
            try {
                if (o1.contains(",")) {
                    o1 = o1.substring(0, o1.indexOf(","));
                }
                if (o2.contains(",")) {
                    o2 = o2.substring(0, o2.indexOf(","));
                }
                if (o1.length() > o2.length()) {
                    return 1;
                }
                if (o1.length() < o2.length()) {
                    return -1;
                }
                if (o1.length() > 4 && o2.length() > 4) {
                    if (new Integer(o1.substring(4)).compareTo(new Integer(o2.substring(4))) > 0) {
                        return 1;
                    }
                    if (new Integer(o1.substring(4)).compareTo(new Integer(o2.substring(4))) < 0) {
                        return -1;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }
    }

    public class sVulnIDs
    implements Comparator<String>,
    Serializable {
        @Override
        public int compare(String o1, String o2) {
            if (o1.length() > o2.length()) {
                return 1;
            }
            if (o1.length() < o2.length()) {
                return -1;
            }
            if (o1.compareTo(o2) > 0) {
                return 1;
            }
            if (o1.compareTo(o2) < 0) {
                return -1;
            }
            return 0;
        }
    }

    public class sVulnRuleID
    implements Comparator<String>,
    Serializable {
        @Override
        public int compare(String o1, String o2) {
            if (o1.length() > o2.length()) {
                return 1;
            }
            if (o1.length() < o2.length()) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    }

    public class sVulnSTIGID
    implements Comparator<String>,
    Serializable {
        @Override
        public int compare(String o1, String o2) {
            if (o1.length() > o2.length()) {
                return 1;
            }
            if (o1.length() < o2.length()) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    }

    public class VulnCCI
    implements Comparator<Vuln>,
    Serializable {
        @Override
        public int compare(Vuln o1, Vuln o2) {
            block10: {
                try {
                    if (o1.GetCCIVals().size() > 0 && o2.GetCCIVals().size() > 0) {
                        if (o1.GetCCIVal(0).length() > o2.GetCCIVal(0).length()) {
                            return 1;
                        }
                        if (o1.GetCCIVal(0).length() < o2.GetCCIVal(0).length()) {
                            return -1;
                        }
                        if (o1.GetCCIVal(0).length() > 4 && o2.GetCCIVal(0).length() > 4) {
                            if (new Integer(o1.GetCCIVal(0).substring(4)).compareTo(new Integer(o2.GetCCIVal(0).substring(4))) > 0) {
                                return 1;
                            }
                            if (new Integer(o1.GetCCIVal(0).substring(4)).compareTo(new Integer(o2.GetCCIVal(0).substring(4))) < 0) {
                                return -1;
                            }
                        }
                        break block10;
                    }
                    if (o1.GetCCIVals().size() > 0 && o2.GetCCIVals().size() < 1) {
                        return -1;
                    }
                    if (o1.GetCCIVals().size() < 1 && o2.GetCCIVals().size() > 0) {
                        return 1;
                    }
                    return 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return 0;
        }
    }

    public class VulnIDs
    implements Comparator<Vuln>,
    Serializable {
        @Override
        public int compare(Vuln o1, Vuln o2) {
            if (o1.getAttr(VulnAttr.Vuln_Num).length() > o2.getAttr(VulnAttr.Vuln_Num).length()) {
                return 1;
            }
            if (o1.getAttr(VulnAttr.Vuln_Num).length() < o2.getAttr(VulnAttr.Vuln_Num).length()) {
                return -1;
            }
            if (o1.getAttr(VulnAttr.Vuln_Num).compareTo(o2.getAttr(VulnAttr.Vuln_Num)) > 0) {
                return 1;
            }
            if (o1.getAttr(VulnAttr.Vuln_Num).compareTo(o2.getAttr(VulnAttr.Vuln_Num)) < 0) {
                return -1;
            }
            return 0;
        }
    }

    public class VulnRuleID
    implements Comparator<Vuln>,
    Serializable {
        @Override
        public int compare(Vuln o1, Vuln o2) {
            return o1.getAttr(VulnAttr.Rule_ID).compareTo(o2.getAttr(VulnAttr.Rule_ID));
        }
    }

    public class VulnSTIGID
    implements Comparator<Vuln>,
    Serializable {
        @Override
        public int compare(Vuln o1, Vuln o2) {
            if (o1.getAttr(VulnAttr.Rule_Ver).length() > o2.getAttr(VulnAttr.Rule_Ver).length()) {
                return 1;
            }
            if (o1.getAttr(VulnAttr.Rule_Ver).length() < o2.getAttr(VulnAttr.Rule_Ver).length()) {
                return -1;
            }
            return o1.getAttr(VulnAttr.Rule_Ver).compareTo(o2.getAttr(VulnAttr.Rule_Ver));
        }
    }

    public static enum CheckState {
        Not_Reviewed("NR"),
        Open("O"),
        NotAFinding("NF"),
        Not_Applicable("NA");

        String text;

        private CheckState(String s) {
            this.text = s;
        }

        public static CheckState fromInt(int i) {
            CheckState csRet = Not_Reviewed;
            switch (i) {
                case 0: {
                    csRet = Not_Reviewed;
                    break;
                }
                case 1: {
                    csRet = Open;
                    break;
                }
                case 2: {
                    csRet = NotAFinding;
                    break;
                }
                case 3: {
                    csRet = Not_Applicable;
                    break;
                }
            }
            return csRet;
        }

        public static int toInt(CheckState cs) {
            switch (cs) {
                case Not_Reviewed: {
                    return 0;
                }
                case Open: {
                    return 1;
                }
                case NotAFinding: {
                    return 2;
                }
                case Not_Applicable: {
                    return 3;
                }
            }
            return 0;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum VulnAttr {
        Vuln_Num("Vuln ID"),
        Severity("Severity"),
        Group_Title("Group Title"),
        Rule_ID("Rule ID"),
        Rule_Ver("STIG ID"),
        Rule_Title("Rule Title"),
        Vuln_Discuss("Discussion"),
        IA_Controls("IA Controls"),
        Check_Content("Check Content"),
        Fix_Text("Fix Text"),
        False_Positives("False Positives"),
        False_Negatives("False Negatives"),
        Documentable("Documentable"),
        Mitigations("Mitigations"),
        Potential_Impact("Potential Impact"),
        Third_Party_Tools("Third Party Tools"),
        Mitigation_Control("Mitigation Control"),
        Responsibility("Responsibility"),
        Security_Override_Guidance("Severity Override Guidance"),
        Check_Content_Ref("Check Content Reference"),
        Weight("Weight"),
        Class("Classification"),
        STIGRef("STIG"),
        TargetKey("VMS Asset Posture"),
        NULL("null");

        String text;

        private VulnAttr(String s) {
            this.text = s;
        }

        public String toString() {
            return this.text;
        }
    }
}

