/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.safari.SafariDriverConnection;
import org.openqa.selenium.safari.SafariDriverWebSocketHandler;
import org.webbitserver.HttpControl;
import org.webbitserver.HttpHandler;
import org.webbitserver.HttpRequest;
import org.webbitserver.HttpResponse;
import org.webbitserver.WebServer;
import org.webbitserver.WebServers;
import org.webbitserver.WebSocketHandler;

class SafariDriverServer {
    private static final Logger LOG = Logger.getLogger(SafariDriverServer.class.getName());
    private final int port;
    private final BlockingQueue<SafariDriverConnection> connections = new SynchronousQueue<SafariDriverConnection>();
    private WebServer server;

    public SafariDriverServer(int port) {
        Preconditions.checkArgument(port >= 0, "Port must be >= 0: %d", port);
        this.port = port;
    }

    public void start() {
        this.start(this.port);
    }

    private void start(int port) {
        if (this.server != null) {
            return;
        }
        if (port == 0) {
            port = PortProber.findFreePort();
        }
        this.server = WebServers.createWebServer((int)port).add("/favicon.ico", (HttpHandler)new FaviconHandler()).add("/", (HttpHandler)new RootHttpHandler(port)).add("/wd", (WebSocketHandler)new SafariDriverWebSocketHandler(this.connections));
        this.server.start();
        LOG.info("Server started at " + this.server.getUri());
    }

    public void stop() {
        if (this.server != null) {
            LOG.info("Stopping server");
            try {
                this.server.stop().get(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WebDriverException(e);
            }
            catch (ExecutionException e) {
                throw new WebDriverException(e);
            }
            catch (TimeoutException e) {
                throw new WebDriverException("timed out stopping server", e);
            }
            this.server = null;
        }
    }

    public String getUri() {
        Preconditions.checkState(this.server != null, "The server is not running; call #start()!");
        return "http://localhost:" + this.server.getPort();
    }

    public SafariDriverConnection getConnection(long timeout, TimeUnit unit) throws InterruptedException {
        return this.connections.poll(timeout, unit);
    }

    private static class FaviconHandler
    implements HttpHandler {
        private FaviconHandler() {
        }

        public void handleHttpRequest(HttpRequest request, HttpResponse response, HttpControl control) {
            response.status(204).end();
        }
    }

    private static class RootHttpHandler
    implements HttpHandler {
        private static final String CONNECT_TEMPLATE = Joiner.on("\n").join("<!DOCTYPE html>", "<h2>SafariDriver requesting connection at ws://localhost:%d/wd</h2>", "<script>", "// Must wait for onload so the injected script is loaded by the", "// SafariDriver extension.", "window.onload = function() {", "  window.postMessage({", "    'type': 'connect',", "    'origin': 'webdriver',", "    'url': 'ws://localhost:%d/wd'", "  }, '*');", "};", "</script>");
        private final int port;

        public RootHttpHandler(int port) {
            this.port = port;
        }

        public void handleHttpRequest(HttpRequest request, HttpResponse response, HttpControl control) {
            response.header("Content-type", "text/html").content(String.format(CONNECT_TEMPLATE, this.port, this.port)).end();
        }
    }
}

