/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.seleniumemulation.ElementFinder;
import org.openqa.selenium.internal.seleniumemulation.SeleneseCommand;

public class IsEditable
extends SeleneseCommand<Boolean> {
    private final ElementFinder finder;

    public IsEditable(ElementFinder finder) {
        this.finder = finder;
    }

    @Override
    protected Boolean handleSeleneseCommand(WebDriver driver, String locator, String value) {
        WebElement element = this.finder.findElement(driver, locator);
        String tagName = element.getTagName().toLowerCase();
        boolean acceptableTagName = "input".equals(tagName) || "select".equals(tagName);
        String readonly = "";
        if ("input".equals(tagName) && ((readonly = element.getAttribute("readonly")) == null || "false".equals(readonly))) {
            readonly = "";
        }
        if (element.isEnabled() && acceptableTagName && "".equals(readonly)) {
            return true;
        }
        return false;
    }
}

