/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.selenesedriver;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.thoughtworks.selenium.Selenium;
import java.io.StringWriter;
import java.util.List;
import org.json.JSONException;
import org.json.JSONWriter;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.JsonException;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;

class ScriptExecutor {
    private final Selenium selenium;
    private boolean inAppUnderTest = false;

    public ScriptExecutor(Selenium selenium) {
        this.selenium = selenium;
    }

    public ScriptExecutor inContextOfApplicationUnderTest() {
        this.inAppUnderTest = true;
        return this;
    }

    public Object executeScript(String script, Object ... args) {
        return this.executeScript(script, Lists.newArrayList(args));
    }

    public <T> T executeScript(String script, List<Object> args) {
        StringWriter sw = new StringWriter();
        try {
            new JSONWriter(sw).object().key("script").value(script).key("args").value(args).endObject();
        }
        catch (JSONException e) {
            throw new JsonException(e);
        }
        String evalScript = String.format("core.inject.executeScript(%s, %s);", sw, this.inAppUnderTest ? "selenium.browserbot.getCurrentWindow()" : "null");
        return this.evaluateScript(evalScript);
    }

    public <T> T executeAsyncScript(String script, List<Object> args, long timeoutMillis) {
        StringWriter sw = new StringWriter();
        try {
            new JSONWriter(sw).object().key("script").value(script).key("args").value(args).key("timeout").value(timeoutMillis).endObject();
        }
        catch (JSONException e) {
            throw new JsonException(e);
        }
        String evalScript = String.format("core.inject.executeAsyncScript(%s);", sw);
        return this.evaluateScript(evalScript);
    }

    private <T> T evaluateScript(String script) {
        Stopwatch stopWatch = new Stopwatch();
        stopWatch.start();
        String result = this.selenium.getEval(script);
        stopWatch.stop();
        Response response = new JsonToBeanConverter().convert(Response.class, result);
        new ErrorHandler().throwIfResponseFailed(response, stopWatch.elapsedMillis());
        return (T)response.getValue();
    }
}

