/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.internal.Base64Encoder;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ChromeOptions {
    public static final String CAPABILITY = "chromeOptions";
    private File binary;
    private List<String> args = Lists.newArrayList();
    private List<File> extensionFiles = Lists.newArrayList();
    private Map<String, Object> experimentalOptions = Maps.newHashMap();

    public void setBinary(File path) {
        this.binary = Preconditions.checkNotNull(path);
    }

    public void addArguments(String ... arguments) {
        this.addArguments(ImmutableList.copyOf(arguments));
    }

    public void addArguments(List<String> arguments) {
        this.args.addAll(arguments);
    }

    public void addExtensions(File ... paths) {
        this.addExtensions(ImmutableList.copyOf(paths));
    }

    public void addExtensions(List<File> paths) {
        for (File path : paths) {
            Preconditions.checkNotNull(path);
            Preconditions.checkArgument(path.exists(), "%s does not exist", path.getAbsolutePath());
            Preconditions.checkArgument(!path.isDirectory(), "%s is a directory", path.getAbsolutePath());
        }
        this.extensionFiles.addAll(paths);
    }

    public JSONObject toJson() throws IOException, JSONException {
        JSONObject options = new JSONObject(this.experimentalOptions);
        if (this.binary != null) {
            options.put("binary", this.binary.getPath());
        }
        options.put("args", ImmutableList.copyOf(this.args));
        ArrayList<String> extensions = Lists.newArrayListWithExpectedSize(this.extensionFiles.size());
        for (File path : this.extensionFiles) {
            String encoded = new Base64Encoder().encode(Files.toByteArray(path));
            extensions.add(encoded);
        }
        options.put("extensions", extensions);
        return options;
    }

    DesiredCapabilities toCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.chrome();
        capabilities.setCapability(CAPABILITY, this);
        capabilities.setCapability("chrome.switches", this.args);
        if (this.binary != null) {
            capabilities.setCapability("chrome.binary", this.binary.getPath());
        }
        return capabilities;
    }
}

