/*
 * Decompiled with CFR 0.152.
 */
package core;

import commandline.CmdArgsParser;
import commandline.Debug;
import commandline.HaltHandler;
import core.ContextDetection;
import core.Inject;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import report.ReportGenerator;
import xmlparser.XmlConfigReader;

public class Starter {
    private static Map<String, String[]> notRenderedContent_tags = null;
    private static WebDriver driver = null;
    private static HtmlUnitDriver driverFast = null;
    private static List<String> detectedXSSVectors = new LinkedList<String>();
    private static Map<String, List<String>> allowedElements = new HashMap<String, List<String>>();
    private static List<String> allowedProtocols = new LinkedList<String>();
    private static XmlConfigReader xmlConfig;
    private static XmlConfigReader xmlConfigStart;
    private static String reflectionContext;
    private static CmdArgsParser parseArgs;
    private static int operation;
    private static ChromeDriverService service;
    private static boolean IE_enabled;
    private static String usedBrowser;
    private static String injection;
    private static HaltHandler shutdown_hook;
    private static int attempt_num;
    private static Set<String> proposals;
    private static boolean flag;
    private static boolean multi_contexts;

    public static void main(String[] args) {
        Runtime.getRuntime().addShutdownHook(shutdown_hook);
        parseArgs = new CmdArgsParser(args);
        xmlConfig = new XmlConfigReader(parseArgs.getConfigfileName());
        Inject inject = parseArgs.getAttackVectorsRepositoryURL() != null ? new Inject(parseArgs.getAttackVectorsRepositoryURL()) : new Inject();
        Logger logger = Logger.getLogger("");
        logger.setLevel(Level.OFF);
        Starter.setupDriverFast();
        if (parseArgs.getStartConfigfileName() != null) {
            xmlConfigStart = new XmlConfigReader(parseArgs.getStartConfigfileName());
            xmlConfigStart.commonInject(driverFast, null, 0);
        }
        if (!Starter.isReflected()) {
            Debug.printError("ERROR: the parameter is not reflected within the page => no XSS possible!");
            driverFast.quit();
            HaltHandler.quit_nok();
        }
        inject.checkReflectionContext(injection);
        Starter.checkOperation(injection, new Random().nextInt(10000) + "");
        driverFast.quit();
        Starter.setupDriver();
        if (parseArgs.getStartConfigfileName() != null) {
            xmlConfigStart.commonInject(driver, null, 0);
        }
        String init_injection = injection + new Random().nextInt(100000);
        Starter.inject(init_injection);
        Starter.startMaliciousInjection(inject, init_injection);
        boolean weakFilter = inject.getNumberXSS() - inject.getLimitNumberXSS() == 0 && operation == 1;
        ReportGenerator.generateReport(parseArgs.getReportfileName(), parseArgs.getConfigfileName(), usedBrowser, reflectionContext, operation, allowedElements, allowedProtocols, detectedXSSVectors, weakFilter, false, xmlConfig.getMethod());
        Debug.print("\nThe malicious test has finished. A report has been generated: " + parseArgs.getReportfileName());
        driver.quit();
        if (service != null) {
            service.stop();
        }
        HaltHandler.quit_ok();
    }

    private static void setupDriverFast() {
        if (parseArgs.getProxyInfo() != null) {
            String proxy_conf = parseArgs.getProxyInfo();
            Proxy proxy = new Proxy();
            proxy.setHttpProxy(proxy_conf).setFtpProxy(proxy_conf).setSslProxy(proxy_conf);
            DesiredCapabilities cap = new DesiredCapabilities();
            cap.setCapability("proxy", proxy);
            driverFast = new HtmlUnitDriver(cap);
        } else {
            driverFast = new HtmlUnitDriver();
        }
    }

    private static void setupDriver() {
        if (parseArgs.getChromeDriverPath() != null) {
            String path_to_chromedriver = parseArgs.getChromeDriverPath();
            service = new ChromeDriverService.Builder().usingDriverExecutable(new File(path_to_chromedriver)).usingAnyFreePort().build();
            try {
                service.start();
            }
            catch (IOException e) {
                Debug.printError("ERROR: unable to load Chrome server. \n" + e.getMessage());
                HaltHandler.quit_nok();
            }
            DesiredCapabilities capabilities = DesiredCapabilities.chrome();
            capabilities.setCapability("chrome.switches", Arrays.asList("--disable-xss-auditor", "--disable-extensions"));
            if (parseArgs.getProxyInfo() != null) {
                capabilities.setCapability("chrome.switches", Arrays.asList("--proxy-server=" + parseArgs.getProxyInfo()));
            }
            driver = new RemoteWebDriver(service.getUrl(), (Capabilities)capabilities);
            usedBrowser = "Google Chrome";
        } else if (parseArgs.getEnabledIE()) {
            IE_enabled = true;
            if (parseArgs.getProxyInfo() != null) {
                String proxy_conf = parseArgs.getProxyInfo();
                Proxy proxy = new Proxy();
                proxy.setHttpProxy(proxy_conf).setFtpProxy(proxy_conf).setSslProxy(proxy_conf);
                DesiredCapabilities cap = DesiredCapabilities.internetExplorer();
                cap.setCapability("proxy", proxy);
                driver = new InternetExplorerDriver(cap);
            } else {
                String path_to_IEdriver = parseArgs.getIEDriverPath();
                File file = new File(path_to_IEdriver);
                System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
                driver = new InternetExplorerDriver();
            }
            usedBrowser = "Internet Explorer";
        } else {
            if (parseArgs.getProxyInfo() != null) {
                String proxy_conf = parseArgs.getProxyInfo();
                Proxy proxy = new Proxy();
                proxy.setHttpProxy(proxy_conf).setFtpProxy(proxy_conf).setSslProxy(proxy_conf);
                DesiredCapabilities cap = new DesiredCapabilities();
                cap.setCapability("proxy", proxy);
                driver = new FirefoxDriver(cap);
            } else {
                driver = new FirefoxDriver();
            }
            usedBrowser = "Mozilla Firefox";
        }
    }

    private static void startMaliciousInjection(Inject inject, String injection) {
        String attrs;
        String tagName;
        int i;
        List<WebElement> parents = null;
        List<WebElement> elements = null;
        boolean inHtmlComment = false;
        parents = ContextDetection.getParents(injection, IE_enabled);
        elements = ContextDetection.getParentsWithInjectedAttribute(injection, IE_enabled);
        inHtmlComment = ContextDetection.isInHtmlComment(injection);
        if (attempt_num == 0 && !multi_contexts) {
            multi_contexts = parents.size() + elements.size() + (inHtmlComment ? 1 : 0) > 1;
        }
        for (i = 0; i < parents.size() && attempt_num == 0; ++i) {
            tagName = parents.get(i).getTagName();
            attrs = ContextDetection.getAllAttributes(parents.get(i), IE_enabled);
            if (tagName.toLowerCase().equals("script") && parents.get(i).getAttribute("src").equals("")) {
                boolean test = false;
                String scriptContent = "";
                scriptContent = IE_enabled ? (String)((JavascriptExecutor)((Object)driver)).executeScript("return arguments[0].innerHTML;", parents.get(i)) : (String)((JavascriptExecutor)((Object)driver)).executeScript("return arguments[0].textContent;", parents.get(i));
                reflectionContext = !attrs.equals("") ? "<script " + attrs + ">" + scriptContent.replace(injection, "UNTRUSTED DATA") + "</script>" : "<script>" + scriptContent.replace(injection, "UNTRUSTED DATA") + "</script>";
                Pattern pattern = Pattern.compile("\\('[^'\\)]*" + injection + ".*");
                Object match = pattern.matcher(scriptContent);
                if (((Matcher)match).find() && (!multi_contexts || proposals.add("1") && Debug.askForContext("<script>someFunction('UNTRUSTED_DATA');</script>"))) {
                    test = true;
                    Debug.print("Injecting malicious vectors... (1)");
                    inject.injectWithinScriptTag("')", "//");
                    Debug.print("Injecting malicious vectors... (2)");
                    inject.injectWithinScriptTag("\\')", "//");
                    Debug.print("Injecting malicious vectors... (3)");
                    inject.injectTag("</script>");
                    return;
                }
                pattern = Pattern.compile("\\(\"[^\"\\)]*" + injection + ".*");
                match = pattern.matcher(scriptContent);
                if (((Matcher)match).find() && (!multi_contexts || proposals.add("2") && Debug.askForContext("<script>someFunction(\"UNTRUSTED_DATA\");</script>"))) {
                    test = true;
                    Debug.print("Injecting malicious vectors... (1)");
                    inject.injectWithinScriptTag("\")", "//");
                    Debug.print("Injecting malicious vectors... (2)");
                    inject.injectWithinScriptTag("\\\")", "//");
                    Debug.print("Injecting malicious vectors... (3)");
                    inject.injectTag("</script>");
                    return;
                }
                pattern = Pattern.compile("\\([^('|\"|\\))]*" + injection + ".*");
                match = pattern.matcher(scriptContent);
                if (((Matcher)match).find() && (!multi_contexts || proposals.add("3") && Debug.askForContext("<script>someFunction(UNTRUSTED_DATA);</script>"))) {
                    test = true;
                    Debug.print("Injecting malicious vectors... (1)");
                    inject.injectWithinScriptTag(")", "//");
                    Debug.print("Injecting malicious vectors... (2)");
                    inject.injectTag("</script>");
                    return;
                }
                pattern = Pattern.compile("'[^']*" + injection + ".*");
                match = pattern.matcher(scriptContent);
                int f = ((Matcher)match).find() ? 1 : 0;
                pattern = Pattern.compile("\\('[^'\\)]*" + injection + ".*");
                match = pattern.matcher(scriptContent);
                if (!((Matcher)match).find() && f != 0 && (!multi_contexts || proposals.add("4") && Debug.askForContext("<script>var variable = 'UNTRUSTED_DATA';</script>"))) {
                    test = true;
                    Debug.print("Injecting malicious vectors... (1)");
                    inject.injectWithinScriptTag("'", "//");
                    Debug.print("Injecting malicious vectors... (2)");
                    inject.injectWithinScriptTag("\\')", "//");
                    Debug.print("Injecting malicious vectors... (3)");
                    inject.injectTag("</script>");
                    return;
                }
                pattern = Pattern.compile("[^\\(]\"[^\"]*" + injection + ".*");
                match = pattern.matcher(scriptContent);
                if (((Matcher)match).find() && (!multi_contexts || proposals.add("5") && Debug.askForContext("<script>var variable = \"UNTRUSTED_DATA\";</script>"))) {
                    test = true;
                    Debug.print("Injecting malicious vectors... (1)");
                    inject.injectWithinScriptTag("\"", "//");
                    Debug.print("Injecting malicious vectors... (2)");
                    inject.injectWithinScriptTag("\\\"", "//");
                    Debug.print("Injecting malicious vectors... (3)");
                    inject.injectTag("</script>");
                    return;
                }
                pattern = Pattern.compile("//[^\\r?\\n]*" + injection + ".*");
                match = pattern.matcher(scriptContent);
                if (((Matcher)match).find() && (!multi_contexts || proposals.add("6") && Debug.askForContext("<script> // UNTRUSTED_DATA</script>"))) {
                    test = true;
                    Debug.print("Injecting malicious vectors... (1)");
                    inject.injectWithinScriptTag("\r\n0", null);
                    Debug.print("Injecting malicious vectors... (2)");
                    inject.injectTag("</script>");
                    return;
                }
                pattern = Pattern.compile("/\\*[^\\*/]*" + injection + ".*");
                match = pattern.matcher(scriptContent);
                if (((Matcher)match).find() && (!multi_contexts || proposals.add("7") && Debug.askForContext("<script> /* UNTRUSTED_DATA */</script>"))) {
                    test = true;
                    Debug.print("Injecting malicious vectors... (1)");
                    inject.injectWithinScriptTag("*/\r\n", "/*");
                    Debug.print("Injecting malicious vectors... (2)");
                    inject.injectTag("</script>");
                    return;
                }
                if (test || proposals.size() != 0 || multi_contexts && (!proposals.add("8") || !Debug.askForContext("<script> UNTRUSTED_DATA </script>"))) continue;
                Debug.print("Injecting malicious vectors...");
                inject.injectWithinScriptTag(null, "//");
                return;
            }
            reflectionContext = !attrs.equals("") ? "<" + tagName + " " + attrs + ">UNTRUSTED DATA</" + tagName + ">" : "<" + tagName + ">UNTRUSTED DATA</" + tagName + ">";
            if (notRenderedContent_tags == null) {
                Starter.populateNotRendered();
            }
            if (notRenderedContent_tags.containsKey(tagName.toLowerCase())) {
                for (String k : notRenderedContent_tags.keySet()) {
                    if (!tagName.toLowerCase().equals(k)) continue;
                    String[] attributes = notRenderedContent_tags.get(k);
                    if (attributes == null) {
                        if (multi_contexts && (!proposals.add(k) || !Debug.askForContext("<" + k + "> UNTRUSTED_DATA </" + k + ">"))) continue;
                        Debug.print("Injecting malicious vectors... (1)");
                        inject.injectTag("</" + k + ">");
                        Debug.print("Injecting malicious vectors... (2)");
                        inject.injectScriptTag("</" + k + ">");
                        return;
                    }
                    for (String attr : attributes) {
                        if (parents.get(i).getAttribute(attr) == null || multi_contexts && (!proposals.add(k) || !Debug.askForContext("<" + k + "> UNTRUSTED_DATA </" + k + ">"))) continue;
                        Debug.print("Injecting malicious vectors... (1)");
                        inject.injectTag("</" + k + ">");
                        Debug.print("Injecting malicious vectors... (2)");
                        inject.injectScriptTag("</" + k + ">");
                        return;
                    }
                }
                continue;
            }
            if (multi_contexts && (!proposals.add("9") || !Debug.askForContext("<HTMLtag> UNTRUSTED_DATA </HTMLtag>"))) continue;
            Debug.print("Injecting malicious vectors...");
            inject.injectTag(null);
            if (allowedElements.keySet().contains("script")) {
                Debug.print("Injecting malicious vectors through <script>...");
                inject.injectScriptTag(null);
            }
            return;
        }
        if (!flag) {
            inject.injectDummyAttribute();
            flag = true;
        }
        if (elements.size() != 0 && attempt_num == 0) {
            Starter.inject(injection);
        }
        elements = ContextDetection.getParentsWithInjectedAttribute(injection, IE_enabled);
        for (i = 0; i < elements.size(); ++i) {
            tagName = elements.get(i).getTagName();
            attrs = ContextDetection.getAttributesFromInjected(elements.get(i), injection, IE_enabled);
            String injected_attribute = ContextDetection.getInjectedAttribute();
            if (injected_attribute == null || elements.get(i).getAttribute(injected_attribute) == null) break;
            reflectionContext = "<" + tagName + " " + attrs + " " + injected_attribute + "=\"" + elements.get(i).getAttribute(injected_attribute).replace(injection, "UNTRUSTED DATA") + "\">[...]</" + tagName + ">";
            boolean test = false;
            String linkText = elements.get(i).getText();
            String injected_attribute_content = elements.get(i).getAttribute(injected_attribute);
            if (injected_attribute.equals("src") && !tagName.equals("img")) {
                if (!multi_contexts || proposals.add("10") && Debug.askForContext("<HTMLtag src=\"UNTRUSTED_DATA\">")) {
                    test = true;
                    if (inject.areAttributesBreakable()) {
                        Debug.print("Injecting malicious vectors... (1)");
                    } else {
                        Debug.print("Injecting malicious vectors... ");
                    }
                    inject.injectUntrustedURL_src();
                }
            } else if (injected_attribute.equals("href") && !test) {
                if (!multi_contexts || proposals.add("11") && Debug.askForContext("<a href=\"UNTRUSTED_DATA\">")) {
                    test = true;
                    if (inject.areAttributesBreakable()) {
                        Debug.print("Injecting malicious vectors... (1)");
                    } else {
                        Debug.print("Injecting malicious vectors... ");
                    }
                    inject.injectUntrustedURL_href(linkText);
                }
            } else if (injected_attribute.equals("style") && IE_enabled && !test) {
                if (!multi_contexts || proposals.add("12") && Debug.askForContext("<HTMLtag style=\"UNTRUSTED_DATA\">")) {
                    test = true;
                    if (inject.areAttributesBreakable()) {
                        Debug.print("Injecting malicious vectors... (1)");
                    } else {
                        Debug.print("Injecting malicious vectors... ");
                    }
                    inject.injectExpression();
                }
            } else if (injected_attribute.startsWith("on") && !test) {
                boolean z = false;
                Pattern pattern = Pattern.compile("'[^']*" + injection + ".*");
                Matcher match = pattern.matcher(injected_attribute_content);
                if (match.find()) {
                    z = true;
                    if (injected_attribute.equals("onclick")) {
                        if (!multi_contexts || proposals.add("13") && Debug.askForContext("<HTMLtag onclick=\"var z = 'UNTRUSTED_DATA';\">")) {
                            if (inject.areAttributesBreakable()) {
                                Debug.print("Injecting malicious vectors... (1)");
                            } else {
                                Debug.print("Injecting malicious vectors... ");
                            }
                            inject.injectWithinEventHandler("'");
                            test = true;
                        } else if (!multi_contexts || proposals.add("14") && Debug.askForContext("<HTMLtag eventHandler=\"var z = 'UNTRUSTED_DATA';\">")) {
                            if (inject.areAttributesBreakable()) {
                                Debug.print("Injecting malicious vectors... (1)");
                            } else {
                                Debug.print("Injecting malicious vectors... ");
                            }
                            inject.injectWithinScriptTag("'", "//");
                            test = true;
                        }
                    }
                }
                if ((match = (pattern = Pattern.compile("\"[^\"]*" + injection + ".*")).matcher(injected_attribute_content)).find()) {
                    z = true;
                    if (injected_attribute.equals("onclick")) {
                        if (!multi_contexts || proposals.add("15") && Debug.askForContext("<HTMLtag onclick='var z = \"UNTRUSTED_DATA\";'>")) {
                            if (inject.areAttributesBreakable()) {
                                Debug.print("Injecting malicious vectors... (1)");
                            } else {
                                Debug.print("Injecting malicious vectors... ");
                            }
                            inject.injectWithinEventHandler("\"");
                            test = true;
                        } else if (!multi_contexts || proposals.add("16") && Debug.askForContext("<HTMLtag eventHandler='var z = \"UNTRUSTED_DATA\";'>")) {
                            if (inject.areAttributesBreakable()) {
                                Debug.print("Injecting malicious vectors... (1)");
                            } else {
                                Debug.print("Injecting malicious vectors... ");
                            }
                            inject.injectWithinScriptTag("\"", "//");
                            test = true;
                        }
                    }
                }
                if (!z) {
                    if (injected_attribute.equals("onclick")) {
                        if (!multi_contexts || proposals.add("17") && Debug.askForContext("<HTMLtag onclick=\"UNTRUSTED_DATA\">")) {
                            if (inject.areAttributesBreakable()) {
                                Debug.print("Injecting malicious vectors... (1)");
                            } else {
                                Debug.print("Injecting malicious vectors... ");
                            }
                            inject.injectWithinEventHandler("0");
                            test = true;
                        }
                    } else if (!multi_contexts || proposals.add("18") && Debug.askForContext("<HTMLtag eventHandler=\"UNTRUSTED_DATA\">")) {
                        if (inject.areAttributesBreakable()) {
                            Debug.print("Injecting malicious vectors... (1)");
                        } else {
                            Debug.print("Injecting malicious vectors... ");
                        }
                        inject.injectWithinScriptTag("0", "//");
                        test = true;
                    }
                }
            }
            if (inject.areAttributesBreakable()) {
                boolean tmp = false;
                if (tagName.equals("img")) {
                    String path_to_real_image = "http://www.sneaked.net/Images/12300.png";
                    if (test) {
                        Debug.print("Injecting malicious vectors... (2)");
                        inject.injectAttribute(path_to_real_image);
                    } else if (!multi_contexts || proposals.add("19") && Debug.askForContext("<img src=\"UNTRUSTED_DATA\" />")) {
                        Debug.print("Injecting malicious vectors... (1)");
                        inject.injectAttribute(path_to_real_image);
                        tmp = true;
                    }
                } else if (test) {
                    Debug.print("Injecting malicious vectors... (2)");
                    inject.injectAttribute(null);
                } else if (!multi_contexts || proposals.add("20") && Debug.askForContext("<HTMLtag attribute=\"UNTRUSTED_DATA\">")) {
                    Debug.print("Injecting malicious vectors... (1)");
                    inject.injectAttribute(null);
                    tmp = true;
                }
                if (!test && !tmp) continue;
                if (test) {
                    Debug.print("Injecting malicious vectors... (3)");
                } else {
                    Debug.print("Injecting malicious vectors... (2)");
                }
                if (tagName.equals("iframe")) {
                    inject.breakElement("</iframe>");
                } else {
                    inject.breakElement(null);
                }
                return;
            }
            if (!test) continue;
            return;
        }
        if (inHtmlComment) {
            reflectionContext = "<!-- UNTRUSTED DATA -->";
            if (!multi_contexts || proposals.add("21") && Debug.askForContext("<!-- UNTRUSTED_DATA -->")) {
                Debug.print("Injecting malicious vectors... (1)");
                inject.injectTag("-->");
                Debug.print("Injecting malicious vectors... (2)");
                inject.injectScriptTag("-->");
                return;
            }
        }
        if ((multi_contexts || elements != null && elements.size() == 0 || parents != null && parents.size() == 0) && attempt_num == 0) {
            ++attempt_num;
            String css_injection = Starter.randomColor();
            Starter.inject(css_injection);
            Starter.startMaliciousInjection(inject, css_injection);
            return;
        }
        if (multi_contexts) {
            Debug.printError("\nINFO: no more reflection contexts available...");
            HaltHandler.quit_ok();
        }
    }

    public static void inject(String injection) {
        xmlConfig.commonInject(driver, injection, parseArgs.getDelayInterval());
    }

    public static void injectFast(String injection) {
        xmlConfig.commonInject(driverFast, injection, parseArgs.getDelayInterval());
    }

    private static boolean isReflected() {
        Starter.injectFast(injection);
        if (driverFast.getPageSource().contains(injection) || driverFast.getPageSource().contains(injection.toLowerCase())) {
            return true;
        }
        injection = "" + new Random().nextInt(100000);
        Starter.injectFast(injection);
        if (driverFast.getPageSource().contains(injection) || driverFast.getPageSource().contains(injection.toLowerCase())) {
            return true;
        }
        injection = "http://www.test.com";
        Starter.injectFast(injection);
        if (driverFast.getPageSource().contains(injection) || driverFast.getPageSource().contains(injection.toLowerCase())) {
            return true;
        }
        injection = "test@gmail.com";
        Starter.injectFast(injection);
        return driverFast.getPageSource().contains(injection) || driverFast.getPageSource().contains(injection.toLowerCase());
    }

    private static void checkOperation(String injection1, String injection2) {
        Starter.injectFast(injection2);
        operation = driverFast.getPageSource().contains(injection1) && driverFast.getPageSource().contains(injection2) ? 1 : 2;
    }

    private static void populateNotRendered() {
        notRenderedContent_tags = new HashMap<String, String[]>();
        notRenderedContent_tags.put("marquee", null);
        notRenderedContent_tags.put("style", null);
        notRenderedContent_tags.put("xmp", null);
        notRenderedContent_tags.put("iframe", null);
        notRenderedContent_tags.put("noscript", null);
        notRenderedContent_tags.put("textarea", null);
        notRenderedContent_tags.put("title", null);
        notRenderedContent_tags.put("script", new String[]{"src"});
    }

    public static String randomColor() {
        String[] colors = new String[]{"aqua", "black", "blue", "fuchsia", "gray", "green", "lime", "maroon", "navy", "olive", "purple", "red", "silver", "teal", "white", "yellow"};
        return colors[(int)(Math.random() * (double)colors.length)];
    }

    public static String getCurrentBrowser() {
        return usedBrowser;
    }

    public static WebDriver getDriver() {
        return driver == null ? null : driver;
    }

    public static HtmlUnitDriver getDriverFast() {
        return driverFast == null ? null : driverFast;
    }

    public static List<String> getDetectedXSSVector() {
        return detectedXSSVectors;
    }

    public static void addDetectedXSSVector(String xss) {
        detectedXSSVectors.add(xss);
    }

    public static void setAllowedProtocols(LinkedList<String> allowedSchemes) {
        allowedProtocols = allowedSchemes;
    }

    public static void setAllowedElements(HashMap<String, List<String>> allowedHTMLElements) {
        allowedElements = allowedHTMLElements;
    }

    public static int getOperation() {
        return operation;
    }

    public static ChromeDriverService getChromeService() {
        return service;
    }

    public static void refreshDriver() {
        if (driver != null) {
            driver.quit();
        }
        if (service != null) {
            service.stop();
        }
        Starter.setupDriver();
    }

    public static CmdArgsParser getParsedArgs() {
        return parseArgs;
    }

    public static Thread getHaltHandler() {
        return shutdown_hook;
    }

    public static void brokenPage() {
        if (reflectionContext != null) {
            ReportGenerator.generateReport(parseArgs.getReportfileName(), parseArgs.getConfigfileName(), usedBrowser, reflectionContext, operation, allowedElements, allowedProtocols, detectedXSSVectors, false, true, xmlConfig.getMethod());
            Debug.print("\nA report has been generated: " + parseArgs.getReportfileName());
        }
        if (driverFast != null) {
            driverFast.quit();
        }
        if (driver != null) {
            driver.quit();
        }
        if (service != null) {
            service.stop();
        }
        HaltHandler.quit_nok();
    }

    public static void forceQuit() {
        if (reflectionContext != null) {
            ReportGenerator.generateReport(parseArgs.getReportfileName(), parseArgs.getConfigfileName(), usedBrowser, reflectionContext, operation, allowedElements, allowedProtocols, detectedXSSVectors, false, false, xmlConfig.getMethod());
            Debug.print("\n\nJust broken the tested XSS filter! \nA report has been generated: " + parseArgs.getReportfileName());
        }
        if (driverFast != null) {
            driverFast.quit();
        }
        if (driver != null) {
            driver.quit();
        }
        if (service != null) {
            service.stop();
        }
        HaltHandler.quit_ok();
    }

    static {
        operation = 0;
        injection = new BigInteger(130, new SecureRandom()).toString(32);
        shutdown_hook = new HaltHandler();
        attempt_num = 0;
        proposals = new HashSet<String>();
        flag = false;
        multi_contexts = false;
    }
}

