/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ScriptPreProcessor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;

public class IEConditionalCompilationScriptPreProcessor
implements ScriptPreProcessor {
    private static final Pattern CC_VARIABLE_PATTERN = Pattern.compile("@\\w+|'[^']*'|\"[^\"]*\"");
    private static final Pattern SET_PATTERN = Pattern.compile("@set\\s+(@\\w+)(\\s*=\\s*[\\d\\.]+)");
    private static final Pattern C_VARIABLE_PATTERN = Pattern.compile("(@_\\w+)|'[^']*'|\"[^\"]*\"");
    private static final Pattern CC_PROCESS_PATTERN = Pattern.compile("/\\*@end");
    private static final Pattern IF1_PATTERN = Pattern.compile("@if\\s*\\(([^\\)]+)\\)");
    private static final Pattern IF2_PATTERN = Pattern.compile("@elif\\s*\\(([^\\)]+)\\)");
    private static final Pattern IF3_PATTERN = Pattern.compile("@else");
    private static final Pattern IF4_PATTERN = Pattern.compile("(/\\*)?@end");
    private static final String CC_VARIABLE_PREFIX = "htmlunit_cc_variable_";
    private final Set<String> setVariables_ = new HashSet<String>();

    public String preProcess(HtmlPage htmlPage, String sourceCode, String sourceName, int lineNumber, HtmlElement htmlElement) {
        int startPos = IEConditionalCompilationScriptPreProcessor.indexOf(sourceCode, "/*@cc_on", 0);
        if (startPos == -1) {
            return sourceCode;
        }
        int endPos = IEConditionalCompilationScriptPreProcessor.indexOf(sourceCode, "@*/", startPos);
        if (endPos == -1) {
            return sourceCode;
        }
        StringBuilder sb = new StringBuilder();
        if (startPos > 0) {
            sb.append(sourceCode.substring(0, startPos));
        }
        BrowserVersion browserVersion = htmlPage.getWebClient().getBrowserVersion();
        String body = sourceCode.substring(startPos + 8, endPos);
        sb.append(this.processConditionalCompilation(body, browserVersion));
        if (endPos < sourceCode.length() - 3) {
            String remaining = sourceCode.substring(endPos + 3);
            int nextStart = remaining.indexOf("/*@");
            int nextEnd = remaining.indexOf("@*/", nextStart + 3);
            while (nextStart >= 0 && nextEnd > 0) {
                sb.append(remaining.substring(0, nextStart));
                String nextBody = remaining.substring(nextStart + 3, nextEnd);
                sb.append(this.processConditionalCompilation(nextBody, browserVersion));
                remaining = remaining.substring(nextEnd + 3);
                nextStart = remaining.indexOf("/*@");
                nextEnd = remaining.indexOf("@*/", nextStart + 3);
            }
            sb.append(remaining);
        }
        return sb.toString();
    }

    private String processConditionalCompilation(String precompilationBody, BrowserVersion browserVersion) {
        String body = precompilationBody;
        if (body.startsWith("cc_on")) {
            body = body.substring(5);
        }
        body = "@" + body;
        if ((body = IEConditionalCompilationScriptPreProcessor.processIfs(body)).startsWith("@")) {
            body = body.substring(1);
        }
        body = CC_PROCESS_PATTERN.matcher(body).replaceAll("");
        body = this.replaceCompilationVariables(body, browserVersion);
        body = this.processSet(body);
        body = this.replaceCustomCompilationVariables(body);
        return body;
    }

    private String replaceCustomCompilationVariables(String body) {
        Matcher m = CC_VARIABLE_PATTERN.matcher(body);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String match = m.group();
            if (match.startsWith("@")) {
                m.appendReplacement(sb, this.replaceOneCustomCompilationVariable(match));
                continue;
            }
            m.appendReplacement(sb, match);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String replaceOneCustomCompilationVariable(String variable) {
        if (this.setVariables_.contains(variable)) {
            return CC_VARIABLE_PREFIX + variable.substring(1);
        }
        return "NaN";
    }

    private String processSet(String body) {
        Matcher m = SET_PATTERN.matcher(body);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            this.setVariables_.add(m.group(1));
            m.appendReplacement(sb, CC_VARIABLE_PREFIX + m.group(1).substring(1) + m.group(2) + ";");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String processIfs(String code) {
        code = IF1_PATTERN.matcher(code).replaceAll("if ($1) {");
        code = IF2_PATTERN.matcher(code).replaceAll("} else if ($1) {");
        code = IF3_PATTERN.matcher(code).replaceAll("} else {");
        code = IF4_PATTERN.matcher(code).replaceAll("}");
        return code;
    }

    String replaceCompilationVariables(String source, BrowserVersion browserVersion) {
        Matcher m = C_VARIABLE_PATTERN.matcher(source);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String match = m.group();
            if (match.startsWith("@")) {
                m.appendReplacement(sb, IEConditionalCompilationScriptPreProcessor.replaceOneVariable(match, browserVersion));
                continue;
            }
            m.appendReplacement(sb, match);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String replaceOneVariable(String variable, BrowserVersion browserVersion) {
        Object[] varNaN = new String[]{"@_win16", "@_mac", "@_alpha", "@_mc680x0", "@_PowerPC", "@_debug", "@_fast"};
        Object[] varTrue = new String[]{"@_win32", "@_x86", "@_jscript"};
        if (ArrayUtils.contains(varTrue, variable)) {
            return "true";
        }
        if ("@_jscript_version".equals(variable)) {
            if (browserVersion.getBrowserVersionNumeric() <= 6.0f) {
                return "5.6";
            }
            if (browserVersion.getBrowserVersionNumeric() == 7.0f) {
                return "5.7";
            }
            return "5.8";
        }
        if ("@_jscript_build".equals(variable)) {
            if (browserVersion.getBrowserVersionNumeric() <= 6.0f) {
                return "6626";
            }
            if (browserVersion.getBrowserVersionNumeric() == 7.0f) {
                return "5730";
            }
            return "18702";
        }
        if (ArrayUtils.contains(varNaN, variable)) {
            return "NaN";
        }
        return variable;
    }

    private static int indexOf(String sourceCode, String str, int fromIndex) {
        PARSING_STATUS parsingStatus = PARSING_STATUS.NORMAL;
        char stringChar = '\u0000';
        block7: for (int i = 0; i < sourceCode.length(); ++i) {
            if ((parsingStatus == PARSING_STATUS.NORMAL || parsingStatus == PARSING_STATUS.IN_MULTI_LINE_COMMENT) && i >= fromIndex && i + str.length() <= sourceCode.length() && sourceCode.substring(i, i + str.length()).equals(str)) {
                return i;
            }
            char ch = sourceCode.charAt(i);
            switch (ch) {
                case '/': {
                    char nextCh;
                    if (parsingStatus == PARSING_STATUS.NORMAL && i + 1 < sourceCode.length()) {
                        nextCh = sourceCode.charAt(i + 1);
                        if (nextCh == '/') {
                            parsingStatus = PARSING_STATUS.IN_SINGLE_LINE_COMMENT;
                            continue block7;
                        }
                        if (nextCh == '*') {
                            parsingStatus = PARSING_STATUS.IN_MULTI_LINE_COMMENT;
                            continue block7;
                        }
                        stringChar = ch;
                        parsingStatus = PARSING_STATUS.IN_REG_EXP;
                        continue block7;
                    }
                    if (parsingStatus != PARSING_STATUS.IN_REG_EXP || ch != stringChar) continue block7;
                    stringChar = '\u0000';
                    parsingStatus = PARSING_STATUS.NORMAL;
                    continue block7;
                }
                case '*': {
                    char nextCh;
                    if (parsingStatus != PARSING_STATUS.IN_MULTI_LINE_COMMENT || i + 1 >= sourceCode.length() || (nextCh = sourceCode.charAt(i + 1)) != '/') continue block7;
                    parsingStatus = PARSING_STATUS.NORMAL;
                    continue block7;
                }
                case '\n': {
                    if (parsingStatus != PARSING_STATUS.IN_SINGLE_LINE_COMMENT) continue block7;
                    parsingStatus = PARSING_STATUS.NORMAL;
                    continue block7;
                }
                case '\"': 
                case '\'': {
                    if (parsingStatus == PARSING_STATUS.NORMAL) {
                        stringChar = ch;
                        parsingStatus = PARSING_STATUS.IN_STRING;
                        continue block7;
                    }
                    if (parsingStatus != PARSING_STATUS.IN_STRING || ch != stringChar) continue block7;
                    stringChar = '\u0000';
                    parsingStatus = PARSING_STATUS.NORMAL;
                    continue block7;
                }
                case '\\': {
                    if (parsingStatus != PARSING_STATUS.IN_STRING) continue block7;
                    if (i + 3 < sourceCode.length() && sourceCode.charAt(i + 1) == 'x') {
                        char character;
                        char ch1 = Character.toUpperCase(sourceCode.charAt(i + 2));
                        char ch2 = Character.toUpperCase(sourceCode.charAt(i + 3));
                        if ((ch1 < '0' || ch1 > '9') && (ch1 < 'A' || ch1 > 'F') || (ch2 < '0' || ch2 > '9') && (ch2 < 'A' || ch2 > 'F') || (character = (char)Integer.parseInt(sourceCode.substring(i + 2, i + 4), 16)) < ' ') continue block7;
                        i += 3;
                        continue block7;
                    }
                    if (i + 1 >= sourceCode.length()) continue block7;
                    ++i;
                    continue block7;
                }
            }
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PARSING_STATUS {
        NORMAL,
        IN_MULTI_LINE_COMMENT,
        IN_SINGLE_LINE_COMMENT,
        IN_STRING,
        IN_REG_EXP;

    }
}

