/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlNoFrames;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.EventHandler;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLScriptElement;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlScript
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(HtmlScript.class);
    public static final String TAG_NAME = "script";
    private static final String SLASH_SLASH_COLON = "//:";

    HtmlScript(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public final String getCharsetAttribute() {
        return this.getAttribute("charset");
    }

    public final String getTypeAttribute() {
        return this.getAttribute("type");
    }

    public final String getLanguageAttribute() {
        return this.getAttribute("language");
    }

    public final String getSrcAttribute() {
        return this.getAttribute("src");
    }

    public final String getEventAttribute() {
        return this.getAttribute("event");
    }

    public final String getHtmlForAttribute() {
        return this.getAttribute("for");
    }

    public final String getDeferAttribute() {
        return this.getAttribute("defer");
    }

    protected boolean isDeferred() {
        return this.getDeferAttribute() != ATTRIBUTE_NOT_DEFINED;
    }

    @Override
    public boolean mayBeDisplayed() {
        return false;
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        boolean ie;
        String oldValue = this.getAttributeNS(namespaceURI, qualifiedName);
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue);
        if (namespaceURI == null && "src".equals(qualifiedName) && ((ie = this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_5)) || oldValue.length() == 0 && this.getFirstChild() == null)) {
            this.executeScriptIfNeeded();
        }
    }

    @Override
    protected void onAllChildrenAddedToPage(boolean postponed) {
        if (this.getOwnerDocument() instanceof XmlPage) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Script node added: " + this.asXml());
        }
        PostponedAction action = new PostponedAction(this.getPage()){

            public void execute() {
                boolean ie = HtmlScript.this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_6);
                if (ie) {
                    if (!HtmlScript.this.isDeferred()) {
                        if (!HtmlScript.SLASH_SLASH_COLON.equals(HtmlScript.this.getSrcAttribute())) {
                            HtmlScript.this.setAndExecuteReadyState("loading");
                            HtmlScript.this.executeScriptIfNeeded();
                            HtmlScript.this.setAndExecuteReadyState("loaded");
                        } else {
                            HtmlScript.this.setAndExecuteReadyState("complete");
                            HtmlScript.this.executeScriptIfNeeded();
                        }
                    }
                } else {
                    HtmlScript.this.executeScriptIfNeeded();
                }
            }
        };
        if (postponed && StringUtils.isBlank(this.getTextContent())) {
            JavaScriptEngine engine = this.getPage().getWebClient().getJavaScriptEngine();
            engine.addPostponedAction(action);
        } else {
            try {
                action.execute();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    private void executeInlineScriptIfNeeded() {
        if (!this.isExecutionNeeded()) {
            return;
        }
        String src = this.getSrcAttribute();
        if (src != DomElement.ATTRIBUTE_NOT_DEFINED) {
            return;
        }
        DomCharacterData textNode = (DomCharacterData)this.getFirstChild();
        String forr = this.getHtmlForAttribute();
        String event = this.getEventAttribute();
        if (event.endsWith("()")) {
            event = event.substring(0, event.length() - 2);
        }
        boolean ie = this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_7);
        String scriptCode = textNode.getData();
        if (ie && event != ATTRIBUTE_NOT_DEFINED && forr != ATTRIBUTE_NOT_DEFINED) {
            if ("window".equals(forr)) {
                Window window = (Window)this.getPage().getEnclosingWindow().getScriptObject();
                EventHandler function = new EventHandler(this, event, scriptCode);
                window.jsxFunction_attachEvent(event, function);
            } else {
                try {
                    Object elt = ((HtmlPage)this.getPage()).getHtmlElementById(forr);
                    ((HtmlElement)elt).setEventHandler(event, scriptCode);
                }
                catch (ElementNotFoundException e) {
                    LOG.warn("<script for='" + forr + "' ...>: no element found with id \"" + forr + "\". Ignoring.");
                }
            }
        } else if (forr == ATTRIBUTE_NOT_DEFINED || "onload".equals(event)) {
            String url = this.getPage().getWebResponse().getWebRequest().getUrl().toExternalForm();
            int line1 = this.getStartLineNumber();
            int line2 = this.getEndLineNumber();
            int col1 = this.getStartColumnNumber();
            int col2 = this.getEndColumnNumber();
            String desc = "script in " + url + " from (" + line1 + ", " + col1 + ") to (" + line2 + ", " + col2 + ")";
            ((HtmlPage)this.getPage()).executeJavaScriptIfPossible(scriptCode, desc, line1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void executeScriptIfNeeded() {
        if (!this.isExecutionNeeded()) {
            return;
        }
        HtmlPage page = (HtmlPage)this.getPage();
        BrowserVersion browser = page.getWebClient().getBrowserVersion();
        String src = this.getSrcAttribute();
        if (src.equals(SLASH_SLASH_COLON)) {
            return;
        }
        if (src != ATTRIBUTE_NOT_DEFINED) {
            if (src.startsWith("javascript:")) {
                String code;
                int len;
                if (!browser.hasFeature(BrowserVersionFeatures.HTMLSCRIPT_SRC_JAVASCRIPT) || (len = (code = StringUtils.removeStart(src, "javascript:").trim()).length()) <= 2 || (code.charAt(0) != '\'' || code.charAt(len - 1) != '\'') && (code.charAt(0) != '\"' || code.charAt(len - 1) != '\"')) return;
                code = code.substring(1, len - 1);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Executing JavaScript: " + code);
                }
                page.executeJavaScriptIfPossible(code, code, this.getStartLineNumber());
                return;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Loading external JavaScript: " + src);
                }
                try {
                    HtmlPage.JavaScriptLoadResult result = page.loadExternalJavaScriptFile(src, this.getCharsetAttribute());
                    if (result == HtmlPage.JavaScriptLoadResult.SUCCESS) {
                        this.executeEventIfBrowserHasFeature("load", BrowserVersionFeatures.EVENT_ONLOAD_EXTERNAL_JAVASCRIPT);
                        return;
                    }
                    if (result != HtmlPage.JavaScriptLoadResult.DOWNLOAD_ERROR) return;
                    this.executeEventIfBrowserHasFeature("error", BrowserVersionFeatures.EVENT_ONERROR_EXTERNAL_JAVASCRIPT);
                    return;
                }
                catch (FailingHttpStatusCodeException e) {
                    this.executeEventIfBrowserHasFeature("error", BrowserVersionFeatures.EVENT_ONERROR_EXTERNAL_JAVASCRIPT);
                    throw e;
                }
            }
        } else {
            if (this.getFirstChild() == null) return;
            this.executeInlineScriptIfNeeded();
        }
    }

    private void executeEventIfBrowserHasFeature(String type, BrowserVersionFeatures feature) {
        if (this.getPage().getWebClient().getBrowserVersion().hasFeature(feature)) {
            HTMLScriptElement script = (HTMLScriptElement)this.getScriptObject();
            Event event = new Event(this, type);
            script.executeEvent(event);
        }
    }

    private boolean isExecutionNeeded() {
        SgmlPage page = this.getPage();
        if (!this.isDirectlyAttachedToPage()) {
            return false;
        }
        if (!page.getWebClient().isJavaScriptEnabled()) {
            return false;
        }
        if (page instanceof HtmlPage && ((HtmlPage)page).isParsingHtmlSnippet()) {
            return false;
        }
        for (DomNode o = this; o != null; o = o.getParentNode()) {
            if (!(o instanceof HtmlInlineFrame) && !(o instanceof HtmlNoFrames)) continue;
            return false;
        }
        if (page.getEnclosingWindow() != null && page.getEnclosingWindow().getEnclosedPage() != page) {
            return false;
        }
        if (!this.isJavaScript(this.getTypeAttribute(), this.getLanguageAttribute())) {
            String t = this.getTypeAttribute();
            String l = this.getLanguageAttribute();
            LOG.warn("Script is not JavaScript (type: " + t + ", language: " + l + "). Skipping execution.");
            return false;
        }
        DomNode root = this;
        while (root.getParentNode() != null) {
            root = root.getParentNode();
        }
        return root == this.getPage();
    }

    boolean isJavaScript(String typeAttribute, String languageAttribute) {
        if (StringUtils.isNotEmpty(typeAttribute)) {
            if ("text/javascript".equalsIgnoreCase(typeAttribute) || "text/ecmascript".equalsIgnoreCase(typeAttribute)) {
                return true;
            }
            boolean appJavascriptSupported = this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLSCRIPT_APPLICATION_JAVASCRIPT);
            return appJavascriptSupported && ("application/javascript".equalsIgnoreCase(typeAttribute) || "application/ecmascript".equalsIgnoreCase(typeAttribute) || "application/x-javascript".equalsIgnoreCase(typeAttribute));
        }
        if (StringUtils.isNotEmpty(languageAttribute)) {
            return StringUtils.startsWithIgnoreCase(languageAttribute, "javascript");
        }
        return true;
    }

    protected void setAndExecuteReadyState(String state) {
        if (this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONREADY_STATE_CHANGE)) {
            this.setReadyState(state);
            HTMLScriptElement script = (HTMLScriptElement)this.getScriptObject();
            Event event = new Event(this, "readystatechange");
            script.executeEvent(event);
        }
    }

    @Override
    public String asText() {
        return "";
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }

    @Override
    protected void printChildrenAsXml(String indent, PrintWriter printWriter) {
        DomCharacterData textNode = (DomCharacterData)this.getFirstChild();
        if (textNode != null) {
            printWriter.println("//<![CDATA[");
            printWriter.println(textNode.getData());
            printWriter.println("//]]>");
        }
    }
}

