/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.xpath.XPathUtils;

public abstract class DomNamespaceNode
extends DomNode {
    private final String namespaceURI_;
    private String qualifiedName_;
    private final String localName_;
    private String prefix_;

    protected DomNamespaceNode(String namespaceURI, String qualifiedName, SgmlPage page) {
        super(page);
        WebAssert.notNull("qualifiedName", qualifiedName);
        this.qualifiedName_ = qualifiedName;
        if (qualifiedName.indexOf(58) != -1) {
            this.namespaceURI_ = namespaceURI;
            int colonPosition = this.qualifiedName_.indexOf(58);
            this.localName_ = this.qualifiedName_.substring(colonPosition + 1);
            this.prefix_ = this.qualifiedName_.substring(0, colonPosition);
        } else {
            this.namespaceURI_ = namespaceURI;
            this.localName_ = this.qualifiedName_;
            this.prefix_ = null;
        }
    }

    public String getNamespaceURI() {
        return this.namespaceURI_;
    }

    public String getLocalName() {
        boolean caseSensitive = this.getPage().hasCaseSensitiveTagNames();
        if (!caseSensitive && XPathUtils.isProcessingXPath()) {
            return this.localName_.toLowerCase();
        }
        return this.localName_;
    }

    public String getPrefix() {
        return this.prefix_;
    }

    public void setPrefix(String prefix) {
        this.prefix_ = prefix;
        if (this.prefix_ != null && this.localName_ != null) {
            this.qualifiedName_ = this.prefix_ + ":" + this.localName_;
        }
    }

    public String getQualifiedName() {
        return this.qualifiedName_;
    }
}

