/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.logging.LoggingPreferences;

public class DesiredCapabilities
implements Serializable,
Capabilities {
    private final Map<String, Object> capabilities = new HashMap<String, Object>();

    public DesiredCapabilities(String browser, String version, Platform platform) {
        this.setCapability("browserName", browser);
        this.setCapability("version", version);
        this.setCapability("platform", platform);
    }

    public DesiredCapabilities() {
    }

    public DesiredCapabilities(Map<String, ?> rawMap) {
        if (rawMap.containsKey("loggingPrefs") && rawMap.get("loggingPrefs") instanceof Map) {
            LoggingPreferences prefs = new LoggingPreferences();
            Map prefsMap = (Map)rawMap.get("loggingPrefs");
            for (String logType : prefsMap.keySet()) {
                prefs.enable(logType, Level.parse((String)prefsMap.get(logType)));
            }
            this.capabilities.put("loggingPrefs", prefs);
            rawMap.remove("loggingPrefs");
        }
        this.capabilities.putAll(rawMap);
        Object value = this.capabilities.get("platform");
        if (value instanceof String) {
            this.capabilities.put("platform", (Object)Platform.valueOf((String)value));
        }
    }

    public DesiredCapabilities(Capabilities other) {
        if (other != null) {
            this.merge(other);
        }
    }

    public DesiredCapabilities(Capabilities ... others) {
        Capabilities[] capabilitiesArray = others;
        int n = others.length;
        int n2 = 0;
        while (n2 < n) {
            Capabilities caps = capabilitiesArray[n2];
            if (caps != null) {
                this.merge(caps);
            }
            ++n2;
        }
    }

    @Override
    public String getBrowserName() {
        return (String)this.capabilities.get("browserName");
    }

    public void setBrowserName(String browserName) {
        this.setCapability("browserName", browserName);
    }

    @Override
    public String getVersion() {
        return (String)this.capabilities.get("version");
    }

    public void setVersion(String version) {
        this.setCapability("version", version);
    }

    @Override
    public Platform getPlatform() {
        if (this.capabilities.containsKey("platform")) {
            Object raw = this.capabilities.get("platform");
            if (raw instanceof String) {
                return Platform.valueOf((String)raw);
            }
            if (raw instanceof Platform) {
                return (Platform)((Object)raw);
            }
        }
        return null;
    }

    public void setPlatform(Platform platform) {
        this.setCapability("platform", platform);
    }

    @Override
    public boolean isJavascriptEnabled() {
        if (this.capabilities.containsKey("javascriptEnabled")) {
            Object raw = this.capabilities.get("javascriptEnabled");
            if (raw instanceof String) {
                return Boolean.parseBoolean((String)raw);
            }
            if (raw instanceof Boolean) {
                return (Boolean)raw;
            }
        }
        return true;
    }

    public void setJavascriptEnabled(boolean javascriptEnabled) {
        this.setCapability("javascriptEnabled", javascriptEnabled);
    }

    @Override
    public Object getCapability(String capabilityName) {
        return this.capabilities.get(capabilityName);
    }

    @Override
    public boolean is(String capabilityName) {
        Object cap = this.getCapability(capabilityName);
        if (cap == null) {
            return false;
        }
        return cap instanceof Boolean ? (Boolean)cap : Boolean.parseBoolean(String.valueOf(cap));
    }

    public DesiredCapabilities merge(Capabilities extraCapabilities) {
        if (extraCapabilities != null) {
            this.capabilities.putAll(extraCapabilities.asMap());
        }
        return this;
    }

    public void setCapability(String capabilityName, boolean value) {
        this.capabilities.put(capabilityName, value);
    }

    public void setCapability(String capabilityName, String value) {
        this.capabilities.put(capabilityName, value);
    }

    public void setCapability(String capabilityName, Platform value) {
        this.capabilities.put(capabilityName, (Object)value);
    }

    public void setCapability(String key, Object value) {
        this.capabilities.put(key, value);
    }

    @Override
    public Map<String, ?> asMap() {
        return Collections.unmodifiableMap(this.capabilities);
    }

    public static DesiredCapabilities android() {
        return new DesiredCapabilities("android", "", Platform.ANDROID);
    }

    public static DesiredCapabilities chrome() {
        return new DesiredCapabilities("chrome", "", Platform.ANY);
    }

    public static DesiredCapabilities firefox() {
        return new DesiredCapabilities("firefox", "", Platform.ANY);
    }

    public static DesiredCapabilities htmlUnit() {
        return new DesiredCapabilities("htmlunit", "", Platform.ANY);
    }

    public static DesiredCapabilities internetExplorer() {
        DesiredCapabilities capabilities = new DesiredCapabilities("internet explorer", "", Platform.WINDOWS);
        capabilities.setCapability("ensureCleanSession", true);
        return capabilities;
    }

    public static DesiredCapabilities iphone() {
        return new DesiredCapabilities("iPhone", "", Platform.MAC);
    }

    public static DesiredCapabilities ipad() {
        return new DesiredCapabilities("iPad", "", Platform.MAC);
    }

    public static DesiredCapabilities opera() {
        return new DesiredCapabilities("opera", "", Platform.ANY);
    }

    public static DesiredCapabilities safari() {
        return new DesiredCapabilities("safari", "", Platform.ANY);
    }

    public String toString() {
        return String.format("Capabilities [%s]", this.capabilities);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DesiredCapabilities)) {
            return false;
        }
        DesiredCapabilities that = (DesiredCapabilities)o;
        return this.capabilities.equals(that.capabilities);
    }

    public int hashCode() {
        return this.capabilities.hashCode();
    }
}

