/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.EncodeException;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.GeneralProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;

public class ParameterImpl
implements Parameter {
    private byte[] data;
    private Parameter[] parameters;
    private boolean primitive = true;
    private int tag;
    private int tagClass;
    private int encodingLength = -1;
    private boolean singleParameterInAsn = false;

    public byte[] getData() {
        return this.data;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public void setData(byte[] b) {
        this.data = b;
        if (this.data != null) {
            this.setParameters(null);
        }
    }

    public void setPrimitive(boolean b) {
        if (this.parameters != null && b) {
            throw new IllegalArgumentException("Can not set primitive flag since Parameter[] is present!");
        }
        this.primitive = b;
    }

    public int getEncodingLength() {
        if (this.encodingLength >= 0) {
            return this.encodingLength;
        }
        if (this.data != null) {
            return this.data.length;
        }
        return 0;
    }

    public void setEncodingLength(int val) {
        this.encodingLength = val;
    }

    public int getTag() {
        return this.tag;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    public int getTagClass() {
        return this.tagClass;
    }

    public void setTagClass(int tagClass) {
        this.tagClass = tagClass;
    }

    public String toString() {
        return "Parameter[data=" + Arrays.toString(this.data) + ", parameters=" + Arrays.toString(this.parameters) + ", primitive=" + this.primitive + ", tag=" + this.tag + ", tagClass=" + this.tagClass + ", encodingLength=" + this.getEncodingLength() + "]";
    }

    public Parameter[] getParameters() {
        if (this.parameters == null && !this.isPrimitive()) {
            if (this.data == null) {
                return this.parameters;
            }
            ArrayList<Parameter> paramsList = new ArrayList<Parameter>();
            try {
                AsnInputStream ais = new AsnInputStream(this.data);
                while (ais.available() > 0) {
                    int tag = ais.readTag();
                    Parameter _p = TcapFactory.createParameter(tag, ais, false);
                    paramsList.add(_p);
                }
                this.parameters = new Parameter[paramsList.size()];
                this.parameters = paramsList.toArray(this.parameters);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse raw data into constructed parameter", e);
            }
        }
        return this.parameters;
    }

    public void setParameters(Parameter[] paramss) {
        this.parameters = paramss;
        if (this.parameters != null) {
            this.setData(null);
            this.setPrimitive(false);
        }
    }

    public void setSingleParameterInAsn() {
        this.singleParameterInAsn = true;
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            this.primitive = ais.isTagPrimitive();
            this.tagClass = ais.getTagClass();
            this.data = ais.readSequence();
            this.encodingLength = this.data.length;
            if (this.singleParameterInAsn && ais.available() > 0) {
                byte[] buf = new byte[this.data.length + ais.available()];
                System.arraycopy(this.data, 0, buf, 0, this.data.length);
                ais.read(buf, this.data.length, ais.available());
                this.data = buf;
            }
        }
        catch (IOException e) {
            throw new ParseException(null, GeneralProblemType.BadlyStructuredComponent, "IOException while decoding the parameter: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new ParseException(null, GeneralProblemType.BadlyStructuredComponent, "AsnException while decoding the parameter: " + e.getMessage(), e);
        }
    }

    public void encode(AsnOutputStream aos) throws EncodeException {
        if (this.data == null && this.parameters == null) {
            throw new EncodeException("Parameter data not set.");
        }
        try {
            aos.writeTag(this.tagClass, this.primitive, this.tag);
            if (this.data == null) {
                AsnOutputStream localAos = new AsnOutputStream();
                for (Parameter p : this.parameters) {
                    p.encode(localAos);
                }
                this.data = localAos.toByteArray();
            }
            if (this.encodingLength >= 0) {
                aos.writeLength(this.encodingLength);
            } else {
                aos.writeLength(this.data.length);
            }
            aos.write(this.data);
        }
        catch (IOException e) {
            throw new EncodeException(e);
        }
        catch (AsnException e) {
            throw new EncodeException(e);
        }
    }
}

