/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.smstpdu;

import org.mobicents.protocols.ss7.map.api.smstpdu.AbsoluteTimeStamp;
import org.mobicents.protocols.ss7.map.api.smstpdu.ValidityEnhancedFormatData;
import org.mobicents.protocols.ss7.map.api.smstpdu.ValidityPeriod;
import org.mobicents.protocols.ss7.map.api.smstpdu.ValidityPeriodFormat;

public class ValidityPeriodImpl
implements ValidityPeriod {
    private Integer relativeFormatValue;
    private AbsoluteTimeStamp absoluteFormatValue;
    private ValidityEnhancedFormatData enhancedFormatValue;

    public ValidityPeriodImpl(int relativeFormatValue) {
        this.relativeFormatValue = relativeFormatValue;
    }

    public ValidityPeriodImpl(AbsoluteTimeStamp absoluteFormatValue) {
        this.absoluteFormatValue = absoluteFormatValue;
    }

    public ValidityPeriodImpl(ValidityEnhancedFormatData enhancedFormatValue) {
        this.enhancedFormatValue = enhancedFormatValue;
    }

    public ValidityPeriodFormat getValidityPeriodFormat() {
        if (this.relativeFormatValue != null) {
            return ValidityPeriodFormat.fieldPresentRelativeFormat;
        }
        if (this.absoluteFormatValue != null) {
            return ValidityPeriodFormat.fieldPresentAbsoluteFormat;
        }
        if (this.enhancedFormatValue != null) {
            return ValidityPeriodFormat.fieldPresentEnhancedFormat;
        }
        return ValidityPeriodFormat.fieldNotPresent;
    }

    public Integer getRelativeFormatValue() {
        return this.relativeFormatValue;
    }

    public Double getRelativeFormatHours() {
        if (this.relativeFormatValue == null) {
            return null;
        }
        int i1 = this.relativeFormatValue;
        if (i1 < 0) {
            i1 = 0;
        }
        if (i1 > 255) {
            i1 = 255;
        }
        if (i1 <= 143) {
            return (double)(i1 + 1) * 5.0 / 60.0;
        }
        if (i1 <= 167) {
            return 12.0 + (double)(i1 - 143) * 0.5;
        }
        if (i1 <= 196) {
            return (double)(i1 - 166) * 24.0;
        }
        return (double)(i1 - 192) * 24.0 * 7.0;
    }

    public AbsoluteTimeStamp getAbsoluteFormatValue() {
        return this.absoluteFormatValue;
    }

    public ValidityEnhancedFormatData getEnhancedFormatValue() {
        return this.enhancedFormatValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TP-Validity-Period [");
        if (this.relativeFormatValue != null) {
            sb.append("Relative hours=");
            sb.append(this.getRelativeFormatHours());
        } else if (this.absoluteFormatValue != null) {
            sb.append("Absolute=");
            sb.append(this.getAbsoluteFormatValue().toString());
        } else if (this.enhancedFormatValue != null) {
            sb.append("Enhanced=");
            sb.append(this.getEnhancedFormatValue().toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

