/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.LSAData;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.LSAInformation;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.LSAOnlyAccessIndicator;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.LSADataImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LSAInformationImpl
extends SequenceBase
implements LSAInformation {
    public static final int _TAG_lsaOnlyAccessIndicator = 1;
    public static final int _TAG_lsaDataList = 2;
    public static final int _TAG_extensionContainer = 3;
    private boolean completeDataListIncluded;
    private LSAOnlyAccessIndicator lsaOnlyAccessIndicator;
    private ArrayList<LSAData> lsaDataList;
    private MAPExtensionContainer extensionContainer;

    public LSAInformationImpl() {
        super("LSAInformation");
    }

    public LSAInformationImpl(boolean completeDataListIncluded, LSAOnlyAccessIndicator lsaOnlyAccessIndicator, ArrayList<LSAData> lsaDataList, MAPExtensionContainer extensionContainer) {
        super("LSAInformation");
        this.completeDataListIncluded = completeDataListIncluded;
        this.lsaOnlyAccessIndicator = lsaOnlyAccessIndicator;
        this.lsaDataList = lsaDataList;
        this.extensionContainer = extensionContainer;
    }

    @Override
    public boolean getCompleteDataListIncluded() {
        return this.completeDataListIncluded;
    }

    @Override
    public LSAOnlyAccessIndicator getLSAOnlyAccessIndicator() {
        return this.lsaOnlyAccessIndicator;
    }

    @Override
    public ArrayList<LSAData> getLSADataList() {
        return this.lsaDataList;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.completeDataListIncluded = false;
        this.lsaOnlyAccessIndicator = null;
        this.lsaDataList = null;
        this.extensionContainer = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block12: while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (ais.getTagClass()) {
                case 0: {
                    switch (tag) {
                        case 5: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".completeDataListIncluded: Parameter not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            ais.readNull();
                            this.completeDataListIncluded = true;
                            continue block12;
                        }
                    }
                    ais.advanceElement();
                    continue block12;
                }
                case 2: {
                    switch (tag) {
                        case 1: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".lsaOnlyAccessIndicator: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            int code = (int)ais.readInteger();
                            this.lsaOnlyAccessIndicator = LSAOnlyAccessIndicator.getInstance(code);
                            continue block12;
                        }
                        case 2: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".lsaDataList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            LSADataImpl lsaData = null;
                            AsnInputStream ais2 = ais.readSequenceStream();
                            this.lsaDataList = new ArrayList();
                            while (ais2.available() != 0) {
                                int tag2 = ais2.readTag();
                                if (tag2 != 16 || ais2.getTagClass() != 0 || ais2.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + "LSADataImpl: bad tag or tagClass or is primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                lsaData = new LSADataImpl();
                                lsaData.decodeAll(ais2);
                                this.lsaDataList.add(lsaData);
                            }
                            if (this.lsaDataList.size() >= 1 && this.lsaDataList.size() <= 20) continue block12;
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter lsaDataList size must be from 1 to 20, found: " + this.lsaDataList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        case 3: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                            continue block12;
                        }
                    }
                    ais.advanceElement();
                    continue block12;
                }
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.lsaDataList != null && (this.lsaDataList.size() < 1 || this.lsaDataList.size() > 20)) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter lsaDataList size must be from 1 to 20, found: " + this.lsaDataList.size());
        }
        try {
            if (this.completeDataListIncluded) {
                asnOs.writeNull();
            }
            if (this.lsaOnlyAccessIndicator != null) {
                asnOs.writeInteger(2, 1, this.lsaOnlyAccessIndicator.getCode());
            }
            if (this.lsaDataList != null) {
                asnOs.writeTag(2, false, 2);
                int pos = asnOs.StartContentDefiniteLength();
                for (LSAData lsaData : this.lsaDataList) {
                    ((LSADataImpl)lsaData).encodeAll(asnOs);
                }
                asnOs.FinalizeContent(pos);
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 3);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.completeDataListIncluded) {
            sb.append("completeDataListIncluded, ");
        }
        if (this.lsaOnlyAccessIndicator != null) {
            sb.append("lsaOnlyAccessIndicator=");
            sb.append(this.lsaOnlyAccessIndicator.toString());
            sb.append(", ");
        }
        if (this.lsaDataList != null) {
            sb.append("lsaDataList=[");
            boolean firstItem = true;
            for (LSAData be : this.lsaDataList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(be.toString());
            }
            sb.append("], ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

