/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.lsm.ReportingPLMN;
import org.mobicents.protocols.ss7.map.api.service.lsm.ReportingPLMNList;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.service.lsm.ReportingPLMNImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportingPLMNListImpl
implements ReportingPLMNList,
MAPAsnPrimitive {
    public static final int _ID_plmnListPrioritized = 0;
    public static final int _ID_plmnList = 1;
    public static final String _PrimitiveName = "ReportingPLMNList";
    private boolean plmnListPrioritized;
    private ArrayList<ReportingPLMN> plmnList;

    public ReportingPLMNListImpl() {
    }

    public ReportingPLMNListImpl(boolean plmnListPrioritized, ArrayList<ReportingPLMN> plmnList) {
        this.plmnListPrioritized = plmnListPrioritized;
        this.plmnList = plmnList;
    }

    @Override
    public boolean getPlmnListPrioritized() {
        return this.plmnListPrioritized;
    }

    @Override
    public ArrayList<ReportingPLMN> getPlmnList() {
        return this.plmnList;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ReportingPLMNList: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ReportingPLMNList: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ReportingPLMNList: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ReportingPLMNList: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.plmnListPrioritized = false;
        this.plmnList = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding ReportingPLMNList plmnListPrioritized: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.plmnListPrioritized = true;
                        break;
                    }
                    case 1: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding ReportingPLMNList plmnList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.plmnList = new ArrayList();
                        AsnInputStream ais2 = ais.readSequenceStream();
                        while (ais2.available() != 0) {
                            int tag2 = ais2.readTag();
                            if (tag2 != 16 || ais2.getTagClass() != 0 || ais2.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding ReportingPLMNList: bad ReportingPLMN tag or tagClass or is primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            ReportingPLMNImpl el = new ReportingPLMNImpl();
                            el.decodeAll(ais2);
                            this.plmnList.add(el);
                        }
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.plmnList == null) {
            throw new MAPParsingComponentException("Error while decoding ReportingPLMNList: Parament plmnList is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.plmnList.size() < 1 || this.plmnList.size() > 20) {
            throw new MAPParsingComponentException("Error while decoding ReportingPLMNList: Parament plmnList size must be from 1 to 20, found: " + this.plmnList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ReportingPLMNList: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.plmnList == null) {
            throw new MAPException("plmnList parameter must not be null");
        }
        if (this.plmnList.size() < 1 || this.plmnList.size() > 20) {
            throw new MAPException("plmnList size must be from 1 to 20, found: " + this.plmnList.size());
        }
        try {
            if (this.plmnListPrioritized) {
                asnOs.writeNull(2, 0);
            }
            asnOs.writeTag(2, false, 1);
            int pos = asnOs.StartContentDefiniteLength();
            for (ReportingPLMN ri : this.plmnList) {
                if (ri == null) continue;
                ReportingPLMNImpl rii = (ReportingPLMNImpl)ri;
                rii.encodeAll(asnOs);
            }
            asnOs.FinalizeContent(pos);
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding ReportingPLMNList: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ReportingPLMNList: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.plmnListPrioritized) {
            sb.append("plmnListPrioritized");
        }
        if (this.plmnList != null) {
            sb.append(", plmnList= [");
            for (ReportingPLMN ri : this.plmnList) {
                sb.append("ReportingPLMN=");
                sb.append(ri);
                sb.append(", ");
            }
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }
}

