/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.ss7.map.MAPDialogImpl;
import org.mobicents.protocols.ss7.map.MAPProviderImpl;
import org.mobicents.protocols.ss7.map.MAPServiceBaseImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.MAPServiceListener;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckData;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckResult;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.service.lsm.MAPDialogLsm;
import org.mobicents.protocols.ss7.map.api.service.lsm.MAPServiceLsm;
import org.mobicents.protocols.ss7.map.api.service.lsm.MAPServiceLsmListener;
import org.mobicents.protocols.ss7.map.dialog.ServingCheckDataImpl;
import org.mobicents.protocols.ss7.map.service.lsm.MAPDialogLsmImpl;
import org.mobicents.protocols.ss7.map.service.lsm.ProvideSubscriberLocationRequestImpl;
import org.mobicents.protocols.ss7.map.service.lsm.ProvideSubscriberLocationResponseImpl;
import org.mobicents.protocols.ss7.map.service.lsm.SendRoutingInfoForLCSRequestImpl;
import org.mobicents.protocols.ss7.map.service.lsm.SendRoutingInfoForLCSResponseImpl;
import org.mobicents.protocols.ss7.map.service.lsm.SubscriberLocationReportRequestImpl;
import org.mobicents.protocols.ss7.map.service.lsm.SubscriberLocationReportResponseImpl;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;

public class MAPServiceLsmImpl
extends MAPServiceBaseImpl
implements MAPServiceLsm {
    public MAPServiceLsmImpl(MAPProviderImpl mapProviderImpl) {
        super(mapProviderImpl);
    }

    public MAPDialogLsm createNewDialog(MAPApplicationContext appCntx, SccpAddress origAddress, AddressString origReference, SccpAddress destAddress, AddressString destReference) throws MAPException {
        return this.createNewDialog(appCntx, origAddress, origReference, destAddress, destReference, null);
    }

    public MAPDialogLsm createNewDialog(MAPApplicationContext appCntx, SccpAddress origAddress, AddressString origReference, SccpAddress destAddress, AddressString destReference, Long localTrId) throws MAPException {
        if (!this.isActivated()) {
            throw new MAPException("Cannot create MAPDialogLsm because MAPServiceLsm is not activated");
        }
        Dialog tcapDialog = this.createNewTCAPDialog(origAddress, destAddress, localTrId);
        MAPDialogLsmImpl dialog = new MAPDialogLsmImpl(appCntx, tcapDialog, this.mapProviderImpl, this, origReference, destReference);
        this.putMAPDialogIntoCollection(dialog);
        return dialog;
    }

    public void addMAPServiceListener(MAPServiceLsmListener mapServiceListener) {
        super.addMAPServiceListener(mapServiceListener);
    }

    public void removeMAPServiceListener(MAPServiceLsmListener mapServiceListener) {
        super.removeMAPServiceListener(mapServiceListener);
    }

    protected MAPDialogImpl createNewDialogIncoming(MAPApplicationContext appCntx, Dialog tcapDialog) {
        return new MAPDialogLsmImpl(appCntx, tcapDialog, this.mapProviderImpl, this, null, null);
    }

    public ServingCheckData isServingService(MAPApplicationContext dialogApplicationContext) {
        int vers = dialogApplicationContext.getApplicationContextVersion().getVersion();
        switch (dialogApplicationContext.getApplicationContextName()) {
            case locationSvcEnquiryContext: 
            case locationSvcGatewayContext: {
                if (vers == 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 3) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 3L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName(altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
        }
        return new ServingCheckDataImpl(ServingCheckResult.AC_NotServing);
    }

    public void processComponent(ComponentType compType, OperationCode oc, Parameter parameter, MAPDialog mapDialog, Long invokeId, Long linkedId, Invoke linkedInvoke) throws MAPParsingComponentException {
        if (compType == ComponentType.Invoke && this.mapProviderImpl.isCongested()) {
            return;
        }
        MAPDialogLsmImpl mAPDialogLsmImpl = (MAPDialogLsmImpl)mapDialog;
        Long ocValue = oc.getLocalOperationCode();
        if (ocValue == null) {
            new MAPParsingComponentException("", MAPParsingComponentExceptionReason.UnrecognizedOperation);
        }
        long ocValueInt = ocValue;
        int ocValueInt2 = (int)ocValueInt;
        switch (ocValueInt2) {
            case 83: {
                if (compType == ComponentType.Invoke) {
                    this.provideSubscriberLocationReq(parameter, mAPDialogLsmImpl, invokeId);
                    break;
                }
                this.provideSubscriberLocationRes(parameter, mAPDialogLsmImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 86: {
                if (compType == ComponentType.Invoke) {
                    this.subscriberLocationReportReq(parameter, mAPDialogLsmImpl, invokeId);
                    break;
                }
                this.subscriberLocationReportRes(parameter, mAPDialogLsmImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 85: {
                if (compType == ComponentType.Invoke) {
                    this.sendRoutingInfoForLCSReq(parameter, mAPDialogLsmImpl, invokeId);
                    break;
                }
                this.sendRoutingInfoForLCSRes(parameter, mAPDialogLsmImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            default: {
                throw new MAPParsingComponentException("MAPServiceLsm: unknown incoming operation code: " + ocValueInt, MAPParsingComponentExceptionReason.UnrecognizedOperation);
            }
        }
    }

    private void provideSubscriberLocationReq(Parameter param, MAPDialogLsmImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (param == null) {
            throw new MAPParsingComponentException("Error while decoding provideSubscriberLocationRes: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (param.getTag() != 16 || param.getTagClass() != 0 || param.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding provideSubscriberLocationReq: Bad tag or tagClass or parameter is primitive, received tag=" + param.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = param.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ProvideSubscriberLocationRequestImpl ind = new ProvideSubscriberLocationRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            serLis.onMAPMessage(ind);
            ((MAPServiceLsmListener)serLis).onProvideSubscriberLocationRequest(ind);
        }
    }

    private void provideSubscriberLocationRes(Parameter param, MAPDialogLsmImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        if (param == null) {
            throw new MAPParsingComponentException("Error while decoding provideSubscriberLocationRes: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (param.getTag() != 16 || param.getTagClass() != 0 || param.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding provideSubscriberLocationRes: Bad tag or tagClass or parameter is primitive, received tag=" + param.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = param.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ProvideSubscriberLocationResponseImpl provideSubsLoctResInd = new ProvideSubscriberLocationResponseImpl();
        provideSubsLoctResInd.decodeData(ais, buf.length);
        provideSubsLoctResInd.setInvokeId(invokeId);
        provideSubsLoctResInd.setMAPDialog(mapDialogImpl);
        provideSubsLoctResInd.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            serLis.onMAPMessage(provideSubsLoctResInd);
            ((MAPServiceLsmListener)serLis).onProvideSubscriberLocationResponse(provideSubsLoctResInd);
        }
    }

    private void subscriberLocationReportReq(Parameter parameter, MAPDialogLsmImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding subscriberLocationReport: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding subscriberLocationReportReq: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        SubscriberLocationReportRequestImpl ind = new SubscriberLocationReportRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            serLis.onMAPMessage(ind);
            ((MAPServiceLsmListener)serLis).onSubscriberLocationReportRequest(ind);
        }
    }

    private void subscriberLocationReportRes(Parameter parameter, MAPDialogLsmImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding subscriberLocationReport: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding subscriberLocationReportRes: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        SubscriberLocationReportResponseImpl resInd = new SubscriberLocationReportResponseImpl();
        resInd.decodeData(ais, buf.length);
        resInd.setInvokeId(invokeId);
        resInd.setMAPDialog(mapDialogImpl);
        resInd.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            serLis.onMAPMessage(resInd);
            ((MAPServiceLsmListener)serLis).onSubscriberLocationReportResponse(resInd);
        }
    }

    private void sendRoutingInfoForLCSReq(Parameter parameter, MAPDialogLsmImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding sendRoutingInfoForLCS: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding sendRoutingInfoForLCSReq: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        SendRoutingInfoForLCSRequestImpl ind = new SendRoutingInfoForLCSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            serLis.onMAPMessage(ind);
            ((MAPServiceLsmListener)serLis).onSendRoutingInfoForLCSRequest(ind);
        }
    }

    private void sendRoutingInfoForLCSRes(Parameter parameter, MAPDialogLsmImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding sendRoutingInfoForLCS: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding sendRoutingInfoForLCSRes: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        SendRoutingInfoForLCSResponseImpl resInd = new SendRoutingInfoForLCSResponseImpl();
        resInd.decodeData(ais, buf.length);
        resInd.setInvokeId(invokeId);
        resInd.setMAPDialog(mapDialogImpl);
        resInd.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            serLis.onMAPMessage(resInd);
            ((MAPServiceLsmListener)serLis).onSendRoutingInfoForLCSResponse(resInd);
        }
    }
}

