/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import java.util.Arrays;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.EncodeException;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.comp.GeneralProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCodeType;

public class OperationCodeImpl
implements OperationCode {
    private Long localOperationCode;
    private long[] globalOperationCode;
    private OperationCodeType type;

    public OperationCodeType getOperationType() {
        return this.type;
    }

    public void setOperationType(OperationCodeType t) {
        this.type = t;
    }

    public void setOperationCodeType(OperationCodeType type) {
        this.type = type;
    }

    public void setLocalOperationCode(Long localOperationCode) {
        this.localOperationCode = localOperationCode;
        this.globalOperationCode = null;
        this.type = OperationCodeType.Local;
    }

    public void setGlobalOperationCode(long[] globalOperationCode) {
        this.localOperationCode = null;
        this.globalOperationCode = globalOperationCode;
        this.type = OperationCodeType.Global;
    }

    public Long getLocalOperationCode() {
        return this.localOperationCode;
    }

    public long[] getGlobalOperationCode() {
        return this.globalOperationCode;
    }

    public String getStringValue() {
        if (this.localOperationCode != null) {
            return this.localOperationCode.toString();
        }
        if (this.globalOperationCode != null) {
            return Arrays.toString(this.globalOperationCode);
        }
        return "empty";
    }

    public String toString() {
        if (this.localOperationCode != null) {
            return "OperationCode[OperationType=Local, data=" + this.localOperationCode.toString() + "]";
        }
        if (this.globalOperationCode != null) {
            return "OperationCode[OperationType=Global, data=" + Arrays.toString(this.globalOperationCode) + "]";
        }
        return "OperationCode[empty]";
    }

    public void decode(AsnInputStream ais) throws ParseException {
        block5: {
            try {
                if (this.type == OperationCodeType.Global) {
                    this.globalOperationCode = ais.readObjectIdentifier();
                    break block5;
                }
                if (this.type == OperationCodeType.Local) {
                    this.localOperationCode = ais.readInteger();
                    break block5;
                }
                throw new ParseException(null, GeneralProblemType.MistypedComponent);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ParseException(null, GeneralProblemType.BadlyStructuredComponent, "IOException while parsing OperationCode: " + e.getMessage(), e);
            }
            catch (AsnException e) {
                e.printStackTrace();
                throw new ParseException(null, GeneralProblemType.BadlyStructuredComponent, "AsnException while parsing OperationCode: " + e.getMessage(), e);
            }
        }
    }

    public void encode(AsnOutputStream aos) throws EncodeException {
        block6: {
            if (this.localOperationCode == null && this.globalOperationCode == null) {
                throw new EncodeException("Operation code: No Operation code set!");
            }
            try {
                if (this.type == OperationCodeType.Local) {
                    aos.writeInteger(this.localOperationCode);
                    break block6;
                }
                if (this.type == OperationCodeType.Global) {
                    aos.writeObjectIdentifier(this.globalOperationCode);
                    break block6;
                }
                throw new EncodeException();
            }
            catch (IOException e) {
                throw new EncodeException(e);
            }
            catch (AsnException e) {
                throw new EncodeException(e);
            }
        }
    }
}

