/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.statistics;

import java.util.ArrayList;
import java.util.Date;
import javolution.util.FastMap;
import org.mobicents.protocols.ss7.statistics.StatDataCollectorAbstractImpl;
import org.mobicents.protocols.ss7.statistics.StatDataCollectorMax;
import org.mobicents.protocols.ss7.statistics.StatDataCollectorMin;
import org.mobicents.protocols.ss7.statistics.StringLongMap;
import org.mobicents.protocols.ss7.statistics.api.StatCounterCollection;
import org.mobicents.protocols.ss7.statistics.api.StatDataCollectorType;
import org.mobicents.protocols.ss7.statistics.api.StatResult;

public class StatCounterCollectionImpl
implements StatCounterCollection {
    private String counterName;
    private StatDataCollectorType type;
    private FastMap<String, StatDataCollectorAbstractImpl> coll = new FastMap();

    public StatCounterCollectionImpl(String counterName, StatDataCollectorType type) {
        this.counterName = counterName;
        this.type = type;
    }

    public String getCounterName() {
        return this.counterName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDeadCampaignes(Date lastTime) {
        StatCounterCollectionImpl statCounterCollectionImpl = this;
        synchronized (statCounterCollectionImpl) {
            ArrayList<String> toDel = new ArrayList<String>();
            for (String s : this.coll.keySet()) {
                StatDataCollectorAbstractImpl d = this.coll.get(s);
                if (!d.getSessionStartTime().before(lastTime)) continue;
                toDel.add(s);
            }
            for (String s : toDel) {
                this.coll.remove(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatResult restartAndGet(String campaignName) {
        StatCounterCollectionImpl statCounterCollectionImpl = this;
        synchronized (statCounterCollectionImpl) {
            StatDataCollectorAbstractImpl sdc = this.coll.get(campaignName);
            if (sdc != null) {
                return sdc.restartAndGet();
            }
            switch (this.type) {
                case MIN: {
                    sdc = new StatDataCollectorMin(campaignName);
                    sdc.reset();
                    break;
                }
                case MAX: {
                    sdc = new StatDataCollectorMax(campaignName);
                    sdc.reset();
                    break;
                }
                case StringLongMap: {
                    sdc = new StringLongMap(campaignName);
                    sdc.reset();
                }
            }
            if (sdc != null) {
                this.coll.put(campaignName, sdc);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData(long newVal) {
        StatCounterCollectionImpl statCounterCollectionImpl = this;
        synchronized (statCounterCollectionImpl) {
            for (String s : this.coll.keySet()) {
                StatDataCollectorAbstractImpl d = this.coll.get(s);
                d.updateData(newVal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData(String newVal) {
        StatCounterCollectionImpl statCounterCollectionImpl = this;
        synchronized (statCounterCollectionImpl) {
            for (String s : this.coll.keySet()) {
                StatDataCollectorAbstractImpl d = this.coll.get(s);
                d.updateData(newVal);
            }
        }
    }
}

