/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtBasicServiceCode;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtSSData;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtSSStatus;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSCode;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSSubscriptionOption;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.ExtBasicServiceCodeImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.ExtSSStatusImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.SSCodeImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.SSSubscriptionOptionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtSSDataImpl
extends SequenceBase
implements ExtSSData {
    private static final int _TAG_ss_Status = 4;
    private static final int _TAG_extensionContainer = 5;
    private SSCode ssCode = null;
    private ExtSSStatus ssStatus = null;
    private SSSubscriptionOption ssSubscriptionOption = null;
    private ArrayList<ExtBasicServiceCode> basicServiceGroupList = null;
    private MAPExtensionContainer extensionContainer = null;

    public ExtSSDataImpl() {
        super("ExtSSData");
    }

    public ExtSSDataImpl(SSCode ssCode, ExtSSStatus ssStatus, SSSubscriptionOption ssSubscriptionOption, ArrayList<ExtBasicServiceCode> basicServiceGroupList, MAPExtensionContainer extensionContainer) {
        super("ExtSSData");
        this.ssCode = ssCode;
        this.ssStatus = ssStatus;
        this.ssSubscriptionOption = ssSubscriptionOption;
        this.basicServiceGroupList = basicServiceGroupList;
        this.extensionContainer = extensionContainer;
    }

    @Override
    public SSCode getSsCode() {
        return this.ssCode;
    }

    @Override
    public ExtSSStatus getSsStatus() {
        return this.ssStatus;
    }

    @Override
    public SSSubscriptionOption getSSSubscriptionOption() {
        return this.ssSubscriptionOption;
    }

    @Override
    public ArrayList<ExtBasicServiceCode> getBasicServiceGroupList() {
        return this.basicServiceGroupList;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        ExtBasicServiceCodeImpl serviceItem = null;
        this.ssCode = null;
        this.ssStatus = null;
        this.ssSubscriptionOption = null;
        this.basicServiceGroupList = null;
        this.extensionContainer = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (ais.getTagClass() != 0 || tag != 4 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".ssCode: bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.ssCode = new SSCodeImpl();
                    ((SSCodeImpl)this.ssCode).decodeAll(ais);
                    break;
                }
                case 1: {
                    if (ais.getTagClass() != 2 || tag != 4 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + "._TAG_ss_Status: bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.ssStatus = new ExtSSStatusImpl();
                    ((ExtSSStatusImpl)this.ssStatus).decodeAll(ais);
                    break;
                }
                default: {
                    switch (ais.getTagClass()) {
                        case 2: {
                            switch (tag) {
                                case 1: 
                                case 2: {
                                    this.ssSubscriptionOption = new SSSubscriptionOptionImpl();
                                    ((SSSubscriptionOptionImpl)this.ssSubscriptionOption).decodeAll(ais);
                                    break block0;
                                }
                                case 5: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break block0;
                        }
                        case 0: {
                            switch (tag) {
                                case 16: {
                                    AsnInputStream ais2 = ais.readSequenceStream();
                                    this.basicServiceGroupList = new ArrayList();
                                    while (ais2.available() != 0) {
                                        ais2.readTag();
                                        serviceItem = new ExtBasicServiceCodeImpl();
                                        serviceItem.decodeAll(ais2);
                                        this.basicServiceGroupList.add(serviceItem);
                                    }
                                    if (this.basicServiceGroupList.size() >= 1 || this.basicServiceGroupList.size() <= 32) break block0;
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter basicServiceGroupList size must be from 1 to 32, found: " + this.basicServiceGroupList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                default: {
                                    ais.advanceElement();
                                    break;
                                }
                            }
                            break block0;
                        }
                        default: {
                            ais.advanceElement();
                        }
                    }
                }
            }
            ++num;
        }
        if (this.ssCode == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": ssCode required.", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.ssStatus == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": ssStatus required.", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.ssCode == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": ssCode required.");
        }
        if (this.ssStatus == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": ssStatus required.");
        }
        if (this.basicServiceGroupList != null && (this.basicServiceGroupList.size() < 1 || this.basicServiceGroupList.size() > 32)) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter basicServiceGroupList size must be from 1 to 32, found: " + this.basicServiceGroupList.size());
        }
        try {
            ((SSCodeImpl)this.ssCode).encodeAll(asnOs);
            ((ExtSSStatusImpl)this.ssStatus).encodeAll(asnOs, 2, 4);
            if (this.ssSubscriptionOption != null) {
                ((SSSubscriptionOptionImpl)this.ssSubscriptionOption).encodeAll(asnOs);
            }
            if (this.basicServiceGroupList != null) {
                asnOs.writeTag(0, false, 16);
                int pos = asnOs.StartContentDefiniteLength();
                for (ExtBasicServiceCode serviceItem : this.basicServiceGroupList) {
                    ((ExtBasicServiceCodeImpl)serviceItem).encodeAll(asnOs);
                }
                asnOs.FinalizeContent(pos);
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 5);
            }
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.ssCode != null) {
            sb.append("ssCode=");
            sb.append(this.ssCode.toString());
            sb.append(", ");
        }
        if (this.ssStatus != null) {
            sb.append("ssStatus=");
            sb.append(this.ssStatus.toString());
            sb.append(", ");
        }
        if (this.ssSubscriptionOption != null) {
            sb.append("ssSubscriptionOption=");
            sb.append(this.ssSubscriptionOption.toString());
            sb.append(", ");
        }
        if (this.basicServiceGroupList != null) {
            sb.append("basicServiceGroupList=[");
            boolean firstItem = true;
            for (ExtBasicServiceCode be : this.basicServiceGroupList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(be.toString());
            }
            sb.append("], ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

