/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.NetworkSpecificFacility;

public class NetworkSpecificFacilityImpl
extends AbstractISUPParameter
implements NetworkSpecificFacility {
    private boolean includeNetworkIdentification;
    private int lengthOfNetworkIdentification;
    private int typeOfNetworkIdentification;
    private int networkIdentificationPlan;
    private byte[] networkIdentification;
    private byte[] networkSpecificaFacilityIndicator;

    public NetworkSpecificFacilityImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public NetworkSpecificFacilityImpl() {
    }

    public NetworkSpecificFacilityImpl(boolean includeNetworkIdentification, byte typeOfNetworkIdentification, byte networkdIdentificationPlan, byte[] networkdIdentification, byte[] networkSpecificaFacilityIndicator) {
        this.includeNetworkIdentification = includeNetworkIdentification;
        this.typeOfNetworkIdentification = typeOfNetworkIdentification;
        this.networkIdentificationPlan = networkdIdentificationPlan;
        this.networkIdentification = networkdIdentification;
        this.networkSpecificaFacilityIndicator = networkSpecificaFacilityIndicator;
    }

    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length < 1) {
            throw new ParameterException("byte[] must nto be null or have length greater than 1");
        }
        int shift = 0;
        this.lengthOfNetworkIdentification = b[shift++];
        this.typeOfNetworkIdentification = (byte)(b[shift] >> 4 & 7);
        this.networkIdentificationPlan = (byte)(b[shift] & 0xF);
        ++shift;
        if (this.lengthOfNetworkIdentification > 0) {
            byte[] _networkId = new byte[this.lengthOfNetworkIdentification];
            int i = 0;
            while (i < this.lengthOfNetworkIdentification) {
                _networkId[i] = (byte)(b[shift] | 0x80);
                ++i;
                ++shift;
            }
            if (_networkId.length > 0) {
                _networkId[_networkId.length - 1] = (byte)(_networkId[_networkId.length - 1] & 0x7F);
            }
            this.setNetworkIdentification(_networkId);
        }
        if (shift + 1 == b.length) {
            throw new ParameterException("There is no facility indicator. This part is mandatory!!!");
        }
        byte[] _facility = new byte[b.length - shift - 1];
        System.arraycopy(b, shift, _facility, 0, b.length - shift - 1);
        this.setNetworkSpecificaFacilityIndicator(_facility);
        return b.length;
    }

    public byte[] encode() throws ParameterException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(this.lengthOfNetworkIdentification);
        if (this.includeNetworkIdentification) {
            int b1 = 0;
            b1 = (this.typeOfNetworkIdentification & 7) << 4;
            b1 |= this.networkIdentificationPlan & 0xF;
            if (this.networkIdentification != null && this.networkIdentification.length > 0) {
                bos.write(b1 |= 0x80);
                for (int index = 0; index < this.networkIdentification.length; ++index) {
                    if (index == this.networkIdentification.length - 1) {
                        bos.write(this.networkIdentification[index] & 0x7F);
                        continue;
                    }
                    bos.write(this.networkIdentification[index] | 0x80);
                }
            } else {
                bos.write(b1 & 0x7F);
            }
        }
        if (this.networkSpecificaFacilityIndicator == null) {
            throw new IllegalArgumentException("Network Specific Facility must not be null");
        }
        try {
            bos.write(this.networkSpecificaFacilityIndicator);
        }
        catch (IOException e) {
            throw new ParameterException(e);
        }
        return bos.toByteArray();
    }

    public boolean isIncludeNetworkIdentification() {
        return this.includeNetworkIdentification;
    }

    public int getLengthOfNetworkIdentification() {
        return this.lengthOfNetworkIdentification;
    }

    public int getTypeOfNetworkIdentification() {
        return this.typeOfNetworkIdentification;
    }

    public void setTypeOfNetworkIdentification(byte typeOfNetworkIdentification) {
        this.typeOfNetworkIdentification = typeOfNetworkIdentification;
    }

    public int getNetworkIdentificationPlan() {
        return this.networkIdentificationPlan;
    }

    public void setNetworkIdentificationPlan(byte networkdIdentificationPlan) {
        this.networkIdentificationPlan = networkdIdentificationPlan;
    }

    public byte[] getNetworkIdentification() {
        return this.networkIdentification;
    }

    public void setNetworkIdentification(byte[] networkdIdentification) {
        if (networkdIdentification != null && networkdIdentification.length > 253) {
            throw new IllegalArgumentException("Length of Network Identification part must not be greater than: 253");
        }
        this.networkIdentification = networkdIdentification;
        this.includeNetworkIdentification = true;
    }

    public byte[] getNetworkSpecificaFacilityIndicator() {
        return this.networkSpecificaFacilityIndicator;
    }

    public void setNetworkSpecificaFacilityIndicator(byte[] networkSpecificaFacilityIndicator) {
        this.networkSpecificaFacilityIndicator = networkSpecificaFacilityIndicator;
    }

    public int getCode() {
        return 47;
    }
}

