/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.primitives;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.TimeAndTimezone;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;

public class TimeAndTimezoneImpl
implements TimeAndTimezone,
CAPAsnPrimitive {
    public static final String _PrimitiveName = "TimeAndTimezone";
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private static final String DAY = "day";
    private static final String HOUR = "hour";
    private static final String MINUTE = "minute";
    private static final String SECOND = "second";
    private static final String TIME_ZONE = "timeZone";
    private byte[] data;
    protected static final XMLFormat<TimeAndTimezoneImpl> TIME_AND_TIMEZONE_XML = new XMLFormat<TimeAndTimezoneImpl>(TimeAndTimezoneImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, TimeAndTimezoneImpl timeAndTimezone) throws XMLStreamException {
            timeAndTimezone.setYear(xml.getAttribute(TimeAndTimezoneImpl.YEAR, 0));
            timeAndTimezone.setMonth(xml.getAttribute(TimeAndTimezoneImpl.MONTH, 0));
            timeAndTimezone.setDay(xml.getAttribute(TimeAndTimezoneImpl.DAY, 0));
            timeAndTimezone.setHour(xml.getAttribute(TimeAndTimezoneImpl.HOUR, 0));
            timeAndTimezone.setMinute(xml.getAttribute(TimeAndTimezoneImpl.MINUTE, 0));
            timeAndTimezone.setSecond(xml.getAttribute(TimeAndTimezoneImpl.SECOND, 0));
            timeAndTimezone.setTimeZone(xml.getAttribute(TimeAndTimezoneImpl.TIME_ZONE, 0));
        }

        @Override
        public void write(TimeAndTimezoneImpl timeAndTimezone, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(TimeAndTimezoneImpl.YEAR, timeAndTimezone.getYear());
            xml.setAttribute(TimeAndTimezoneImpl.MONTH, timeAndTimezone.getMonth());
            xml.setAttribute(TimeAndTimezoneImpl.DAY, timeAndTimezone.getDay());
            xml.setAttribute(TimeAndTimezoneImpl.HOUR, timeAndTimezone.getHour());
            xml.setAttribute(TimeAndTimezoneImpl.MINUTE, timeAndTimezone.getMinute());
            xml.setAttribute(TimeAndTimezoneImpl.SECOND, timeAndTimezone.getSecond());
            xml.setAttribute(TimeAndTimezoneImpl.TIME_ZONE, timeAndTimezone.getTimeZone());
        }
    };

    public TimeAndTimezoneImpl() {
    }

    public TimeAndTimezoneImpl(byte[] data) {
        this.data = data;
    }

    public TimeAndTimezoneImpl(int year, int month, int day, int hour, int minute, int second, int timeZone) {
        this.data = new byte[8];
        this.data[0] = (byte)this.encodeByte(year / 100);
        this.data[1] = (byte)this.encodeByte(year % 100);
        this.data[2] = (byte)this.encodeByte(month);
        this.data[3] = (byte)this.encodeByte(day);
        this.data[4] = (byte)this.encodeByte(hour);
        this.data[5] = (byte)this.encodeByte(minute);
        this.data[6] = (byte)this.encodeByte(second);
        this.data[7] = timeZone >= 0 ? (byte)this.encodeByte(timeZone) : (byte)(this.encodeByte(-timeZone) | 8);
    }

    public byte[] getData() {
        return this.data;
    }

    public int getYear() {
        if (this.data == null || this.data.length != 8) {
            return 0;
        }
        return this.decodeByte(this.data[0]) * 100 + this.decodeByte(this.data[1]);
    }

    public int getMonth() {
        if (this.data == null || this.data.length != 8) {
            return 0;
        }
        return this.decodeByte(this.data[2]);
    }

    public int getDay() {
        if (this.data == null || this.data.length != 8) {
            return 0;
        }
        return this.decodeByte(this.data[3]);
    }

    public int getHour() {
        if (this.data == null || this.data.length != 8) {
            return 0;
        }
        return this.decodeByte(this.data[4]);
    }

    public int getMinute() {
        if (this.data == null || this.data.length != 8) {
            return 0;
        }
        return this.decodeByte(this.data[5]);
    }

    public int getSecond() {
        if (this.data == null || this.data.length != 8) {
            return 0;
        }
        return this.decodeByte(this.data[6]);
    }

    public int getTimeZone() {
        if (this.data == null || this.data.length != 8) {
            return 0;
        }
        int res = this.decodeByte((byte)(this.data[7] & 0xF7));
        if ((this.data[7] & 8) != 0) {
            res = -res;
        }
        return res;
    }

    public void setYear(int year) {
        if (this.data == null || this.data.length != 8) {
            this.data = new byte[8];
        }
        this.data[0] = (byte)this.encodeByte(year / 100);
        this.data[1] = (byte)this.encodeByte(year % 100);
    }

    public void setMonth(int month) {
        if (this.data == null || this.data.length != 8) {
            this.data = new byte[8];
        }
        this.data[2] = (byte)this.encodeByte(month);
    }

    public void setDay(int day) {
        if (this.data == null || this.data.length != 8) {
            this.data = new byte[8];
        }
        this.data[3] = (byte)this.encodeByte(day);
    }

    public void setHour(int hour) {
        if (this.data == null || this.data.length != 8) {
            this.data = new byte[8];
        }
        this.data[4] = (byte)this.encodeByte(hour);
    }

    public void setMinute(int minute) {
        if (this.data == null || this.data.length != 8) {
            this.data = new byte[8];
        }
        this.data[5] = (byte)this.encodeByte(minute);
    }

    public void setSecond(int second) {
        if (this.data == null || this.data.length != 8) {
            this.data = new byte[8];
        }
        this.data[6] = (byte)this.encodeByte(second);
    }

    public void setTimeZone(int timeZone) {
        if (this.data == null || this.data.length != 8) {
            this.data = new byte[8];
        }
        this.data[7] = timeZone >= 0 ? (byte)this.encodeByte(timeZone) : (byte)(this.encodeByte(-timeZone) | 8);
    }

    private int decodeByte(int bt) {
        return (bt & 0xF) * 10 + ((bt & 0xF0) >> 4);
    }

    private int encodeByte(int val) {
        return val / 10 | val % 10 << 4;
    }

    public int getTag() throws CAPException {
        return 4;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding TimeAndTimezone: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding TimeAndTimezone: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding TimeAndTimezone: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding TimeAndTimezone: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.data = ansIS.readOctetStringData(length);
        if (this.data.length < 8 || this.data.length > 8) {
            throw new CAPParsingComponentException("Error decoding TimeAndTimezone: length must be from 8 to 8, real length = " + length, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding TimeAndTimezone: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.data == null) {
            throw new CAPException("Error while encoding TimeAndTimezone: data field must not be null");
        }
        if (this.data.length != 8) {
            throw new CAPException("Error while encoding TimeAndTimezone: data field length must be equal 8");
        }
        asnOs.writeOctetStringData(this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.data != null) {
            sb.append("year=");
            sb.append(this.getYear());
            sb.append(", month=");
            sb.append(this.getMonth());
            sb.append(", day=");
            sb.append(this.getDay());
            sb.append(", hour=");
            sb.append(this.getHour());
            sb.append(", minite=");
            sb.append(this.getMinute());
            sb.append(", second=");
            sb.append(this.getSecond());
            sb.append(", timeZone=");
            sb.append(this.getTimeZone());
        }
        sb.append("]");
        return sb.toString();
    }
}

