/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.errors;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessageSystemFailure;
import org.mobicents.protocols.ss7.cap.api.errors.UnavailableNetworkResource;
import org.mobicents.protocols.ss7.cap.errors.CAPErrorMessageImpl;

public class CAPErrorMessageSystemFailureImpl
extends CAPErrorMessageImpl
implements CAPErrorMessageSystemFailure {
    private static final String UNAVAILABLE_NETWORK_RESOURCE = "unavailableNetworkResource";
    public static final String _PrimitiveName = "CAPErrorMessageSystemFailure";
    private UnavailableNetworkResource unavailableNetworkResource;
    protected static final XMLFormat<CAPErrorMessageSystemFailureImpl> CAP_ERROR_MESSAGE_SYSTEM_FAILURE_XML = new XMLFormat<CAPErrorMessageSystemFailureImpl>(CAPErrorMessageSystemFailureImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, CAPErrorMessageSystemFailureImpl errorMessage) throws XMLStreamException {
            CAPErrorMessageImpl.CAP_ERROR_MESSAGE_XML.read(xml, errorMessage);
            String str = xml.get(CAPErrorMessageSystemFailureImpl.UNAVAILABLE_NETWORK_RESOURCE, String.class);
            if (str != null) {
                errorMessage.unavailableNetworkResource = Enum.valueOf(UnavailableNetworkResource.class, str);
            }
        }

        @Override
        public void write(CAPErrorMessageSystemFailureImpl errorMessage, XMLFormat.OutputElement xml) throws XMLStreamException {
            CAPErrorMessageImpl.CAP_ERROR_MESSAGE_XML.write(errorMessage, xml);
            if (errorMessage.unavailableNetworkResource != null) {
                xml.add(errorMessage.unavailableNetworkResource.toString(), CAPErrorMessageSystemFailureImpl.UNAVAILABLE_NETWORK_RESOURCE, String.class);
            }
        }
    };

    protected CAPErrorMessageSystemFailureImpl(UnavailableNetworkResource unavailableNetworkResource) {
        super(11L);
        this.unavailableNetworkResource = unavailableNetworkResource;
    }

    public CAPErrorMessageSystemFailureImpl() {
        super(11L);
    }

    public boolean isEmSystemFailure() {
        return true;
    }

    public CAPErrorMessageSystemFailure getEmSystemFailure() {
        return this;
    }

    public UnavailableNetworkResource getUnavailableNetworkResource() {
        return this.unavailableNetworkResource;
    }

    public int getTag() throws CAPException {
        return 10;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CAPErrorMessageSystemFailure: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CAPErrorMessageSystemFailure: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CAPErrorMessageSystemFailure: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CAPErrorMessageSystemFailure: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream localAis, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.unavailableNetworkResource = null;
        if (localAis.getTagClass() != 0 || localAis.getTag() != 10 || !localAis.isTagPrimitive()) {
            throw new CAPParsingComponentException("Error decoding CAPErrorMessageSystemFailure: bad tag class or tag or parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        int i1 = (int)localAis.readIntegerData(length);
        this.unavailableNetworkResource = UnavailableNetworkResource.getInstance(i1);
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding CAPErrorMessageSystemFailure: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream aos) throws CAPException {
        if (this.unavailableNetworkResource == null) {
            throw new CAPException("Error while encoding CAPErrorMessageSystemFailure: unavailableNetworkResource field must not be null");
        }
        try {
            aos.writeIntegerData(this.unavailableNetworkResource.getCode());
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding CAPErrorMessageSystemFailure: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.unavailableNetworkResource != null) {
            sb.append("unavailableNetworkResource=");
            sb.append((Object)this.unavailableNetworkResource);
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

