/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.tools.traceparser;

import java.io.FileInputStream;
import java.io.IOException;
import org.restcomm.protocols.ss7.tools.traceparser.ProcessControl;
import org.restcomm.protocols.ss7.tools.traceparser.TraceParserUtil;
import org.restcomm.protocols.ss7.tools.traceparser.TraceReaderDriver;
import org.restcomm.protocols.ss7.tools.traceparser.TraceReaderDriverBase;
import org.restcomm.protocols.ss7.tools.traceparser.TraceReaderException;

public class TraceReaderDriverActerna
extends TraceReaderDriverBase
implements TraceReaderDriver {
    public TraceReaderDriverActerna(ProcessControl processControl, String fileName) {
        super(processControl, fileName);
    }

    @Override
    public void startTraceFile() throws TraceReaderException {
        if (this.listeners.size() == 0) {
            throw new TraceReaderException("TraceReaderListener list is empty");
        }
        this.isStarted = true;
        FileInputStream fis = null;
        try {
            if (this.processControl.checkNeedInterrupt()) {
                return;
            }
            fis = new FileInputStream(this.fileName);
            int ind = 0;
            int b = 0;
            int recCnt = 0;
            int step = 4;
            int stepPos = 0;
            int blockLen = 0;
            boolean sufLen = false;
            int[] buf = new int[5];
            while (fis.available() > 0) {
                if (this.processControl.checkNeedInterrupt()) {
                    return;
                }
                b = fis.read();
                switch (step) {
                    case 1: {
                        buf[stepPos] = b;
                        if (stepPos == 16) {
                            blockLen = b;
                        }
                        if (stepPos == 15 && b != 0 || stepPos == 17 && b != 0 && b != 1) {
                            this.loger.error("Error #1, recCnt=" + recCnt);
                        }
                        if (stepPos == 17) {
                            step = 2;
                            stepPos = 0;
                            buf = new int[blockLen += b * 256];
                            break;
                        }
                        ++stepPos;
                        break;
                    }
                    case 2: {
                        buf[stepPos] = b;
                        if (stepPos == blockLen - 1) {
                            byte[] data = new byte[blockLen];
                            for (int i = 0; i < blockLen; ++i) {
                                data[i] = (byte)buf[i];
                            }
                            if (data == null || data.length < 8) {
                                throw new TraceReaderException("Too little data in the raw data");
                            }
                            TraceParserUtil.parceLegacyMtp3(data, this.listeners);
                            step = 3;
                            stepPos = 0;
                            buf = new int[2];
                            break;
                        }
                        ++stepPos;
                        break;
                    }
                    case 3: {
                        buf[stepPos] = b;
                        if (stepPos == 1) {
                            step = 4;
                            stepPos = 0;
                            buf = new int[5];
                            break;
                        }
                        ++stepPos;
                        break;
                    }
                    case 4: {
                        buf[stepPos] = b;
                        if (b == 2) {
                            int[] buf2 = new int[stepPos + 1];
                            for (int i1 = 0; i1 <= stepPos; ++i1) {
                                buf2[i1] = buf[i1];
                            }
                            ++recCnt;
                            step = 1;
                            stepPos = 0;
                            buf = new int[18];
                            break;
                        }
                        ++stepPos;
                    }
                }
                ++ind;
            }
        }
        catch (Throwable e) {
            this.loger.error("General exception: " + e.getMessage());
            e.printStackTrace();
            throw new TraceReaderException("General exception: " + e.getMessage(), e);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

