/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.tcap.asn.EncodeException;
import org.restcomm.protocols.ss7.tcap.asn.ParseException;
import org.restcomm.protocols.ss7.tcap.asn.Result;
import org.restcomm.protocols.ss7.tcap.asn.ResultType;
import org.restcomm.protocols.ss7.tcap.asn.comp.PAbortCauseType;

public class ResultImpl
implements Result {
    private ResultType resultType;

    @Override
    public ResultType getResultType() {
        return this.resultType;
    }

    @Override
    public void setResultType(ResultType t) {
        this.resultType = t;
    }

    public String toString() {
        return "Result[resultType=" + (Object)((Object)this.resultType) + "]";
    }

    @Override
    public void decode(AsnInputStream ais) throws ParseException {
        try {
            AsnInputStream localAis = ais.readSequenceStream();
            int tag = localAis.readTag();
            if (tag != 2 && localAis.getTagClass() != 0) {
                throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error while decoding AARE-apdu.result: bad tag or tag class: tag=" + tag + ", tagClass=" + localAis.getTagClass());
            }
            long t = localAis.readInteger();
            this.resultType = ResultType.getFromInt(t);
        }
        catch (IOException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "IOException while decoding Result: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "AsnException while decoding Result: " + e.getMessage(), e);
        }
    }

    @Override
    public void encode(AsnOutputStream aos) throws EncodeException {
        if (this.resultType == null) {
            throw new EncodeException("Error encoding Result: ResultType must not be null");
        }
        try {
            aos.writeTag(2, false, 2);
            int pos = aos.StartContentDefiniteLength();
            aos.writeInteger(this.resultType.getType());
            aos.FinalizeContent(pos);
        }
        catch (IOException e) {
            throw new EncodeException("IOException while encoding Result: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new EncodeException("AsnException while encoding Result: " + e.getMessage(), e);
        }
    }
}

