/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.parameter;

public enum ResetCauseValue {
    END_USER_ORIGINATED(0),
    SCCP_USER_ORIGINATED(1),
    MESSAGE_OUT_OF_ORDER_INCORRECT_PS(2),
    MESSAGE_OUT_OF_ORDER_INCORRECT_PR(3),
    REMOTE_PROCEDURE_ERROR_MESSAGE_OUT_OF_WINDOW(4),
    REMOTE_PROCEDURE_ERROR_INCORRECT_PS_AFTER_REINITIALIZATION(5),
    REMOTE_PROCEDURE_ERROR_GENERAL(6),
    REMOTE_END_USER_OPERATIONAL(7),
    NETWORK_OPERATIONAL(8),
    ACCESS_OPERATIONAL(9),
    NETWORK_CONGESTION(10),
    UNQUALIFIED(12),
    NOT_OBTAINABLE(11);

    private int code;

    private ResetCauseValue(int code) {
        this.code = code;
    }

    public int getValue() {
        return this.code;
    }

    public static ResetCauseValue getInstance(int code) {
        switch (code) {
            case 0: {
                return END_USER_ORIGINATED;
            }
            case 1: {
                return SCCP_USER_ORIGINATED;
            }
            case 2: {
                return MESSAGE_OUT_OF_ORDER_INCORRECT_PS;
            }
            case 3: {
                return MESSAGE_OUT_OF_ORDER_INCORRECT_PR;
            }
            case 4: {
                return REMOTE_PROCEDURE_ERROR_MESSAGE_OUT_OF_WINDOW;
            }
            case 5: {
                return REMOTE_PROCEDURE_ERROR_INCORRECT_PS_AFTER_REINITIALIZATION;
            }
            case 6: {
                return REMOTE_PROCEDURE_ERROR_GENERAL;
            }
            case 7: {
                return REMOTE_END_USER_OPERATIONAL;
            }
            case 8: {
                return NETWORK_OPERATIONAL;
            }
            case 9: {
                return ACCESS_OPERATIONAL;
            }
            case 10: {
                return NETWORK_CONGESTION;
            }
            case 12: {
                return UNQUALIFIED;
            }
            case 11: {
                return NOT_OBTAINABLE;
            }
        }
        return UNQUALIFIED;
    }

    public boolean isError() {
        switch (this) {
            case MESSAGE_OUT_OF_ORDER_INCORRECT_PS: 
            case MESSAGE_OUT_OF_ORDER_INCORRECT_PR: 
            case REMOTE_PROCEDURE_ERROR_MESSAGE_OUT_OF_WINDOW: 
            case REMOTE_PROCEDURE_ERROR_INCORRECT_PS_AFTER_REINITIALIZATION: 
            case REMOTE_PROCEDURE_ERROR_GENERAL: {
                return true;
            }
        }
        return false;
    }
}

