/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.message;

import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnCrMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnReferencedMessageImpl;
import org.restcomm.protocols.ss7.sccp.message.SccpConnMessage;
import org.restcomm.protocols.ss7.sccp.parameter.LocalReference;

public class MessageUtil {
    private MessageUtil() {
    }

    public static int calculateUdtFieldsLengthWithoutData(int calledPartyLen, int callingPartyLen) {
        return 8 + calledPartyLen + callingPartyLen;
    }

    public static int calculateXudtFieldsLengthWithoutData(int calledPartyLen, int callingPartyLen, boolean segmented, boolean importancePresense) {
        int res = 10 + calledPartyLen + callingPartyLen;
        if (segmented || importancePresense) {
            ++res;
        }
        if (segmented) {
            res += 6;
        }
        if (importancePresense) {
            res += 3;
        }
        return res;
    }

    public static int calculateXudtFieldsLengthWithoutData2(int calledPartyLen, int callingPartyLen) {
        int res = 254 - (3 + calledPartyLen + callingPartyLen);
        return res;
    }

    public static int calculateLudtFieldsLengthWithoutData(int calledPartyLen, int callingPartyLen, boolean segmented, boolean importancePresense) {
        int res = 15 + calledPartyLen + callingPartyLen;
        if (segmented || importancePresense) {
            ++res;
        }
        if (segmented) {
            res += 6;
        }
        if (importancePresense) {
            res += 3;
        }
        return res;
    }

    public static int calculateCrFieldsLengthWithoutData(int calledPartyLen, boolean creditPresence, int callingPartyLen, boolean hopCounterPresence, boolean importancePresence) {
        int res = 11;
        if (calledPartyLen > 0 || creditPresence || callingPartyLen > 0 || hopCounterPresence || importancePresence) {
            ++res;
        }
        if (calledPartyLen > 0) {
            res += calledPartyLen + 2;
        }
        if (creditPresence) {
            res += 3;
        }
        if (callingPartyLen > 0) {
            res += callingPartyLen + 2;
        }
        if (hopCounterPresence) {
            res += 3;
        }
        if (importancePresence) {
            res += 3;
        }
        return res;
    }

    public static int calculateCcFieldsLengthWithoutData(boolean creditPresence, int calledPartyLen, boolean dataPresence, boolean importancePresence) {
        int res = 12;
        if (creditPresence || calledPartyLen != 0 || dataPresence || importancePresence) {
            ++res;
        }
        if (creditPresence) {
            res += 3;
        }
        res += calledPartyLen + 2;
        if (dataPresence) {
            res += 2;
        }
        if (importancePresence) {
            res += 3;
        }
        return res;
    }

    public static int calculateCrefFieldsLengthWithoutData(int calledPartyAddressLen, boolean importancePresence) {
        int res = 6;
        if (calledPartyAddressLen != 0 || importancePresence) {
            ++res;
        }
        res += calledPartyAddressLen + 2;
        if (importancePresence) {
            res += 3;
        }
        return res;
    }

    public static int calculateRlsdFieldsLengthWithoutData(boolean dataPresence, boolean importancePresence) {
        int res = 9;
        if (dataPresence || importancePresence) {
            ++res;
        }
        if (dataPresence) {
            res += 2;
        }
        if (importancePresence) {
            res += 3;
        }
        return res;
    }

    public static LocalReference getSln(SccpConnMessage msg) {
        LocalReference sln;
        if (msg instanceof SccpConnReferencedMessageImpl) {
            sln = ((SccpConnReferencedMessageImpl)msg).getSourceLocalReferenceNumber();
        } else if (msg instanceof SccpConnCrMessageImpl) {
            sln = ((SccpConnCrMessageImpl)msg).getSourceLocalReferenceNumber();
        } else {
            throw new IllegalStateException("Not implemented");
        }
        return sln;
    }

    public static LocalReference getDln(SccpConnMessage msg) {
        if (!(msg instanceof SccpConnReferencedMessageImpl)) {
            throw new IllegalStateException("Not implemented");
        }
        LocalReference dln = ((SccpConnReferencedMessageImpl)msg).getDestinationLocalReferenceNumber();
        return dln;
    }
}

