/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl;

import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.sccp.impl.SccpConnectionImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnAkMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnDt2MessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnItMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.ReceiveSequenceNumberImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.ResetCauseImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.SequenceNumberImpl;
import org.restcomm.protocols.ss7.sccp.parameter.ResetCauseValue;
import org.restcomm.protocols.ss7.sccp.parameter.SequenceNumber;

public class SccpFlowControl {
    private static final double EARLY_ACK_LEVEL_LARGE_WINDOW = 0.5;
    private static final double EARLY_ACK_LEVEL_SMALL_WINDOW = 0.1;
    private static final int EARLY_ACK_LARGE_WINDOW = 50;
    private final Logger logger;
    private SequenceNumber sendSequenceNumber;
    private boolean expectingFirstMessageInputAfterInit = true;
    private SequenceNumber sendSequenceNumberExpectedAtInput;
    private SequenceNumber lastReceiveSequenceNumberReceived;
    private int maximumWindowSize;
    private SccpFlowControlWindow inputWindow;
    private SccpFlowControlWindow outputWindow;
    private boolean preemptiveAk = false;

    public SccpFlowControl(String name, int maximumWindowSize) {
        this.logger = Logger.getLogger(SccpFlowControl.class.getCanonicalName() + "-" + name);
        if (maximumWindowSize > 127) {
            throw new IllegalArgumentException();
        }
        this.maximumWindowSize = maximumWindowSize;
        this.reinitialize();
    }

    public void initializeMessageNumbering(SccpConnDt2MessageImpl msg) {
        this.sendSequenceNumber = this.getNextSequenceNumber();
        msg.setSequencing(this.sendSequenceNumber, this.sendSequenceNumberExpectedAtInput);
        this.inputWindow.setLowerEdge(this.sendSequenceNumberExpectedAtInput);
    }

    public void initializeMessageNumbering(SccpConnItMessageImpl msg) {
        msg.setSequencing(this.sendSequenceNumber, this.sendSequenceNumberExpectedAtInput);
        this.inputWindow.setLowerEdge(this.sendSequenceNumberExpectedAtInput);
    }

    public void initializeMessageNumbering(SccpConnAkMessageImpl msg) {
        this.initializeMessageNumbering(msg, this.sendSequenceNumberExpectedAtInput);
    }

    public void initializeMessageNumbering(SccpConnAkMessageImpl msg, SequenceNumber receiveSequenceNumber) {
        this.sendSequenceNumberExpectedAtInput = receiveSequenceNumber;
        this.inputWindow.setLowerEdge(receiveSequenceNumber);
        msg.setReceiveSequenceNumber(new ReceiveSequenceNumberImpl(receiveSequenceNumber));
    }

    protected SequenceNumber getNextSequenceNumber() {
        return this.sendSequenceNumber.nextNumber();
    }

    public void checkOutputMessageNumbering(SccpConnDt2MessageImpl msg) {
        if (!this.outputWindow.contains(msg.getSequencingSegmenting().getSendSequenceNumber())) {
            throw new MessageSequenceNumberException("P(S) outside sending window");
        }
    }

    public void checkOutputMessageNumbering(SccpConnItMessageImpl msg) {
        if (!this.outputWindow.contains(msg.getSequencingSegmenting().getSendSequenceNumber())) {
            throw new MessageSequenceNumberException("P(S) outside sending window");
        }
    }

    public boolean isAuthorizedToTransmitAnotherMessage() {
        SequenceNumber nextSequenceNumber = this.getNextSequenceNumber();
        boolean result = this.outputWindow.contains(nextSequenceNumber);
        if (result && this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("output window %3s,(%3d) contains %3s: %b", this.outputWindow.lowerEdge.getValue(), this.outputWindow.w, nextSequenceNumber.getValue(), result));
        }
        return result;
    }

    public boolean isAkSendCriterion(SccpConnDt2MessageImpl msg) {
        if (!this.preemptiveAk) {
            return this.inputWindow.getW() == 0 || msg.getSequencingSegmenting().getSendSequenceNumber().equals(this.inputWindow.getUpperEdge());
        }
        return this.inputWindow.getW() == 0 || msg.getSequencingSegmenting().getSendSequenceNumber().equals(this.inputWindow.getEarlyAckEdge());
    }

    public void checkInputMessageNumbering(SccpConnectionImpl conn, SequenceNumber receiveSequenceNumber) throws Exception {
        this.checkInputMessageNumbering(conn, null, receiveSequenceNumber);
    }

    public boolean checkInputMessageNumbering(SccpConnectionImpl conn, SequenceNumber sendSequenceNumber, SequenceNumber receiveSequenceNumber) throws Exception {
        if (sendSequenceNumber != null) {
            if (this.expectingFirstMessageInputAfterInit && !sendSequenceNumber.equals(new SequenceNumberImpl(0))) {
                conn.reset(new ResetCauseImpl(ResetCauseValue.MESSAGE_OUT_OF_ORDER_INCORRECT_PS));
                return false;
            }
            if (sendSequenceNumber.equals(this.sendSequenceNumberExpectedAtInput) && this.inputWindow.contains(sendSequenceNumber)) {
                this.sendSequenceNumberExpectedAtInput = this.sendSequenceNumberExpectedAtInput.nextNumber();
            } else {
                if (!this.inputWindow.contains(sendSequenceNumber)) {
                    conn.reset(new ResetCauseImpl(ResetCauseValue.REMOTE_PROCEDURE_ERROR_MESSAGE_OUT_OF_WINDOW));
                } else if (!sendSequenceNumber.equals(this.sendSequenceNumberExpectedAtInput)) {
                    conn.resetSection(new ResetCauseImpl(ResetCauseValue.MESSAGE_OUT_OF_ORDER_INCORRECT_PS));
                }
                return false;
            }
        }
        if (!SccpFlowControl.rangeContains(this.lastReceiveSequenceNumberReceived, this.sendSequenceNumber.nextNumber(), receiveSequenceNumber)) {
            conn.resetSection(new ResetCauseImpl(ResetCauseValue.MESSAGE_OUT_OF_ORDER_INCORRECT_PS));
            return false;
        }
        this.outputWindow.setLowerEdge(receiveSequenceNumber);
        this.lastReceiveSequenceNumberReceived = receiveSequenceNumber;
        this.expectingFirstMessageInputAfterInit = false;
        return true;
    }

    public void reinitialize() {
        this.inputWindow = new SccpFlowControlWindow(new SequenceNumberImpl(0), this.maximumWindowSize);
        this.outputWindow = new SccpFlowControlWindow(new SequenceNumberImpl(0), this.maximumWindowSize);
        this.sendSequenceNumberExpectedAtInput = new SequenceNumberImpl(0);
        this.lastReceiveSequenceNumberReceived = new SequenceNumberImpl(0);
        this.sendSequenceNumber = new SequenceNumberImpl(0, false, true);
        this.expectingFirstMessageInputAfterInit = true;
    }

    public SequenceNumber getSendSequenceNumberExpectedAtInput() {
        return this.sendSequenceNumberExpectedAtInput;
    }

    public void setSendCredit(int sendCredit) {
        this.outputWindow.setW(sendCredit);
    }

    public void setReceiveCredit(int receiveCredit) {
        this.inputWindow.setW(receiveCredit);
    }

    public boolean isPreemptiveAk() {
        return this.preemptiveAk;
    }

    public int getSendCredit() {
        return this.outputWindow.getW();
    }

    public int getReceiveCredit() {
        return this.inputWindow.getW();
    }

    public int getMaximumWindowSize() {
        return this.maximumWindowSize;
    }

    public static boolean rangeContains(SequenceNumber lowerEdge, SequenceNumber upperEdge, SequenceNumber number) {
        if (number.equals(lowerEdge) || number.equals(upperEdge)) {
            return true;
        }
        if (upperEdge.getValue() < lowerEdge.getValue()) {
            return lowerEdge.getValue() < number.getValue() && number.getValue() <= 127 || 0 <= number.getValue() && number.getValue() < upperEdge.getValue();
        }
        return lowerEdge.getValue() < number.getValue() && number.getValue() < upperEdge.getValue();
    }

    public static class MessageSequenceEmptyWindowException
    extends IllegalStateException {
        public MessageSequenceEmptyWindowException(String message) {
            super(message);
        }
    }

    public static class MessageSequenceNumberException
    extends IllegalStateException {
        public MessageSequenceNumberException(String message) {
            super(message);
        }
    }

    public static class SccpFlowControlWindow {
        private int w;
        private SequenceNumber lowerEdge;

        public SccpFlowControlWindow(SequenceNumber lowerEdge, int size) {
            this.lowerEdge = lowerEdge;
            this.w = size;
        }

        public int getW() {
            return this.w;
        }

        public void setW(int w) {
            this.w = w;
        }

        public SequenceNumber getLowerEdge() {
            return this.lowerEdge;
        }

        public SequenceNumber getUpperEdge() {
            if (this.w == 0) {
                throw new MessageSequenceEmptyWindowException("Getting upper edge of window with w=0");
            }
            return new SequenceNumberImpl(this.lowerEdge.getValue() + this.w - 1, true);
        }

        public SequenceNumber getEarlyAckEdge() {
            if (this.w == 0) {
                throw new MessageSequenceEmptyWindowException("Getting early ack edge of window with w=0");
            }
            int earlyW = (int)((double)this.w * (this.w > 50 ? 0.5 : 0.1));
            if (earlyW == 0) {
                earlyW = 1;
            }
            return new SequenceNumberImpl(this.lowerEdge.getValue() + earlyW - 1, true);
        }

        public void setLowerEdge(SequenceNumber newLowerEdge) {
            if (newLowerEdge.equals(this.lowerEdge)) {
                return;
            }
            this.lowerEdge = newLowerEdge;
        }

        public boolean contains(SequenceNumber sendSequenceNumber) {
            if (this.w == 0) {
                return false;
            }
            SequenceNumber upperEdge = this.getUpperEdge();
            return SccpFlowControl.rangeContains(this.lowerEdge, upperEdge, sendSequenceNumber);
        }
    }
}

